/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.plaf.UIResource;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.switches.oem.OEMSwitches;

public class SHRadioButtonIcon
implements Icon,
UIResource {
    private static GeneralPath tick;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        JRadioButton button = (JRadioButton)c;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int size = SimpleHelpLookAndFeel.scale(16);
        int bufferX = (this.getIconWidth() - size) / 2;
        int bufferY = (this.getIconHeight() - size) / 2;
        AffineTransform at = g2d.getTransform();
        try {
            g2d.translate(x + bufferX, y + bufferY);
            Arc2D.Float outerCircle = new Arc2D.Float(0.0f, 0.0f, size, size, 0.0f, 360.0f, 0);
            if (!OEMSwitches.DARK_THEME) {
                g2d.setPaint(SHButtonUI.getFill(SHUI.BUTTON_NORMAL, c.isEnabled(), this.getIconHeight() - y, false));
            } else if (button.isSelected()) {
                g2d.setPaint(SHButtonUI.getFill(SHUI.BUTTON_BLUE, c.isEnabled(), this.getIconHeight() - y, false));
            } else {
                g2d.setPaint(SHButtonUI.getFill(SHUI.BUTTON_NORMAL, c.isEnabled(), this.getIconHeight() - y, false));
            }
            g2d.fill(outerCircle);
            g2d.setStroke(SHButtonUI.getBorderStroke());
            if (!OEMSwitches.DARK_THEME) {
                g2d.setColor(SHButtonUI.getBorderColor(SHUI.BUTTON_NORMAL, button.isEnabled()));
            } else if (button.isSelected()) {
                g2d.setColor(SHButtonUI.getBorderColor(SHUI.BUTTON_BLUE, button.isEnabled()));
            } else {
                g2d.setColor(SHButtonUI.getBorderColor(SHUI.BUTTON_NORMAL, button.isEnabled()));
            }
            g2d.draw(outerCircle);
            if (button.isSelected()) {
                int smallerCircleSize = SimpleHelpLookAndFeel.scale(6);
                g2d.translate((size - smallerCircleSize) / 2, (size - smallerCircleSize) / 2);
                Arc2D.Float innerCircle = new Arc2D.Float(0.0f, 0.0f, smallerCircleSize, smallerCircleSize, 0.0f, 360.0f, 0);
                g2d.setStroke(new BasicStroke(1.0f));
                if (button.isEnabled()) {
                    g2d.setColor(SHUI.RADIO_BLOB);
                } else {
                    g2d.setColor(SHUI.RADIO_BLOB_DISABLED);
                }
                g2d.fill(innerCircle);
                g2d.draw(innerCircle);
            }
        }
        finally {
            g2d.setTransform(at);
        }
    }

    @Override
    public int getIconWidth() {
        return SimpleHelpLookAndFeel.scale(16);
    }

    @Override
    public int getIconHeight() {
        return SimpleHelpLookAndFeel.scale(16);
    }

    static {
        double factor = SimpleHelpLookAndFeel.getScalingFactor();
        tick = new GeneralPath();
        tick.moveTo(factor * 3.0, factor * 8.0);
        tick.lineTo(factor * 6.0, factor * 12.0);
        tick.lineTo(factor * 12.0, factor * 4.0);
    }
}

