/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.validators;

import utils.swing.cui.validators.AbstractTextFieldValidator;

public class TextFieldLengthValidator
extends AbstractTextFieldValidator {
    private int max;
    private int min;

    public TextFieldLengthValidator(int max, int min) {
        this.min = min;
        this.max = max;
    }

    @Override
    protected boolean isValid(String contents) {
        if (this.min != -1 && this.min > contents.length()) {
            return false;
        }
        return this.max == -1 || this.max >= contents.length();
    }

    @Override
    public String getValidatorID() {
        return "textFieldLength";
    }

    @Override
    public String toXML() {
        return "<Validator type=\"" + this.getValidatorID() + "\">" + this.min + "," + this.max + "</Validator>";
    }
}

