/*
 * Decompiled with CFR 0.152.
 */
package utils.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import utils.stream.StreamUtils;

public class IconLoader {
    public static final int OVERLAY_ADD = 1;
    public static final int OVERLAY_ERROR = 2;
    public static final int OVERLAY_WARNING = 3;
    public static final int OVERLAY_REMOVE = 4;
    static HashMap cache = new HashMap();
    static HashMap disabledCache = new HashMap();
    public static final LightGrayFilter LIGHT_GRAY_FILTER = new LightGrayFilter(true, 40);
    public static String CUSTOM_ICON_PATH = null;

    public static byte[] getDataForIcon(String path) {
        try {
            File f;
            InputStream in = IconLoader.class.getResourceAsStream("/icons/" + path);
            if (in == null) {
                f = new File("icons/" + path);
                if (f.exists()) {
                    System.out.println();
                }
                in = new FileInputStream("icons/" + path);
            }
            if (in == null && CUSTOM_ICON_PATH != null) {
                f = new File(CUSTOM_ICON_PATH + path);
                in = f.exists() ? new FileInputStream(f) : IconLoader.class.getResourceAsStream(CUSTOM_ICON_PATH + path);
            }
            byte[] dat = StreamUtils.readAll(new BufferedInputStream(in));
            in.close();
            return dat;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ImageIcon loadDisabled(String string) {
        try {
            ImageIcon icon = (ImageIcon)disabledCache.get(string);
            if (icon == null) {
                Image image = IconLoader.load(string).getImage();
                Image grayImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), LIGHT_GRAY_FILTER));
                icon = new ImageIcon(grayImage);
                disabledCache.put(string, icon);
            }
            return icon;
        }
        catch (NullPointerException e) {
            System.out.println("ICON NOT FOUND: " + string);
            return null;
        }
    }

    public static Icon disableIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            Image i = ((ImageIcon)icon).getImage();
            Image grayImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(i.getSource(), LIGHT_GRAY_FILTER));
            return new ImageIcon(grayImage);
        }
        if (icon instanceof OverlayedIcon) {
            OverlayedIcon overlayed = (OverlayedIcon)icon;
            return new OverlayedIcon(IconLoader.disableIcon(overlayed.bottom), IconLoader.disableIcon(overlayed.top));
        }
        return null;
    }

    public static ImageIcon load(String path) {
        ImageIcon icon = (ImageIcon)cache.get(path);
        if (icon == null) {
            try {
                InputStream in = IconLoader.class.getResourceAsStream("/icons/" + path);
                if (in == null) {
                    File f;
                    if (CUSTOM_ICON_PATH != null) {
                        f = new File(CUSTOM_ICON_PATH + path);
                        in = f.exists() ? new FileInputStream(f) : IconLoader.class.getResourceAsStream(CUSTOM_ICON_PATH + path);
                    } else {
                        f = new File("icons/" + path);
                        in = new FileInputStream(f);
                    }
                }
                byte[] dat = StreamUtils.readAll(new BufferedInputStream(in));
                in.close();
                icon = new ImageIcon(dat);
                cache.put(path, icon);
                return icon;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return icon;
    }

    private static ImageIcon getOverlay(int type) {
        switch (type) {
            case 1: {
                return IconLoader.load("overlays/add_overlay.png");
            }
            case 2: {
                return IconLoader.load("overlays/error_overlay.png");
            }
            case 3: {
                return IconLoader.load("overlays/warning_overlay.png");
            }
            case 4: {
                return IconLoader.load("overlays/remove_overlay.png");
            }
        }
        return null;
    }

    public static Icon loadWithOverlay(String path, int overlayType) {
        ImageIcon icon = IconLoader.load(path);
        return IconLoader.applyOverlay(icon, overlayType);
    }

    public static Icon createOverlayedIcon(Icon icon, Icon overlay) {
        return new OverlayedIcon(icon, overlay);
    }

    public static Icon applyOverlay(Icon icon, int overlayType) {
        ImageIcon overlay = IconLoader.getOverlay(overlayType);
        if (overlay == null) {
            return icon;
        }
        if (icon instanceof OverlayedIcon || overlay instanceof OverlayedIcon) {
            throw new RuntimeException("Overlaying an overlayed icon is not a good idea");
        }
        return new OverlayedIcon(icon, overlay);
    }

    public static Icon removeOverlay(Icon icon) {
        if (icon instanceof OverlayedIcon) {
            return ((OverlayedIcon)icon).bottom;
        }
        return icon;
    }

    static class LightGrayFilter
    extends RGBImageFilter {
        private boolean brighter;
        private int percent;

        public LightGrayFilter(boolean b, int p) {
            this.brighter = b;
            this.percent = p;
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int gray = (int)((0.9 * (double)(rgb >> 16 & 0xFF) + 0.9 * (double)(rgb >> 8 & 0xFF) + 0.81 * (double)(rgb & 0xFF)) / 3.0);
            gray = this.brighter ? 255 - (255 - gray) * (100 - this.percent) / 100 : gray * (100 - this.percent) / 100;
            if (gray < 0) {
                gray = 0;
            }
            if (gray > 255) {
                gray = 255;
            }
            return rgb & 0xFF000000 | gray << 16 | gray << 8 | gray << 0;
        }
    }

    static class OverlayedIcon
    implements Icon {
        private Icon bottom = null;
        private Icon top = null;

        public OverlayedIcon(Icon bottom, Icon iconTop) {
            this.bottom = bottom;
            this.top = iconTop;
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            int xx = x + (this.bottom.getIconWidth() - this.top.getIconWidth());
            int yy = y + (this.bottom.getIconHeight() - this.top.getIconHeight());
            this.bottom.paintIcon(c, g, x, y);
            this.top.paintIcon(c, g, xx, yy);
        }

        @Override
        public int getIconHeight() {
            return Math.max(this.bottom.getIconHeight(), this.top.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return Math.max(this.bottom.getIconWidth(), this.top.getIconWidth());
        }
    }
}

