/*
 * Decompiled with CFR 0.152.
 */
package utils.string;

public class Normaliser {
    public static String stripChar(String s, char c) {
        StringBuffer sb = new StringBuffer();
        char[] tmp = s.toCharArray();
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i] == c) continue;
            sb.append(tmp[i]);
        }
        return sb.toString();
    }

    public static String removeWhitespace(String s) {
        StringBuffer sb = new StringBuffer();
        char[] tmp = s.toCharArray();
        for (int i = 0; i < tmp.length; ++i) {
            if (Character.isWhitespace(tmp[i])) continue;
            sb.append(tmp[i]);
        }
        return sb.toString();
    }

    public static String removeQuotes(String s) {
        while (s.startsWith("\"")) {
            s = s.substring(1);
        }
        while (s.startsWith("'")) {
            s = s.substring(1);
        }
        while (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        while (s.endsWith("'")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String normaliseShort(String s) {
        return Normaliser.normaliseToCharsAndDigits(s, false, false);
    }

    public static String normaliseLong(String s) {
        return Normaliser.normaliseToCharsAndDigits(s, true, false);
    }

    public static String safeWithoutNormalising(String s) {
        return Normaliser.normaliseToCharsAndDigits(s, true, true);
    }

    public static String normaliseToCharsAndDigits(String s, boolean keepLength, boolean noloss) {
        char[] cs = s.toCharArray();
        char[] ncs = new char[cs.length];
        int pos = 0;
        for (int i = 0; i < cs.length; ++i) {
            if (Character.isJavaIdentifierPart(cs[i])) {
                ncs[pos++] = cs[i];
                continue;
            }
            if (!keepLength) continue;
            ncs[pos++] = noloss ? (int)(65 + cs[i] % 26) : 95;
        }
        return new String(ncs, 0, pos);
    }
}

