/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import utils.translation.UtilMessages;

public class VariableLengthStreamUtils {
    public static void writeBytes(OutputStream out, byte[] b) throws IOException {
        VariableLengthStreamUtils.writeInt(out, b.length);
        out.write(b, 0, b.length);
    }

    public static void writeBytes(OutputStream out, byte[] b, int off, int len) throws IOException {
        VariableLengthStreamUtils.writeInt(out, len);
        out.write(b, off, len);
    }

    public static void writeString(OutputStream out, String n) throws IOException {
        VariableLengthStreamUtils.writeBytes(out, n.getBytes());
    }

    public static void writeByteNum(OutputStream out, int n) throws IOException {
        out.write((byte)n);
    }

    public static int readByteNum(InputStream in) throws IOException {
        int n = in.read();
        if (n == -1) {
            throw new EOFException(UtilMessages.getString("VariableLengthStreamUtils.0"));
        }
        return n;
    }

    public static void main(String[] args) throws IOException {
        Random r = new Random();
        boolean[] bools = new boolean[8];
        for (int n = 0; n < 1000; ++n) {
            for (int i = 0; i < bools.length; ++i) {
                bools[i] = r.nextBoolean();
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            VariableLengthStreamUtils.writeMasked(bout, bools);
            boolean[] sent = VariableLengthStreamUtils.readMasked(new ByteArrayInputStream(bout.toByteArray()));
            System.out.println("Processed " + n + ":");
            for (int i = 0; i < bools.length; ++i) {
                System.out.println(i + " = " + bools[i]);
                if (bools[i] == sent[i]) continue;
                throw new IOException("No matchy at index " + i + "!");
            }
        }
    }

    public static boolean[] readMasked(InputStream in) throws IOException {
        boolean[] bools = new boolean[8];
        byte temp = (byte)(in.read() & 0xFF);
        if ((temp & 1) > 0) {
            bools[0] = true;
        }
        if ((temp & 2) > 0) {
            bools[1] = true;
        }
        if ((temp & 4) > 0) {
            bools[2] = true;
        }
        if ((temp & 8) > 0) {
            bools[3] = true;
        }
        if ((temp & 0x10) > 0) {
            bools[4] = true;
        }
        if ((temp & 0x20) > 0) {
            bools[5] = true;
        }
        if ((temp & 0x40) > 0) {
            bools[6] = true;
        }
        if ((temp & 0x80) > 0) {
            bools[7] = true;
        }
        return bools;
    }

    public static void writeMasked(OutputStream out, boolean[] bools) throws IOException, ArrayIndexOutOfBoundsException {
        if (bools.length != 8) {
            throw new ArrayIndexOutOfBoundsException("bools must be exactly 8 long");
        }
        byte temp = 0;
        if (bools[0]) {
            temp = (byte)(temp ^ 1);
        }
        if (bools[1]) {
            temp = (byte)(temp ^ 2);
        }
        if (bools[2]) {
            temp = (byte)(temp ^ 4);
        }
        if (bools[3]) {
            temp = (byte)(temp ^ 8);
        }
        if (bools[4]) {
            temp = (byte)(temp ^ 0x10);
        }
        if (bools[5]) {
            temp = (byte)(temp ^ 0x20);
        }
        if (bools[6]) {
            temp = (byte)(temp ^ 0x40);
        }
        if (bools[7]) {
            temp = (byte)(temp ^ 0x80);
        }
        out.write(temp);
    }

    public static void writeBoolean(OutputStream out, boolean n) throws IOException {
        if (n) {
            out.write(255);
        } else {
            out.write(238);
        }
    }

    public static boolean readBoolean(InputStream in) throws IOException {
        int n = in.read();
        if (n == -1) {
            throw new EOFException(UtilMessages.getString("VariableLengthStreamUtils.1"));
        }
        return n == 255;
    }

    public static void writeIntArray(OutputStream out, int[] array) throws IOException {
        VariableLengthStreamUtils.writeInt(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            VariableLengthStreamUtils.writeInt(out, array[i]);
        }
    }

    public static void writeDoubleArray(OutputStream out, double[] array) throws IOException {
        VariableLengthStreamUtils.writeInt(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            VariableLengthStreamUtils.writeDouble(out, array[i]);
        }
    }

    public static void writeLongArray(OutputStream out, long[] array) throws IOException {
        VariableLengthStreamUtils.writeInt(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            VariableLengthStreamUtils.writeLong(out, array[i]);
        }
    }

    public static void readIntArray(InputStream inStream, int[] array) throws IOException {
        int length = VariableLengthStreamUtils.readInt(inStream);
        for (int i = 0; i < length; ++i) {
            array[i] = VariableLengthStreamUtils.readInt(inStream);
        }
    }

    public static int[] readIntArray(InputStream inStream) throws IOException {
        int length = VariableLengthStreamUtils.readInt(inStream);
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = VariableLengthStreamUtils.readInt(inStream);
        }
        return array;
    }

    public static void readDoubleArray(InputStream inStream, double[] array) throws IOException {
        int length = VariableLengthStreamUtils.readInt(inStream);
        for (int i = 0; i < length; ++i) {
            array[i] = VariableLengthStreamUtils.readDouble(inStream);
        }
    }

    public static double[] readDoubleArray(InputStream inStream) throws IOException {
        int length = VariableLengthStreamUtils.readInt(inStream);
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = VariableLengthStreamUtils.readDouble(inStream);
        }
        return array;
    }

    public static void readLongArray(InputStream inStream, long[] array) throws IOException {
        int length = VariableLengthStreamUtils.readInt(inStream);
        for (int i = 0; i < length; ++i) {
            array[i] = VariableLengthStreamUtils.readLong(inStream);
        }
    }

    public static long[] readLongArray(InputStream inStream) throws IOException {
        int length = VariableLengthStreamUtils.readInt(inStream);
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = VariableLengthStreamUtils.readLong(inStream);
        }
        return array;
    }

    public static byte[] readBytes(InputStream in, int len) throws IOException {
        byte[] b = new byte[len];
        int red = 0;
        for (int tot = 0; tot < len; tot += red) {
            red = in.read(b, tot, len - tot);
            if (red != -1) continue;
            throw new EOFException(UtilMessages.getString("VariableLengthStreamUtils.2"));
        }
        return b;
    }

    public static byte[] readLine(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int last = -1;
        int c = in.read();
        if (c == -1) {
            throw new IOException(UtilMessages.getString("VariableLengthStreamUtils.3"));
        }
        while (c != 10 && c != -1) {
            if (last != -1) {
                bout.write(last);
            }
            last = c;
            c = in.read();
        }
        if (last != -1 && last != 13) {
            bout.write(last);
        }
        return bout.toByteArray();
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        int len = VariableLengthStreamUtils.readInt(in);
        byte[] b = new byte[len];
        int red = 0;
        for (int tot = 0; tot < len; tot += red) {
            red = in.read(b, tot, len - tot);
            if (red != -1) continue;
            throw new EOFException(UtilMessages.getString("VariableLengthStreamUtils.4"));
        }
        return b;
    }

    public static String readString(InputStream in) throws IOException {
        return new String(VariableLengthStreamUtils.readBytes(in));
    }

    public static byte[] readNBytes(InputStream in, int maxlen) throws IOException {
        int len = VariableLengthStreamUtils.readInt(in);
        if (len < 0) {
            throw new IOException(UtilMessages.getString("VariableLengthStreamUtils.5") + len + UtilMessages.getString("VariableLengthStreamUtils.6"));
        }
        if (len > maxlen) {
            throw new IOException(UtilMessages.getString("VariableLengthStreamUtils.7") + len + UtilMessages.getString("VariableLengthStreamUtils.8"));
        }
        byte[] b = new byte[len];
        int red = 0;
        for (int tot = 0; tot < len; tot += red) {
            red = in.read(b, tot, len - tot);
            if (red != -1) continue;
            throw new EOFException(UtilMessages.getString("VariableLengthStreamUtils.9"));
        }
        return b;
    }

    public static String readNString(InputStream in, int maxlen) throws IOException {
        return new String(VariableLengthStreamUtils.readNBytes(in, maxlen));
    }

    public static void writeDouble(OutputStream out, double n) throws IOException {
        VariableLengthStreamUtils.writeLong(out, Double.doubleToLongBits(n));
    }

    public static double readDouble(InputStream in) throws IOException {
        long l = VariableLengthStreamUtils.readLong(in);
        return Double.longBitsToDouble(l);
    }

    public static void writeFloat(OutputStream out, float n) throws IOException {
        VariableLengthStreamUtils.writeInt(out, Float.floatToIntBits(n));
    }

    public static float readFloat(InputStream in) throws IOException {
        int i = VariableLengthStreamUtils.readInt(in);
        return Float.intBitsToFloat(i);
    }

    public static void writeInt(OutputStream out, int n) throws IOException {
        if ((n & 0xFF000000) != 0) {
            VariableLengthStreamUtils.writeByteNum(out, 4);
            out.write((byte)(n >>> 24));
            out.write((byte)(n >>> 16));
            out.write((byte)(n >>> 8));
            out.write((byte)n);
        } else if ((n & 0xFF0000) != 0) {
            VariableLengthStreamUtils.writeByteNum(out, 3);
            out.write((byte)(n >>> 16));
            out.write((byte)(n >>> 8));
            out.write((byte)n);
        } else if ((n & 0xFF00) != 0) {
            VariableLengthStreamUtils.writeByteNum(out, 2);
            out.write((byte)(n >>> 8));
            out.write((byte)n);
        } else if ((n & 0xFF) != 0) {
            VariableLengthStreamUtils.writeByteNum(out, 1);
            out.write((byte)n);
        } else {
            VariableLengthStreamUtils.writeByteNum(out, 0);
        }
    }

    public static int readInt(InputStream in) throws IOException {
        int bytes = VariableLengthStreamUtils.readByteNum(in);
        int n = 0;
        int r = 0;
        for (int i = 0; i < bytes; ++i) {
            r = in.read();
            if (r == -1) {
                throw new EOFException(UtilMessages.getString("VariableLengthStreamUtils.10"));
            }
            n = n << 8 | r;
        }
        return n;
    }

    public static void writeLong(OutputStream out, long n) throws IOException {
        if ((n & 0xFF00000000000000L) != 0L) {
            VariableLengthStreamUtils.writeByteNum(out, 8);
            out.write((byte)(n >>> 56));
            out.write((byte)(n >>> 48));
            out.write((byte)(n >>> 40));
            out.write((byte)(n >>> 32));
            out.write((byte)(n >>> 24));
            out.write((byte)(n >>> 16));
            out.write((byte)(n >>> 8));
            out.write((byte)n);
        } else if ((n & 0xFF000000000000L) != 0L) {
            VariableLengthStreamUtils.writeByteNum(out, 7);
            out.write((byte)(n >>> 48));
            out.write((byte)(n >>> 40));
            out.write((byte)(n >>> 32));
            out.write((byte)(n >>> 24));
            out.write((byte)(n >>> 16));
            out.write((byte)(n >>> 8));
            out.write((byte)n);
        } else if ((n & 0xFF0000000000L) != 0L) {
            VariableLengthStreamUtils.writeByteNum(out, 6);
            out.write((byte)(n >>> 40));
            out.write((byte)(n >>> 32));
            out.write((byte)(n >>> 24));
            out.write((byte)(n >>> 16));
            out.write((byte)(n >>> 8));
            out.write((byte)n);
        } else if ((n & 0xFF00000000L) != 0L) {
            VariableLengthStreamUtils.writeByteNum(out, 5);
            out.write((byte)(n >>> 32));
            out.write((byte)(n >>> 24));
            out.write((byte)(n >>> 16));
            out.write((byte)(n >>> 8));
            out.write((byte)n);
        } else if ((n & 0xFF000000L) != 0L) {
            VariableLengthStreamUtils.writeByteNum(out, 4);
            out.write((byte)(n >>> 24));
            out.write((byte)(n >>> 16));
            out.write((byte)(n >>> 8));
            out.write((byte)n);
        } else if ((n & 0xFF0000L) != 0L) {
            VariableLengthStreamUtils.writeByteNum(out, 3);
            out.write((byte)(n >>> 16));
            out.write((byte)(n >>> 8));
            out.write((byte)n);
        } else if ((n & 0xFF00L) != 0L) {
            VariableLengthStreamUtils.writeByteNum(out, 2);
            out.write((byte)(n >>> 8));
            out.write((byte)n);
        } else if ((n & 0xFFL) != 0L) {
            VariableLengthStreamUtils.writeByteNum(out, 1);
            out.write((byte)n);
        } else {
            VariableLengthStreamUtils.writeByteNum(out, 0);
        }
    }

    public static long readLong(InputStream in) throws IOException {
        int bytes = VariableLengthStreamUtils.readByteNum(in);
        long n = 0L;
        int r = 0;
        for (int i = 0; i < bytes; ++i) {
            r = in.read();
            if (r == -1) {
                throw new EOFException(UtilMessages.getString("VariableLengthStreamUtils.11"));
            }
            n = n << 8 | (long)r;
        }
        return n;
    }

    public static void writeShort(OutputStream out, short n) throws IOException {
        if (((long)n & 0xFF00L) != 0L) {
            VariableLengthStreamUtils.writeByteNum(out, 2);
            out.write((byte)(n >>> 8));
            out.write((byte)n);
        } else if (((long)n & 0xFFL) != 0L) {
            VariableLengthStreamUtils.writeByteNum(out, 1);
            out.write((byte)n);
        } else {
            VariableLengthStreamUtils.writeByteNum(out, 0);
        }
    }

    public static short readShort(InputStream in) throws IOException {
        int bytes = VariableLengthStreamUtils.readByteNum(in);
        short n = 0;
        int r = 0;
        for (int i = 0; i < bytes; ++i) {
            r = in.read();
            if (r == -1) {
                throw new EOFException(UtilMessages.getString("VariableLengthStreamUtils.12"));
            }
            n = (short)(n << 8 | r);
        }
        return n;
    }

    public static void writeChar(OutputStream out, char v) throws IOException {
        out.write((byte)(0xFF & v >> 8));
        out.write((byte)(0xFF & v));
    }

    public static char readChar(InputStream in) throws IOException {
        int a = in.read();
        int b = in.read();
        if (a == -1 || b == -1) {
            throw new EOFException(UtilMessages.getString("VariableLengthStreamUtils.13"));
        }
        return (char)(a << 8 | b & 0xFF);
    }
}

