/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class Counter<K> {
    HashMap<K, Double> map = new HashMap();
    private ArrayList<Pair> pairs = new ArrayList();
    private boolean been_sorted = false;
    private boolean sort_by_value = false;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<K> keys = this.getSortedKeys();
        for (K key : keys) {
            sb.append("key=[").append(key).append("] value=[").append(this.get(key)).append("]\n");
        }
        return sb.toString();
    }

    public String toString(double min, double max, DecimalFormat df) {
        StringBuilder sb = new StringBuilder();
        ArrayList<K> keys = this.getSortedKeys();
        for (K key : keys) {
            double val = this.get(key);
            if (!(val > min) || !(val < max)) continue;
            sb.append("key=[").append(key).append("] value=[").append(df.format(val)).append("]\n");
        }
        return sb.toString();
    }

    public Double get(K key) {
        return this.map.get(key);
    }

    public int getInt(K key) {
        return this.map.get(key).intValue();
    }

    public int getInt(K key, int def) {
        try {
            return this.map.get(key).intValue();
        }
        catch (Exception x) {
            return def;
        }
    }

    public void add(K key, double val) {
        Double oldval = this.map.get(key);
        if (oldval == null) {
            this.map.put(key, val);
        } else {
            this.map.put(key, oldval + val);
        }
    }

    public void set(K key, double val) {
        this.map.put(key, val);
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    private void getPairList() {
        this.pairs = new ArrayList();
        for (K key : this.map.keySet()) {
            Pair pair = new Pair();
            pair.key = key;
            pair.value = this.map.get(key);
            this.pairs.add(pair);
        }
    }

    public Counter sortByKey(boolean ascending) {
        this.getPairList();
        this.been_sorted = true;
        this.sort_by_value = false;
        Collections.sort(this.pairs, new Pair());
        if (!ascending) {
            Collections.reverse(this.pairs);
        }
        return this;
    }

    public Counter sortByValue(boolean ascending) {
        this.getPairList();
        this.been_sorted = true;
        this.sort_by_value = true;
        Collections.sort(this.pairs, new Pair());
        if (ascending) {
            Collections.reverse(this.pairs);
        }
        return this;
    }

    public ArrayList<K> getSortedKeys() {
        ArrayList keys = new ArrayList();
        for (Pair pair : this.pairs) {
            keys.add(pair.key);
        }
        return keys;
    }

    class Pair
    implements Comparator<Pair> {
        K key;
        Double value;

        Pair() {
        }

        @Override
        public int compare(Pair p1, Pair p2) {
            if (Counter.this.sort_by_value) {
                double d = p2.value - p1.value;
                if (d < 0.0) {
                    return -1;
                }
                if (d == 0.0) {
                    return 0;
                }
                return 1;
            }
            return String.valueOf(p1.key).compareTo(String.valueOf(p2.key));
        }
    }
}

