/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import utils.progtools.BoutPool;

public class BestCaseCompressor {
    public static boolean DEBUG = false;
    static BoutPool bpool = new BoutPool(10, 100000);

    public static void writeUncompressed(byte[] dat, int off, int len, OutputStream out) throws IOException {
        out.write(8);
        out.write(dat, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] packageUncompressed(byte[] dat, int off, int len) throws IOException {
        ByteArrayOutputStream bout = bpool.getBout();
        try {
            bout.write(8);
            bout.write(dat, off, len);
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        finally {
            bpool.done(bout);
        }
    }

    public static byte[] compress(byte[] dat) {
        return BestCaseCompressor.compress(dat, 0, dat.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] dat, int off, int len) {
        ByteArrayOutputStream bout = bpool.getBout();
        try {
            int blen;
            bout.write(9);
            if (len <= 23) {
                blen = len + 1;
            } else {
                GZIPOutputStream gout = new GZIPOutputStream(bout);
                gout.write(dat, off, len);
                gout.close();
                blen = bout.size();
            }
            if (blen > len) {
                bout.reset();
                bout.write(8);
                bout.write(dat, off, len);
                if (DEBUG) {
                    System.out.println("[BestCaseCompressor] wrote uncompressed " + bout.size());
                }
            } else if (DEBUG) {
                double fraction = (double)bout.size() / (double)len;
                fraction *= 10000.0;
                fraction = (int)fraction;
                System.out.println("[BestCaseCompressor] wrote compressed " + bout.size() + " (" + (fraction /= 100.0) + "%)");
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        catch (IOException x) {
            x.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            bpool.done(bout);
        }
    }

    public static byte[] decompress(byte[] dat) {
        try {
            if (dat[0] == 8) {
                byte[] tmp = new byte[dat.length - 1];
                System.arraycopy(dat, 1, tmp, 0, dat.length - 1);
                if (DEBUG) {
                    System.out.println("[BestCaseCompressor] returned uncompressed " + tmp.length);
                }
                return tmp;
            }
            if (dat[0] == 9) {
                ByteArrayInputStream bin = new ByteArrayInputStream(dat, 1, dat.length - 1);
                GZIPInputStream gin = new GZIPInputStream(bin);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                byte[] buf = new byte[50000];
                int n = 0;
                while (n != -1) {
                    n = gin.read(buf);
                    if (n <= 0) continue;
                    bout.write(buf, 0, n);
                }
                byte[] ret = bout.toByteArray();
                if (DEBUG) {
                    System.out.println("[BestCaseCompressor] returned decompressed " + ret.length);
                }
                return ret;
            }
            throw new IOException("Invalid data");
        }
        catch (IOException x) {
            x.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 100; ++i) {
            byte[] test = new byte[i];
            System.out.println(BestCaseCompressor.compress(BestCaseCompressor.decompress(BestCaseCompressor.compress(test))).length);
        }
        byte[] test = new byte[100000];
        System.out.println(BestCaseCompressor.compress(BestCaseCompressor.decompress(BestCaseCompressor.compress(test))).length);
    }
}

