/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats;

import java.util.regex.Pattern;
import utils.message.Message;
import utils.osstats.types.BasicInfo;

public interface Stats {
    public void update();

    public void updateLight();

    public String killProcess(String var1);

    public void killProcessListeningOn(int var1, boolean var2, boolean var3);

    public double getCpuUsagePercent();

    public double getMemoryUsed();

    public double getMemoryFree();

    public double getMemoryUsedPercent();

    public double getMaxDiskUsagePercent(long var1, Pattern[] var3, boolean var4, StringBuffer var5);

    public DiskSpaceStatistic[] getMeaningfulDriveList(Pattern[] var1, boolean var2);

    public double getWifiSignalPercent();

    public double getWifiMbitRate();

    public BasicInfo getBasicInfo();

    public DiskSpaceStatistic[] getDiskSpaceStatistic();

    public ProcessStatistic[] getProcessStatistics();

    public void saveToMessage(Message var1);

    public void loadFromMessage(Message var1);

    public long getUptimeMs();

    public int getBatteryPercent();

    public static class DiskSpaceStatistic {
        public String name;
        public long used;
        public long free;
        public boolean isRecovery;
        public boolean isShared;

        public String toString() {
            return this.name;
        }

        public double getDiskUsagePercent() {
            return 100.0 * (double)this.used / (double)(this.used + this.free);
        }

        public boolean equals(Object o) {
            return o instanceof DiskSpaceStatistic && ((DiskSpaceStatistic)o).name.equals(this.name);
        }
    }

    public static class LocalPort {
        public String ip;
        public boolean tcp;
        public boolean udp;
        public int port;
        public int pid;
    }

    public static class ProcessStatistic {
        public String id;
        public int cpuPercentage;
        public int memPercentage;
        public String user;
        public String name;
        public String cmdLineNoArgs;
        public String cmdLineArgs;

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            return o instanceof ProcessStatistic && ((ProcessStatistic)o).id.equals(this.id);
        }

        public void updateWith(ProcessStatistic statistic) {
            this.cpuPercentage = statistic.cpuPercentage;
            this.memPercentage = statistic.memPercentage;
        }
    }
}

