/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import utils.message.Message;
import utils.osstats.AbstractStats;
import utils.osstats.Stats;
import utils.osstats.StatsUtil;
import utils.ostools.RunCommandGetOutput;
import utils.string.CharStack;
import utils.string.Chunker;

public class MacOSStats
extends AbstractStats {
    public static final long PAGE_SIZE = 4096L;

    public MacOSStats() {
        super(false, false);
    }

    public MacOSStats(boolean fake, boolean memoryOnly) {
        super(fake, memoryOnly);
    }

    public MacOSStats(Message loadFromMessage) {
        this.loadFromMessage(loadFromMessage);
    }

    @Override
    public void updateLight() {
        if (this.isFake) {
            Random r = new Random();
            this.usedMemoryBytes = (long)(r.nextDouble() * (double)this.basicInfo.memoryTotalBytes);
            this.cpuPercentage = Math.random() * 95.0;
            return;
        }
        this.updateCPUPercentage();
        this.updateUsedMemory();
    }

    private void updateUsedMemory() {
        try {
            int colon;
            long page_pageable_internal_count = 0L;
            RunCommandGetOutput.CommandResponse response = RunCommandGetOutput.runCommand(new String[]{"sysctl", "vm.page_pageable_internal_count"});
            if (response != null && response.stdout.startsWith("vm.page_pageable_internal_count:") && (colon = response.stdout.indexOf(58)) != -1) {
                page_pageable_internal_count = Long.parseLong(response.stdout.substring(colon + 1).trim());
            }
            if ((response = RunCommandGetOutput.runCommand(new String[]{"vm_stat"})) != null) {
                int pagesFree = 0;
                int pagesInactive = 0;
                int pagesSpeculative = 0;
                int pagesPurcheable = 0;
                int pagesOccupiedByCompressor = 0;
                int pagesWiredDown = 0;
                CharStack stack = new CharStack(response.stdout);
                while (!stack.isEmpty()) {
                    String key = stack.popUntil(':', true).trim();
                    stack.pop();
                    String value = stack.popLine(true).trim();
                    if (value.endsWith(".")) {
                        value = value.substring(0, value.length() - 1);
                    }
                    if (key.equalsIgnoreCase("pages free")) {
                        pagesFree = Integer.parseInt(value);
                        continue;
                    }
                    if (key.equalsIgnoreCase("pages speculative")) {
                        pagesSpeculative = Integer.parseInt(value);
                        continue;
                    }
                    if (key.equalsIgnoreCase("pages purgeable")) {
                        pagesPurcheable = Integer.parseInt(value);
                        continue;
                    }
                    if (key.equalsIgnoreCase("pages inactive")) {
                        pagesInactive = Integer.parseInt(value);
                        continue;
                    }
                    if (key.equalsIgnoreCase("pages occupied by compressor")) {
                        pagesOccupiedByCompressor = Integer.parseInt(value);
                        continue;
                    }
                    if (!key.equalsIgnoreCase("pages wired down")) continue;
                    pagesWiredDown = Integer.parseInt(value);
                }
                if (page_pageable_internal_count > 0L) {
                    long appMemory = page_pageable_internal_count - (long)pagesPurcheable;
                    this.usedMemoryBytes = (appMemory + (long)pagesWiredDown + (long)pagesOccupiedByCompressor) * 4096L;
                } else {
                    long free = (long)pagesFree * 4096L;
                    this.usedMemoryBytes = this.basicInfo.memoryTotalBytes - free;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateCPUPercentage() {
        try {
            RunCommandGetOutput.CommandResponse response = RunCommandGetOutput.runCommand(new String[]{"iostat", "-C", "-n0", "-c2"});
            if (response != null && response.stdout != null) {
                CharStack charStack = new CharStack(response.stdout);
                charStack.popUntil('\n', false);
                charStack.popWhitespace();
                charStack.popUntil('\n', false);
                charStack.popWhitespace();
                charStack.popUntil('\n', false);
                charStack.popWhitespace();
                double user = charStack.popNumber();
                charStack.popWhitespace();
                double system = charStack.popNumber();
                charStack.popWhitespace();
                double idle = charStack.popNumber();
                this.cpuPercentage = 100.0 - idle;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void update() {
        CharStack charStack;
        RunCommandGetOutput.CommandResponse response;
        if (this.isFake) {
            Random r = new Random();
            this.usedMemoryBytes = (long)(r.nextDouble() * (double)this.basicInfo.memoryTotalBytes);
            this.cpuPercentage = Math.random() * 95.0;
            this.diskSpaceStatistics = new Stats.DiskSpaceStatistic[0];
            this.processStatistics = new Stats.ProcessStatistic[0];
            this.wifiPercentage = Math.random() * 75.0;
            this.wifiMbit = 9.0 + Math.random() * 50.0;
            this.batteryPercentage = 75;
        }
        this.updateCPUPercentage();
        try {
            response = RunCommandGetOutput.runCommand(new String[]{"df", "-k", "-P"});
            if (response != null && response.stdout != null) {
                charStack = new CharStack(response.stdout);
                charStack.popUntil('\n', false);
                charStack.popWhitespace();
                ArrayList<Stats.DiskSpaceStatistic> disks = new ArrayList<Stats.DiskSpaceStatistic>();
                while (!charStack.isEmpty()) {
                    String diskName = charStack.popText(true);
                    charStack.popWhitespace();
                    while (!charStack.isNextNumber()) {
                        diskName = diskName + charStack.popText(true);
                        charStack.popWhitespace();
                    }
                    long size = charStack.popInteger();
                    charStack.popWhitespace();
                    long used = charStack.popInteger();
                    charStack.popWhitespace();
                    long free = charStack.popInteger();
                    charStack.popWhitespace();
                    double pused = charStack.popNumber();
                    charStack.pop();
                    charStack.popWhitespace();
                    String mount = charStack.popText(true);
                    charStack.popUntil('\n', false);
                    charStack.popWhitespace();
                    if (free == 0L && used == 0L || mount.equals("/dev")) continue;
                    Stats.DiskSpaceStatistic ds = new Stats.DiskSpaceStatistic();
                    ds.name = mount + " (" + diskName + ")";
                    ds.free = free * 1024L;
                    ds.used = used * 1024L;
                    disks.add(ds);
                }
                this.diskSpaceStatistics = new Stats.DiskSpaceStatistic[disks.size()];
                disks.toArray(this.diskSpaceStatistics);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            response = RunCommandGetOutput.runCommand(new String[]{"ps", "-axo pcpu,pmem,pid,user,rss,command"});
            if (response != null && response.stdout != null) {
                charStack = new CharStack(response.stdout);
                charStack.popUntil('\n', false);
                charStack.popWhitespace();
                ArrayList processes = new ArrayList();
                while (!charStack.isEmpty()) {
                    double pcpu = charStack.popNumber();
                    charStack.popWhitespace();
                    double pmem = charStack.popNumber();
                    charStack.popWhitespace();
                    int pid = (int)charStack.popInteger();
                    charStack.popWhitespace();
                    String username = charStack.popText(true);
                    charStack.popWhitespace();
                    long rss = charStack.popInteger();
                    charStack.popWhitespace();
                    String command = charStack.popUntil('\n', true);
                    charStack.popWhitespace();
                    Stats.ProcessStatistic ps = new Stats.ProcessStatistic();
                    ps.cmdLineNoArgs = command;
                    ps.cmdLineArgs = command;
                    ps.cpuPercentage = (int)pcpu;
                    ps.memPercentage = (int)pmem;
                    ps.id = Integer.toString(pid);
                    ps.user = username;
                    ps.name = command.indexOf(47) == -1 ? command : command.substring(command.lastIndexOf("/") + 1);
                    processes.add(ps);
                }
                response = RunCommandGetOutput.runCommand(new String[]{"ps", "-axo pid,comm"});
                if (response != null && response.stdout != null) {
                    charStack = new CharStack(response.stdout);
                    charStack.popUntil('\n', false);
                    charStack.popWhitespace();
                    block13: while (!charStack.isEmpty()) {
                        int pid = (int)charStack.popInteger();
                        String id = Integer.toString(pid);
                        charStack.popWhitespace();
                        String command = charStack.popUntil('\n', true);
                        charStack.popWhitespace();
                        Iterator used = processes.iterator();
                        while (used.hasNext()) {
                            Stats.ProcessStatistic stat = (Stats.ProcessStatistic)used.next();
                            if (!stat.id.equals(id)) continue;
                            stat.cmdLineNoArgs = command;
                            if (command.indexOf(47) == -1) {
                                stat.name = command;
                                continue block13;
                            }
                            stat.name = command.substring(command.lastIndexOf("/") + 1);
                            continue block13;
                        }
                    }
                }
                this.processStatistics = new Stats.ProcessStatistic[processes.size()];
                processes.toArray(this.processStatistics);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.updateUsedMemory();
        try {
            response = RunCommandGetOutput.runCommand(new String[]{"/System/Library/PrivateFrameworks/Apple80211.framework/Versions/Current/Resources/airport", "-I"});
            if (response != null) {
                String[] lines = response.stdout.split("\n");
                for (String line : lines) {
                    if ((line = line.trim()).startsWith("agrCtlRSSI")) {
                        double dbm = Double.parseDouble(line.substring(line.indexOf(58) + 1).trim());
                        dbm += 100.0;
                        this.wifiPercentage = dbm *= 2.0;
                    }
                    if (!line.startsWith("lastTxRate")) continue;
                    this.wifiMbit = Double.parseDouble(line.substring(line.indexOf(58) + 1).trim());
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        try {
            response = RunCommandGetOutput.runCommand(new String[]{"ioreg", "-n", "AppleSmartBattery", "-r"});
            if (response != null) {
                String maxCapacity;
                String output = response.stdout;
                HashMap<String, String> keyValueMap = StatsUtil.parseIntoKeyValueMap(output, "=");
                String currentCapacity = keyValueMap.get("CurrentCapacity");
                if (currentCapacity == null) {
                    currentCapacity = keyValueMap.get("Current");
                }
                if ((maxCapacity = keyValueMap.get("MaxCapacity")) == null) {
                    maxCapacity = keyValueMap.get("Capacity");
                }
                this.batteryPercentage = 0;
                try {
                    int current = Integer.parseInt(currentCapacity);
                    int max = Integer.parseInt(maxCapacity);
                    this.batteryPercentage = current * 100 / max;
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public String killProcess(String pid) {
        RunCommandGetOutput.CommandResponse response = RunCommandGetOutput.runCommand(new String[]{"kill", "-9", "" + pid});
        if (response != null) {
            if (response.returnCode == 0) {
                return null;
            }
            return response.stderr;
        }
        return null;
    }

    @Override
    public void killProcessListeningOn(int port, boolean tcp, boolean udp) {
        String[] lines;
        String[] output = RunCommandGetOutput.runCommandGetOutput(new String[]{"lsof", "-Pnl", "+M", "-i4:" + port, "+c", "1"});
        String stdout = output[0];
        for (String line : lines = stdout.split("\n")) {
            line = line.substring(8);
            ArrayList<String> chunks = Chunker.chunk(line, false, true);
            try {
                String pid = chunks.get(0);
                String protocol = chunks.get(6);
                String local = chunks.get(7);
                int next = local.indexOf("-");
                if (next != -1) {
                    local = local.substring(0, next);
                }
                System.out.println(line);
                System.out.println(pid + " - (" + protocol + ") " + local);
                local = local.substring(local.lastIndexOf(":") + 1);
                int lport = Integer.parseInt(local);
                boolean mustKill = false;
                if (tcp && protocol.equalsIgnoreCase("tcp") && lport == port) {
                    mustKill = true;
                }
                if (udp && protocol.equalsIgnoreCase("udp") && lport == port) {
                    mustKill = true;
                }
                if (!mustKill) continue;
                System.out.println("Killing process " + pid);
                this.killProcess(pid);
            }
            catch (Exception x) {
                System.out.println("Ignored: " + line);
            }
        }
    }

    public static Stats.LocalPort[] getListeningApplications() {
        return MacOSStats.getListeningApplication(-1);
    }

    public static Stats.LocalPort[] getListeningApplication(int port) {
        String[] output = port != -1 ? RunCommandGetOutput.runCommandGetOutput(new String[]{"lsof", "-Pnl", "+M", "-i:" + port, "+c", "1"}) : RunCommandGetOutput.runCommandGetOutput(new String[]{"lsof", "-Pnl", "+M", "-i", "+c", "1"});
        String stdout = output[0];
        String[] lines = stdout.split("\n");
        ArrayList<Stats.LocalPort> results = new ArrayList<Stats.LocalPort>();
        boolean first = true;
        for (String line : lines) {
            if (first) {
                first = false;
                continue;
            }
            line = line.substring(8);
            ArrayList<String> chunks = Chunker.chunk(line, false, true);
            try {
                Stats.LocalPort result;
                block11: {
                    result = new Stats.LocalPort();
                    result.pid = Integer.parseInt(chunks.get(0));
                    String protocol = chunks.get(6);
                    if (protocol.equalsIgnoreCase("tcp")) {
                        if (!line.contains("LISTEN")) continue;
                        result.tcp = true;
                    } else if (protocol.equalsIgnoreCase("udp")) {
                        result.udp = true;
                    }
                    if (port == -1) {
                        String local = chunks.get(7);
                        int next = local.indexOf("-");
                        if (next != -1) {
                            local = local.substring(0, next);
                        }
                        result.ip = local.substring(0, local.lastIndexOf(58));
                        local = local.substring(local.lastIndexOf(":") + 1);
                        try {
                            result.port = Integer.parseInt(local);
                            break block11;
                        }
                        catch (NumberFormatException e) {
                            continue;
                        }
                    }
                    result.port = port;
                }
                results.add(result);
            }
            catch (Exception x) {
                System.out.println("Ignored: " + line);
                x.printStackTrace();
            }
        }
        return results.toArray(new Stats.LocalPort[0]);
    }

    private static String toGB(double bytes) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(2);
        return nf.format(bytes / 1024.0 / 1024.0 / 1024.0);
    }

    public static void main(String[] args) throws InterruptedException {
        MacOSStats stats = new MacOSStats();
        while (true) {
            double used = stats.getMemoryUsed();
            double free = stats.getMemoryFree();
            double total = used + free;
            stats.update();
            System.out.println("Used: " + MacOSStats.toGB(used) + " Free: " + MacOSStats.toGB(free) + " Total: " + MacOSStats.toGB(total));
            Thread.sleep(1000L);
        }
    }
}

