/*
 * Decompiled with CFR 0.152.
 */
package utils.message.mappedfile;

import java.io.IOException;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.message.mappedfile.MessageHandler;
import utils.progtools.StackTracer;
import utils.stream.MappedChannel;

public class MFMessageHandler {
    public static final int COMMAND_PRINTSTDOUT = 0;
    public static final int COMMAND_PRINTSTDERR = 1;
    private MappedChannel mappedChannel;
    private MessageHandler handler;

    public MFMessageHandler(MappedChannel mappedFile, MessageHandler handler) {
        if (handler == null) {
            handler = new NullMessageHandler();
        }
        this.mappedChannel = mappedFile;
        this.handler = handler;
        if (mappedFile == null || handler == null) {
            System.out.println("[MRMessageHandler] WARNING: mappedFile or handler are null! (" + mappedFile + ") (" + handler + ")");
            return;
        }
        new MessageReader().start();
    }

    public void println(String s) {
        System.out.println("(Proxying)" + s);
        Message m = new Message(0);
        m.append(s);
        this.sendMessage(m);
    }

    public void printStackTrace(Throwable t) {
        System.out.println("(Proxying)" + t);
        t.printStackTrace();
        Message m = new Message(1);
        m.append(StackTracer.getStacktrace(t));
        this.sendMessage(m);
    }

    public void sendMessage(Message sendMessage) {
        byte[] block = MessageUtils.messageToBytes(sendMessage);
        try {
            this.mappedChannel.writeBlock(block);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.handler.closed();
        }
    }

    public void close() {
        try {
            System.out.println("[MFMessageHandler] Closing mapped channel");
            if (this.mappedChannel != null) {
                this.mappedChannel.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class MessageReader
    extends Thread {
        public MessageReader() {
            super("MFMessageReader");
        }

        @Override
        public void run() {
            block6: while (true) {
                byte[] block;
                try {
                    block = MFMessageHandler.this.mappedChannel.readBlock();
                }
                catch (IOException e) {
                    System.out.println("[MFMessageHandler] Mapped file closed.");
                    e.printStackTrace();
                    MFMessageHandler.this.handler.closed();
                    return;
                }
                Message bytesToMessage = MessageUtils.bytesToMessage(block);
                if (bytesToMessage == null) {
                    System.out.println("[MFMessageHandler] Could not read block (" + block.length + " bytes)");
                    continue;
                }
                System.out.println("[MFMessageHandler] Got message of type " + bytesToMessage.getType());
                switch (bytesToMessage.getType()) {
                    case 0: {
                        String s = bytesToMessage.getAsString(0);
                        System.out.println(s);
                        continue block6;
                    }
                    case 1: {
                        String s = bytesToMessage.getAsString(0);
                        System.err.println(s);
                        continue block6;
                    }
                }
                MFMessageHandler.this.handler.handleMessage(bytesToMessage);
            }
        }
    }

    class NullMessageHandler
    implements MessageHandler {
        NullMessageHandler() {
        }

        @Override
        public void handleMessage(Message bytesToMessage) {
        }

        @Override
        public void closed() {
        }
    }
}

