/*
 * Decompiled with CFR 0.152.
 */
package utils.files;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.OverlappingFileLockException;
import java.util.Timer;
import utils.files.PermissionsUtil;
import utils.ostools.OS;

public class FileLockUtil {
    private static Timer timer = new Timer();

    public static void releaseLock(LockResult lock) {
        if (lock == null) {
            return;
        }
        if (lock.lock != null) {
            try {
                lock.lock.release();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (lock.openRAF != null) {
            try {
                lock.openRAF.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static LockResult lockFileOrBlock(File fileToLock) {
        LockResult lock = new LockResult();
        try {
            lock.lockFile = fileToLock;
            lock.openRAF = new RandomAccessFile(fileToLock, "rw");
            lock.lock = null;
            lock.openRAF.setLength(0L);
            FileLockUtil.setReadable(fileToLock);
            System.out.println("[FileLockUtil] Locking file [" + fileToLock.getAbsolutePath() + "]");
            lock.lock = lock.openRAF.getChannel().lock();
            System.out.println("[FileLockUtil] Got file lock.");
            return lock;
        }
        catch (Throwable t) {
            if (lock.openRAF != null) {
                try {
                    lock.openRAF.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            System.out.println("[FileLockUtil] Unable to lock file [" + fileToLock.getAbsolutePath() + "]");
            t.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LockResult lockFileOrTimeout(File fileToLock, long timeout) {
        GetLockThread lockThread;
        GetLockThread getLockThread = lockThread = new GetLockThread(fileToLock);
        synchronized (getLockThread) {
            lockThread.start();
            System.out.println("[FileLockUtil] Started locking thread. Waiting...");
            try {
                lockThread.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            lockThread.die();
            return lockThread.lockResult;
        }
    }

    public static LockResult sharedLockFile(File fileToLock, boolean clearLockFile) {
        LockResult lock = new LockResult();
        try {
            lock.lockFile = fileToLock;
            lock.openRAF = new RandomAccessFile(fileToLock, "rw");
            lock.lock = null;
            if (!fileToLock.exists() || clearLockFile) {
                lock.openRAF.setLength(0L);
            }
            FileLockUtil.setReadable(fileToLock);
            System.out.println("[FileLockUtil] Locking file [" + fileToLock.getAbsolutePath() + "]");
            lock.lock = lock.openRAF.getChannel().lock(0L, Long.MAX_VALUE, true);
            System.out.println("[FileLockUtil] Got file lock.");
            return lock;
        }
        catch (Throwable t) {
            if (lock.openRAF != null) {
                try {
                    lock.openRAF.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            System.out.println("[FileLockUtil] Unable to lock file [" + fileToLock.getAbsolutePath() + "]");
            t.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileCurrentlyLocked(File fileToLock) {
        try {
            if (!fileToLock.exists()) {
                System.out.println("[FileLockUtil] Lock file " + fileToLock + " does not exist. Assuming not locked.");
                return false;
            }
            boolean isRunning = false;
            System.out.println("[FileLockUtil] Trying to lock file [" + fileToLock.getAbsolutePath() + "]");
            try (RandomAccessFile raf = new RandomAccessFile(fileToLock, "rw");){
                FileLock lock = null;
                try {
                    lock = raf.getChannel().tryLock();
                }
                catch (OverlappingFileLockException overlappingFileLockException) {
                    // empty catch block
                }
                if (lock == null) {
                    System.out.println("[FileLockUtil] Unable to get lock. Something else has it locked.");
                    isRunning = true;
                } else {
                    System.out.println("[FileLockUtil] Got lock. Now releasing...");
                    lock.release();
                }
            }
            System.out.println("[FileLockUtil] Is file locked result is " + isRunning);
            return isRunning;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static LockResult tryLockFile(File fileToLock) {
        LockResult lock = new LockResult();
        try {
            lock.lockFile = fileToLock;
            lock.openRAF = new RandomAccessFile(fileToLock, "rw");
            lock.lock = null;
            lock.openRAF.setLength(0L);
            FileLockUtil.setReadable(fileToLock);
            System.out.println("[FileLockUtil] Trying to lock file [" + fileToLock.getAbsolutePath() + "]");
            lock.lock = lock.openRAF.getChannel().tryLock();
            if (lock.lock == null) {
                throw new IOException("Trying to get lock failed");
            }
            System.out.println("[FileLockUtil] Got file lock.");
            return lock;
        }
        catch (Throwable t) {
            if (lock.openRAF != null) {
                try {
                    lock.openRAF.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            System.out.println("[FileLockUtil] Unable to try to lock file [" + fileToLock.getAbsolutePath() + "] as: " + t.getMessage());
            return null;
        }
    }

    private static void setReadable(File fileToLock) {
        if (OS.isLinux()) {
            try {
                PermissionsUtil.setRecursiveFullPermissions(fileToLock.getAbsolutePath());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static class GetLockThread
    extends Thread {
        private File fileToLock;
        private LockResult lockResult;
        private boolean die = false;

        public GetLockThread(File fileToLock) {
            this.fileToLock = fileToLock;
        }

        public void die() {
            this.die = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LockResult lock = new LockResult();
            try {
                lock.lockFile = this.fileToLock;
                lock.openRAF = new RandomAccessFile(this.fileToLock, "rw");
                lock.lock = null;
                lock.openRAF.setLength(0L);
                FileLockUtil.setReadable(this.fileToLock);
                System.out.println("[FileLockUtil] Locking file [" + this.fileToLock.getAbsolutePath() + "]");
                lock.lock = lock.openRAF.getChannel().lock();
                if (this.die) {
                    if (lock.lock != null) {
                        System.out.println("[FileLockUtil] Got the lock but was instructed to die, so releasing.");
                        FileLockUtil.releaseLock(lock);
                        System.out.println("[FileLockUtil] Released.");
                    } else {
                        System.out.println("[FileLockUtil] Asked to die");
                    }
                    this.lockResult = null;
                } else {
                    this.lockResult = lock;
                    System.out.println("[FileLockUtil] Got file lock.");
                }
                GetLockThread getLockThread = this;
                synchronized (getLockThread) {
                    this.notifyAll();
                }
            }
            catch (Throwable t) {
                if (t instanceof AsynchronousCloseException || t instanceof FileLockInterruptionException) {
                    System.out.println("[FileLockUtil] Timeout detected, returning no lock.");
                } else {
                    System.out.println("[FileLockUtil] Unable to lock file [" + this.fileToLock.getAbsolutePath() + "]");
                    t.printStackTrace();
                }
                GetLockThread getLockThread = this;
                synchronized (getLockThread) {
                    this.notifyAll();
                }
            }
            finally {
                System.out.println("[FileLockUtil] Locking thread is returning.");
            }
        }
    }

    public static class LockResult {
        public File lockFile;
        public RandomAccessFile openRAF;
        public FileLock lock;
    }
}

