/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.updater;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.updater.GenericUpdater;
import jwrapper.updater.LaunchFile;
import utils.files.AtomicSafeDeleter;
import utils.files.FileUtil;
import utils.progtools.MapOfLists;
import utils.progtools.arrays.ArrayUtils;

public class MasterFolderCleaner {
    public static void markUsed(File appDir) {
        long lastUsed = System.currentTimeMillis();
        System.out.println("[MasterFolderCleaner] Marking " + appDir.getName() + " as recently used in a launch (" + lastUsed + ")");
        File used = new File(appDir, "jwLastRun");
        used.setLastModified(lastUsed);
        try {
            FileUtil.writeFileAsString(used.getPath(), "" + lastUsed);
            JWGenericOS.setWritableForAllUsers(used, false);
        }
        catch (IOException x) {
            System.out.println("[MasterFolderCleaner] Unable to mark " + appDir.getName() + " as recently used in a launch (" + x + ")");
        }
    }

    public static long getLastUsed(File appDir) {
        File used = new File(appDir, "jwLastRun");
        if (!used.exists()) {
            return -1L;
        }
        try {
            return Long.parseLong(FileUtil.readFileAsString(used.getPath()));
        }
        catch (Exception x) {
            System.out.println("[MasterFolderCleaner] Unable to check " + appDir.getName() + " last launch time");
            return -1L;
        }
    }

    public static void clean(File master, int max_apps, int max_gus) {
        List app;
        String name;
        File[] files = master.listFiles();
        System.out.println("[MasterFolderCleaner] Cleaning master folder " + master);
        System.out.println("[MasterFolderCleaner] max Apps: " + max_apps);
        System.out.println("[MasterFolderCleaner] max GUs: " + max_gus);
        HashMap<String, String> usedJREs = new HashMap<String, String>();
        MapOfLists<String, File> apps = new MapOfLists<String, File>(true);
        if (files != null) {
            for (File file : files) {
                name = file.getName();
                if (!name.startsWith(GenericUpdater.TEMP_FOLDER_PREFIX)) continue;
                System.out.println("[MasterFolderCleaner] --- Temp Dir: " + name);
                String suffix = name.substring(GenericUpdater.TEMP_FOLDER_PREFIX.length());
                suffix = suffix.substring(0, suffix.indexOf(45));
                long tempCreated = Long.parseLong(suffix);
                long ONE_HOUR = 3600000L;
                long hours = (System.currentTimeMillis() - tempCreated) / ONE_HOUR;
                System.out.println("[MasterFolderCleaner] Temp folder " + name + " is " + hours + " hours old");
                if (hours < 18L) continue;
                System.out.println("[MasterFolderCleaner] Will try to delete temp folder if not in use");
                if (AtomicSafeDeleter.deleteIfNotInUse(file)) {
                    System.out.println("[MasterFolderCleaner] Deleted " + name + " OK");
                    continue;
                }
                System.out.println("[MasterFolderCleaner] Temp folder appears to be still in use");
            }
        }
        if ((files = master.listFiles()) != null) {
            for (File file : files) {
                name = file.getName();
                if (!LaunchFile.isAppFolder(file)) continue;
                System.out.println("[MasterFolderCleaner] --- App Dir: " + name);
                String appName = LaunchFile.pickAppNameFromAppFolder(file);
                String appVer = LaunchFile.pickVersionFromAppFolder(file);
                long lastUsed = MasterFolderCleaner.getLastUsed(file);
                if (lastUsed > 0L) {
                    System.out.println("[MasterFolderCleaner] " + file.getName() + " last used at " + lastUsed);
                    apps.add(appName, file);
                    continue;
                }
                System.out.println("[MasterFolderCleaner] " + file.getName() + " has never been used, probably new (skipping it entirely)");
                usedJREs.put(appVer, appVer);
            }
        }
        System.out.println("[MasterFolderCleanup] Checking all versions of all Apps (including GU, excluding JREs)");
        ArrayList<String> all = ArrayUtils.toList(apps.keySet().toArray(new String[0]));
        for (String appName : all) {
            int MAX;
            app = apps.get(appName);
            if (appName.equals("JWrapper")) {
                MAX = max_gus;
                System.out.println("[MasterFolderCleanup] Will retain at most " + MAX + "/" + app.size() + " " + appName + " (GU versions)");
            } else {
                if (appName.endsWith("JRE")) continue;
                MAX = max_apps;
                System.out.println("[MasterFolderCleanup] Will retain at most " + MAX + "/" + app.size() + " " + appName + " (App versions)");
            }
            Collections.sort(app, new LastUsedComparator());
            for (int k = 0; k < app.size(); ++k) {
                File f = (File)app.get(k);
                if (k > MAX) {
                    System.out.println("[MasterFolderCleanup] Deleting " + f.getName() + " (last used " + MasterFolderCleaner.getLastUsed(f) + ")");
                    if (AtomicSafeDeleter.deleteIfNotInUse(f)) {
                        System.out.println("[MasterFolderCleanup] Deleted " + f);
                        continue;
                    }
                    System.out.println("[MasterFolderCleanup] Unable to delete " + f + " (in use?)");
                    continue;
                }
                String jreVer = LaunchFile.getJreVersionForApp(f);
                System.out.println("[MasterFolderCleanup] Retaining " + f.getName() + " (last used " + MasterFolderCleaner.getLastUsed(f) + ") (jre used " + jreVer + ")");
                if (usedJREs.containsKey(jreVer)) continue;
                System.out.println("[MasterFolderCleaner] JRE " + f.getName() + " is used by a retained app version (" + f.getName() + "), excluding it from deletion");
                usedJREs.put(jreVer, jreVer);
            }
            System.out.println("[MasterFolderCleanup] " + appName + " cleanup done");
        }
        System.out.println("[MasterFolderCleanup] Checking all versions of all JREs");
        for (String appName : all) {
            if (!appName.endsWith("JRE")) continue;
            app = apps.get(appName);
            System.out.println("[MasterFolderCleanup] Will retain all JREs (" + app.size() + ") used by retained Apps");
            for (File f : app) {
                String appVer = LaunchFile.pickVersionFromAppFolder(f);
                if (usedJREs.containsKey(appVer)) {
                    System.out.println("[MasterFolderCleanup] Retaining JRE " + f.getName());
                    continue;
                }
                System.out.println("[MasterFolderCleanup] Deleting JRE " + f.getName());
                if (AtomicSafeDeleter.deleteIfNotInUse(f)) {
                    System.out.println("[MasterFolderCleanup] Deleted " + f);
                    continue;
                }
                System.out.println("[MasterFolderCleanup] Unable to delete " + f + " (in use?)");
            }
            System.out.println("[MasterFolderCleanup] JRE cleanup done");
        }
    }

    public static void main(String[] args) {
        MasterFolderCleaner.clean(new File("/users/aem/Desktop/Launch NPE Problem/JWrapper-Remote Support 2"), 2, 1);
    }

    static class LastUsedComparator
    implements Comparator {
        LastUsedComparator() {
        }

        public int compare(Object o1, Object o2) {
            File f1 = (File)o1;
            File f2 = (File)o2;
            try {
                long diff = MasterFolderCleaner.getLastUsed(f2) - MasterFolderCleaner.getLastUsed(f1);
                if (diff > 0L) {
                    return 1;
                }
                if (diff < 0L) {
                    return -1;
                }
                return 0;
            }
            catch (Exception x) {
                x.printStackTrace();
                return f2.getName().compareTo(f1.getName());
            }
        }
    }
}

