/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.updater;

import java.io.File;
import java.io.FileOutputStream;
import jwrapper.jwutils.JWJreVerifierApp;
import jwrapper.jwutils.JWSystem;
import jwrapper.updater.JWLaunchProperties;
import utils.progtools.CheapTimingPrintStream;

public class GenericUpdaterJreVerifier {
    public static final int UJRE_OK = 72;
    public static final int UJRE_NOTSUPPORTED = 73;

    public static void main(String[] args) throws Exception {
        args = JWLaunchProperties.argsToNormalArgs(args);
        try {
            CheapTimingPrintStream out = new CheapTimingPrintStream(new FileOutputStream(new File(JWSystem.getAppFolder(), "GenericUpdaterJreVerifier.log")));
            System.setErr(out);
            System.setOut(out);
        }
        catch (Throwable out) {
            // empty catch block
        }
        String vendor = System.getProperty("java.vendor").toUpperCase();
        String version = System.getProperty("java.version");
        System.out.println("Vendor: " + vendor);
        System.out.println("Version: " + version);
        if (!vendor.contains("SUN") && !vendor.contains("ORACLE")) {
            System.out.println("Only Sun or Oracle JREs supported as yet");
            JWJreVerifierApp.exitJvm_JreIsNotSupported();
        }
        if (version.startsWith("1.0") || version.startsWith("1.1") || version.startsWith("1.2") || version.startsWith("1.3")) {
            System.out.println("Only Java 1.4 or later JREs supported");
            JWJreVerifierApp.exitJvm_JreIsNotSupported();
        }
        JWJreVerifierApp.exitJvm_JreIsSupported();
    }
}

