/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.updater;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.ProxySelector;
import java.net.URL;
import java.security.Security;
import java.util.Properties;
import javax.net.ssl.SSLHandshakeException;
import javax.swing.SwingUtilities;
import jwrapper.HeadlessOsxUtil;
import jwrapper.HeadlessSwipeLoadUtil;
import jwrapper.HeadlessVirtualAppChooserUtil;
import jwrapper.IcoPng;
import jwrapper.JWParameteriser;
import jwrapper.LPUninstallerListener;
import jwrapper.SelfDelete;
import jwrapper.failover.FailoverListener;
import jwrapper.failover.FailoverMonitor;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.hidden.JWSanityTest;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWInstallApp;
import jwrapper.jwutils.JWMacOS;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.JWWindowsOS;
import jwrapper.jwutils.network.JWNet;
import jwrapper.jwutils.test.JWTesting;
import jwrapper.logging.ProcessOutputUtil;
import jwrapper.logging.StdLogging;
import jwrapper.proxy.JWAsyncProxyDetector;
import jwrapper.proxy.JWDetectedProxy;
import jwrapper.proxy.ProxySelectorWrapper;
import jwrapper.ui.JWLanguage;
import jwrapper.updater.AppDoesNotExistException;
import jwrapper.updater.HumanMessageException;
import jwrapper.updater.JWApp;
import jwrapper.updater.JWLaunchProperties;
import jwrapper.updater.LaunchFile;
import jwrapper.updater.MasterFolderCleaner;
import jwrapper.updater.OSXBundleUtil;
import jwrapper.updater.Unarchiver;
import jwrapper.updater.VersionUtil;
import utils.encryption.rsa.RSADecryptor;
import utils.files.AtomicFileOutputStream;
import utils.files.AtomicRenamer;
import utils.files.AutoChmodFile;
import utils.files.FileUtil;
import utils.ostools.OS;
import utils.progtools.AutoFetchURL;
import utils.progtools.ProcessPrinter;
import utils.progtools.URIUtil;
import utils.progtools.time.TimeSet;
import utils.stream.CFriendlyStreamUtils;
import utils.stream.SSLHelper;
import utils.stream.StreamUtils;
import utils.string.Base64;
import utils.string.Normaliser;
import utils.swing.EventThreadExceptionPrinter;
import utils.switches.LocalSwitches;
import utils.switches.Switches;

public class GenericUpdater {
    public static long VERSION_TIMEOUT = 7000L;
    private static String PADVER;
    public static String LOG_SOURCE;
    public static String TEMP_FOLDER_PREFIX;
    public static String SUCCESS_FOLDER_PREFIX;
    public static String SUCCESS_FOLDER_SUFFIX;
    public static String DELTA_NAME;
    public static String JRE_WIN32_APP;
    public static String JRE_WIN64_APP;
    public static String JRE_LIN32_APP;
    public static String JRE_LINARM32_APP;
    public static String JRE_LIN64_APP;
    public static String JRE_MAC64_APP;
    public static String ARC_cross_platform;
    public static String ARC_windows;
    public static String ARC_mac32;
    public static String ARC_mac64;
    public static String ARC_lin32;
    public static String ARC_lin64;
    public static String ARC_arm;
    public static String BUILD_VER_FILE;
    public static String FIRST_RUN_FILE;
    public static String AUTHOR_PUBKEY_FILE;
    public static String AUTO_UNINSTALLER;
    public static String VAPP_UNINSTALLER;
    public static String VAPP_SANITYCHECK;
    public static int MODE_NORMAL;
    public static int MODE_FIRST_RUN_POST_INSTALL;
    public static int MODE_FIRST_RUN_POST_UPDATE;
    public static boolean AM_SANITY_CHECK;
    public static boolean AM_UNINSTALLER;
    private static HeadlessSwipeLoadUtil swu;
    private static boolean alreadyDownloading;
    static boolean matchVersions;
    static LatestUpdate latestUpdate;
    static String latestFailedUpdateUiReason;
    public static AtomicRenamer atomicUpdate;
    private static String unpack200exe;
    private static LatestUpdate preUpdatedJRE;
    static Properties appArgs;
    static String virtualApp;
    static boolean SHOW_NO_UI;
    static TimeSet times;

    public static String GetVersion() {
        if (PADVER == null) {
            try {
                PADVER = VersionUtil.padVersion(Integer.parseInt(GenericUpdater.grabStringFromURLNow(GenericUpdater.class.getResource("/gu_version")).trim()));
                System.out.println("[GenericUpdater] version " + PADVER);
            }
            catch (Exception x) {
                x.printStackTrace();
                PADVER = VersionUtil.padVersion(1);
                System.out.println("[GenericUpdater] WARNING NO VERSION FOUND! USING VERSION " + PADVER);
            }
        }
        return PADVER;
    }

    public static String grabStringFromURLNow(URL url) throws IOException {
        InputStream vin = AutoFetchURL.getInputStreamAndHandleTLSDowngrade(url);
        try {
            String string = StreamUtils.readAllAsStringUTF8(vin);
            return string;
        }
        finally {
            vin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String grabAutoFetchedURL(URL url, long timeout) throws IOException {
        AutoFetchURL fetch = AutoFetchURL.getPreFetchedURL(url);
        if (fetch != null) {
            return fetch.getAsUTF8(timeout);
        }
        InputStream vin = AutoFetchURL.getInputStreamAndHandleTLSDowngrade(url);
        try {
            String string = StreamUtils.readAllAsStringUTF8(vin);
            return string;
        }
        finally {
            vin.close();
        }
    }

    public static File getSimpleServiceExe(File master) {
        File latestGU = LaunchFile.getLatestVersionOf("JWrapper", master);
        return new File(latestGU, "SimpleService.exe");
    }

    private static String getSubURL(String base, String file) {
        if (base.endsWith("/")) {
            return base + file;
        }
        return base + "/" + file;
    }

    public static String getLauncherNameFor(String app, boolean linux, boolean arch64, boolean macos) {
        return GenericUpdater.getLauncherNameFor(app, linux, arch64, macos, false);
    }

    public static String getLauncherNameFor(String app, boolean linux, boolean arch64, boolean macos, boolean arm) {
        if (macos) {
            if (arch64) {
                return app + "MacLauncher64.app";
            }
            return app + "MacLauncher32.app";
        }
        if (linux) {
            if (arm) {
                if (arch64) {
                    return app + "LinArmLauncher64";
                }
                return app + "LinArmLauncher32";
            }
            if (arch64) {
                return app + "LinLauncher64";
            }
            return app + "LinLauncher32";
        }
        return app + "WinLauncher.exe";
    }

    public static String getRefusedUpdatesFolderName() {
        return "RefusedUpdates";
    }

    public static String getAuxiliaryFeatureMarker(String auxname) {
        return "JWAuxiliaryArchive-" + auxname;
    }

    public static String getNameForSpecificOsArch(String appname, String osarch) {
        return appname + "_os" + osarch;
    }

    public static String getNameForSpecificOsArch(String osarch) {
        return "os" + osarch;
    }

    public static String getNameForMergedOsArch(String appname, String osarch) {
        return appname + "_offline" + osarch;
    }

    public static String getNameForAuxiliary(String appname, String aux) {
        return appname + "_" + aux;
    }

    public static String getVersionFileNameFor(String app) {
        return "JWrapper-" + app + "-version.txt";
    }

    public static String getSplashFileNameFor(String app) {
        return "JWrapper-" + app + "-splash.png";
    }

    public static String getIconFileNameFor(String app) {
        return "JWrapper-" + app + "-icon.png";
    }

    public static String getIcnsFileNameFor(String app) {
        return "JWrapper-" + app + "-ICNS.icns";
    }

    public static String getUninstallerIcoFileNameFor(String app) {
        return "JWrapper-" + app + "-UninstallerICO.ico";
    }

    public static String getUninstallerIcopngFileNameFor(String app) {
        return "JWrapper-" + app + "-UninstallerICO.icopng";
    }

    public static String getUpdateUrlOverrideFileName() {
        return "UpdateUrlOverride";
    }

    public static String getFailoverUrlOverrideFileName() {
        if (Switches.SH_failoverOverrideFilePerUpdateUrl) {
            String base = JWLaunchProperties.getProperty("update_url");
            return "FailoverUrlOverride_" + Normaliser.normaliseShort(base);
        }
        return "FailoverUrlOverride";
    }

    public static String getJreNameOverrideFileName() {
        return "JreNameOverride";
    }

    public static String getArchiveNameFor(String app, String version) {
        return "JWrapper-" + app + "-" + version + "-archive.p2.l2";
    }

    public static String getArchiveNameForAuxiliary(String app, String aux, String version) {
        return GenericUpdater.getArchiveNameFor(GenericUpdater.getNameForAuxiliary(app, aux), version);
    }

    public static String getAppFolderNameFor(String app, String version) {
        return SUCCESS_FOLDER_PREFIX + app + "-" + version + SUCCESS_FOLDER_SUFFIX;
    }

    private static void searchAndUpdateOsArchive(File master, File gu) throws Exception {
        System.out.println("[GenericUpdater] Searching for app folder to place OS archive");
        File source = new File(gu, BUILD_VER_FILE);
        String appBuildVer = FileUtil.readFileAsString(source).trim();
        System.out.println("[GenericUpdater] App build version is " + appBuildVer);
        File[] list = master.listFiles();
        if (list == null) {
            list = new File[]{};
        }
        for (File testdir : list) {
            System.out.println("[GenericUpdater] Checking " + testdir.getName());
            if (testdir.getName().equals(gu.getName())) continue;
            File testfile = new File(testdir, BUILD_VER_FILE);
            try {
                if (!testfile.exists()) continue;
                String testBuildVer = FileUtil.readFileAsString(testfile).trim();
                System.out.println("[GenericUpdater] Build ver for " + testdir.getName() + " is " + testBuildVer);
                if (!testBuildVer.equals(appBuildVer)) continue;
                System.out.println("[GenericUpdater] Fetching OS archive for " + testdir.getName());
                GenericUpdater.fetchOsArchive(testdir);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void fetchOsArchive(File appdir) throws Exception {
        boolean is64 = false;
        if (OS.isLinux() && OS.isLinux64bit()) {
            is64 = true;
        } else if (OS.isMacOS() && JWMacOS.canRunLauncher64()) {
            is64 = true;
            File master = appdir.getParentFile();
            if (LaunchFile.getLatestVersionOf("Mac64JRE", master) == null) {
                is64 = false;
                System.out.println("[GenericUpdater] Capable of mac-64 but no Mac64JRE found in master folder " + master + " so will use mac-32");
            } else {
                System.out.println("[GenericUpdater] Capable of mac-64, will use mac-64");
            }
        }
        if (OS.isWindows()) {
            System.out.println("[GenericUpdater] Fetching Windows OS-specific archive");
            GenericUpdater.fetchOsArchive(appdir, ARC_windows);
        } else if (OS.isMacOS()) {
            if (is64) {
                System.out.println("[GenericUpdater] Fetching Mac64 OS-specific archive");
                GenericUpdater.fetchOsArchive(appdir, ARC_mac64);
            } else {
                System.out.println("[GenericUpdater] Fetching Mac32 OS-specific archive");
                GenericUpdater.fetchOsArchive(appdir, ARC_mac32);
            }
        } else if (OS.isARM()) {
            System.out.println("[GenericUpdater] Fetching ARM OS-specific archive");
            GenericUpdater.fetchOsArchive(appdir, ARC_arm);
        } else if (OS.isLinux()) {
            if (is64) {
                System.out.println("[GenericUpdater] Fetching Lin64 OS-specific archive");
                GenericUpdater.fetchOsArchive(appdir, ARC_lin64);
            } else {
                System.out.println("[GenericUpdater] Fetching Lin32 OS-specific archive");
                GenericUpdater.fetchOsArchive(appdir, ARC_lin32);
            }
        }
    }

    private static void fetchOsArchive(File appdir, String osarch) throws Exception {
        String archiveName = GenericUpdater.getNameForSpecificOsArch(osarch);
        if (!GenericUpdater.haveAuxiliaryArchive(appdir, archiveName)) {
            System.out.println("[GenericUpdater] Fetching OS archive for " + osarch);
            times.start("GU - fetching OS archive");
            try {
                GenericUpdater.fetchAuxiliaryArchive(appdir, archiveName);
            }
            finally {
                times.stop("GU - fetching OS archive");
            }
        } else {
            System.out.println("[GenericUpdater] OS archive already present for " + osarch);
        }
    }

    public static boolean haveAuxiliaryArchive(String archiveName) {
        File appdir = JWSystem.getAppFolder();
        return GenericUpdater.haveAuxiliaryArchive(appdir, archiveName);
    }

    public static void fetchAuxiliaryArchive(String archiveName, boolean force) throws Exception {
        File appdir = JWSystem.getAppFolder();
        if (!GenericUpdater.haveAuxiliaryArchive(appdir, archiveName) || force) {
            System.out.println("[GenericUpdater] Fetching AUX archive " + archiveName + (force ? " (forced)" : " (not present)"));
            times.start("GU - fetching aux archive");
            try {
                GenericUpdater.fetchAuxiliaryArchive(appdir, archiveName);
            }
            finally {
                times.stop("GU - fetching aux archive");
            }
        } else {
            System.out.println("[GenericUpdater] AUX archive already present for " + archiveName);
        }
    }

    private static void fetchAuxiliaryArchive(File appdir, String name) throws Exception {
        String auxname = GenericUpdater.getNameForAuxiliary(JWLaunchProperties.getProperty("app_name"), name);
        System.out.println("[GenericUpdater] Asked to fetch auxiliary archive: " + auxname);
        String base = JWLaunchProperties.getProperty("update_url");
        File master = appdir.getParentFile();
        UpdaterInfo updaterInfo = new UpdaterInfo();
        updaterInfo.master = master;
        updaterInfo.base = base;
        updaterInfo.jreAppName = JWLaunchProperties.getProperty("jre_name");
        String installType = JWLaunchProperties.getProperty("install_type");
        updaterInfo.allUsersInstall = installType.equalsIgnoreCase("perm_all");
        GenericUpdater.fetchSupplementalArchive(updaterInfo, master, appdir, base, auxname);
    }

    private static boolean haveAuxiliaryArchive(File appdir, String name) {
        String auxname = GenericUpdater.getNameForAuxiliary(JWLaunchProperties.getProperty("app_name"), name);
        File marker = new File(appdir, GenericUpdater.getAuxiliaryFeatureMarker(auxname));
        if (marker.exists()) {
            System.out.println("[GenericUpdater] Supplemental archive " + name + " has already been downloaded");
            return true;
        }
        return false;
    }

    private static void fetchSupplementalArchive(UpdaterInfo updaterInfo, File master, File appdir, String base, String name) throws Exception {
        int intver;
        System.out.println("[GenericUpdater] Fetching supplemental archive: " + name + " from " + base + " into " + appdir);
        File marker = new File(appdir, GenericUpdater.getAuxiliaryFeatureMarker(name));
        if (marker.exists()) {
            System.out.println("[GenericUpdater] Supplemental archive " + name + " has already been downloaded");
            return;
        }
        URL versionURL = new URL(GenericUpdater.getSubURL(base, GenericUpdater.getVersionFileNameFor(name)));
        versionURL = URIUtil.tryGetSafeURLFrom(versionURL);
        System.out.println("[GenericUpdater] Querying " + versionURL + " for " + name + " version");
        try {
            String text = GenericUpdater.grabAutoFetchedURL(versionURL, VERSION_TIMEOUT).trim();
            System.out.println("[GenericUpdater] Got back \"" + text + "\"");
            intver = Integer.parseInt(text);
        }
        catch (SSLHandshakeException x) {
            x.printStackTrace();
            System.out.println("[GenericUpdater] Unable to query for version " + versionURL);
            latestFailedUpdateUiReason = JWLanguage.getString("SERVER_SSL_INVALID");
            throw x;
        }
        catch (ConnectException x) {
            x.printStackTrace();
            System.out.println("[GenericUpdater] Unable to query for version " + versionURL);
            latestFailedUpdateUiReason = JWLanguage.getString("SERVER_FAIL_CONNECT");
            throw x;
        }
        catch (Exception x) {
            x.printStackTrace();
            System.out.println("[GenericUpdater] Unable to query for version " + versionURL);
            latestFailedUpdateUiReason = JWLanguage.getString("SERVER_FAIL_UNKNOWN");
            throw x;
        }
        new Thread(){

            @Override
            public void run() {
                if (swu != null) {
                    swu.swipeSmallTo("SmallDownload");
                    swu.waitForAllSwipes();
                    swu.showFiniteProgress();
                }
            }
        }.start();
        System.out.println("[GenericUpdater] Downloading into " + appdir.getName());
        String padver = VersionUtil.padVersion(intver);
        String arcname = GenericUpdater.getArchiveNameFor(name, padver);
        URL archive = new URL(GenericUpdater.getSubURL(base, arcname));
        System.out.println("[GenericUpdater] Downloading archive from '" + archive + "'");
        String signaturePubkey = GenericUpdater.loadSignaturePublicKey();
        times.start("updateName() - Stream Archive");
        Unarchiver unarchiver = new Unarchiver(times, swu);
        unarchiver.downloadAndExtract(archive, appdir, signaturePubkey, updaterInfo, null);
        times.stop("updateName() - Stream Archive");
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (swu != null) {
                        swu.setProgress(100.0);
                        swu.showInfiniteProgress();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.out.println("[GenericUpdater] Supplemental archive unpacked OK, creating marker so no need for future download");
        marker.createNewFile();
    }

    private static String loadSignaturePublicKey() throws IOException {
        File guWorkingDir = new File(JWLaunchProperties.getProperty("app_dir"));
        File authorPubkey = new File(guWorkingDir, AUTHOR_PUBKEY_FILE);
        String signaturePubkey = null;
        if (authorPubkey.exists()) {
            System.out.println("[GenericUpdater] (Signature Checking) Author pubkey found");
            signaturePubkey = FileUtil.readFileAsString(authorPubkey.getPath());
            System.out.println("[GenericUpdater] (Signature Checking) Author pubkey is " + signaturePubkey);
        } else {
            System.out.println("[GenericUpdater] (Signature Checking) No author pubkey, expecting unsigned archive");
        }
        return signaturePubkey;
    }

    private static boolean updateNamed(UpdaterInfo updaterInfo, File master, String base, String name, boolean matchVersions, boolean requiresChmod, CACertsSource cacertsSource) throws IOException, LatestVersionExists {
        String padver;
        int intver;
        latestUpdate = null;
        latestFailedUpdateUiReason = null;
        LatestUpdate tempUpdate = new LatestUpdate();
        URL versionURL = new URL(GenericUpdater.getSubURL(base, GenericUpdater.getVersionFileNameFor(name)));
        versionURL = URIUtil.tryGetSafeURLFrom(versionURL);
        System.out.println("[GenericUpdater] Querying " + versionURL + " for " + name + " version");
        try {
            String text = GenericUpdater.grabAutoFetchedURL(versionURL, VERSION_TIMEOUT).trim();
            System.out.println("[GenericUpdater] Got back \"" + text + "\"");
            intver = Integer.parseInt(text);
        }
        catch (SSLHandshakeException x) {
            x.printStackTrace();
            System.out.println("[GenericUpdater] Unable to query for version " + versionURL + ", will skip and just launch");
            latestFailedUpdateUiReason = JWLanguage.getString("SERVER_SSL_INVALID");
            return false;
        }
        catch (ConnectException x) {
            x.printStackTrace();
            System.out.println("[GenericUpdater] Unable to query for version " + versionURL + ", will skip and just launch");
            latestFailedUpdateUiReason = JWLanguage.getString("SERVER_FAIL_CONNECT");
            return false;
        }
        catch (Exception x) {
            x.printStackTrace();
            System.out.println("[GenericUpdater] Unable to query for version " + versionURL + ", will skip and just launch");
            latestFailedUpdateUiReason = JWLanguage.getString("SERVER_FAIL_UNKNOWN");
            return false;
        }
        tempUpdate.paddedVersion = padver = VersionUtil.padVersion(intver);
        System.out.println("[GenericUpdater] Picked out version " + padver);
        System.out.println("[GenericUpdater] Master folder " + master.getAbsoluteFile().getCanonicalPath());
        String arcprefix = "JWrapper-" + name + "-" + padver + "-";
        String arcdir = SUCCESS_FOLDER_PREFIX + name + "-" + padver + SUCCESS_FOLDER_SUFFIX;
        File refused = new File(master, GenericUpdater.getRefusedUpdatesFolderName());
        if (new File(refused, arcdir).exists()) {
            System.out.println("[GenericUpdater] This version has been downloaded and REFUSED already, we will wait for next update");
            return false;
        }
        if (matchVersions) {
            System.out.println("[GenericUpdater] Checking if server-specific version is already available");
            if (LaunchFile.getSpecificVersionOf(name, padver, master) != null) {
                System.out.println("[GenericUpdater] Specific version exists already (" + arcprefix + "...)");
                throw new LatestVersionExists(padver);
            }
            System.out.println("[GenericUpdater] Specific version does not exist, will need to update");
        } else {
            System.out.println("[GenericUpdater] Checking if server or later version is already available");
            File latestVer = LaunchFile.getLatestVersionOf(name, master);
            if (latestVer != null) {
                String latestVersionAvailable = LaunchFile.pickVersionFromAppFolder(latestVer);
                if (LaunchFile.versionIsSameOrLater(padver, latestVersionAvailable)) {
                    System.out.println("[GenericUpdater] Version exists already (" + arcprefix + "...)");
                    throw new LatestVersionExists(latestVersionAvailable);
                }
                System.out.println("[GenericUpdater] Versions exist but are older than server version, will need to update");
            } else {
                System.out.println("[GenericUpdater] No versions present, will need to update");
            }
        }
        if (!alreadyDownloading) {
            new Thread(){

                @Override
                public void run() {
                    if (swu != null) {
                        HeadlessSwipeLoadUtil headlessSwipeLoadUtil = swu;
                        swu;
                        headlessSwipeLoadUtil.swipeSmallTo("SmallDownload");
                        swu.waitForAllSwipes();
                        swu.showFiniteProgress();
                    }
                }
            }.start();
        } else if (swu != null) {
            swu.showFiniteProgress();
        }
        File latest = LaunchFile.getLatestVersionOf(name, master);
        if (latest != null) {
            System.out.println("[GenericUpdater] Existing version of app (" + latest.getName() + "), will try to run its update class");
            File stopAsking = new File(latest, "StopAskingAboutVersion-" + padver);
            if (stopAsking.exists()) {
                System.out.println("[GenericUpdater] Have previously been told to stop asking about this version, will just run existing version without running update class");
                return false;
            }
            try {
                int decision;
                if (swu != null) {
                    swu.waitForAllSwipes();
                }
                try {
                    decision = LaunchFile.runHookAppFrom(latest, LaunchFile.JW_VAPP_UPDATE_APP, appArgs, null, base, new String[]{padver}, name + "Update");
                }
                catch (AppDoesNotExistException x) {
                    System.out.println("[GenericUpdater] No virtual app for updates, will update and run");
                    decision = 50;
                }
                if (decision == 52) {
                    System.out.println("[GenericUpdater] Update app told to cancel launch and exit");
                    ProcessOutputUtil.logProcessResult(LOG_SOURCE, 3);
                    ProcessOutputUtil.logProcessError(LOG_SOURCE, "The app bundle update virtual application returned that the launch should be cancelled");
                    System.exit(0);
                } else {
                    if (decision == 51) {
                        System.out.println("[GenericUpdater] Update app told to just run existing version");
                        return false;
                    }
                    if (decision == 53) {
                        System.out.println("[GenericUpdater] Update app told to just run existing version and stop asking for this version");
                        stopAsking.createNewFile();
                        return false;
                    }
                    if (decision == 50) {
                        System.out.println("[GenericUpdater] Update app told to update and run");
                    } else {
                        System.out.println("[GenericUpdater] Update app told to do unrecognised decision " + decision + ", will update and run");
                    }
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                System.out.println("[GenericUpdater] Existing version of app (" + latest.getName() + ") seems to be broken? will update + run");
            }
        }
        File temp = new File(master, TEMP_FOLDER_PREFIX + System.currentTimeMillis() + "-" + master.list().length);
        temp.mkdirs();
        System.out.println("[GenericUpdater] Downloading into " + temp.getName());
        String arcname = GenericUpdater.getArchiveNameFor(name, padver);
        URL archive = new URL(GenericUpdater.getSubURL(base, arcname));
        String signaturePubkey = GenericUpdater.loadSignaturePublicKey();
        times.start("updateName() - Stream Archive");
        Unarchiver unarchiver = new Unarchiver(times, swu);
        unarchiver.downloadAndExtract(archive, temp, signaturePubkey, updaterInfo, cacertsSource);
        times.stop("updateName() - Stream Archive");
        if (swu != null) {
            swu.setProgress(100.0);
            swu.showInfiniteProgress();
        }
        System.out.println("[GenericUpdater] Downloaded archive");
        if (requiresChmod) {
            System.out.println("[GenericUpdater] Setting " + temp.getName() + " accessible for all users");
            JWGenericOS.setReadableForAllUsers(temp, true);
            JWGenericOS.setWritableForAllUsers(temp, false);
        }
        System.out.println("[GenericUpdater] Moving " + temp.getName() + " to " + arcdir);
        if (OS.isMacOS() && name.equals(JRE_MAC64_APP)) {
            File tempBundle = temp;
            File tempJRE = new File(master, TEMP_FOLDER_PREFIX + System.currentTimeMillis() + "-" + master.list().length);
            tempJRE.mkdir();
            File targetBundle = new File(master, arcdir + ".plugin");
            File targetJRE = new File(master, arcdir);
            GenericUpdater.addDelayedFinalCopy(tempBundle, targetBundle);
            GenericUpdater.addDelayedFinalCopy(tempJRE, targetJRE);
            tempUpdate.tempUpdateFolder = tempJRE;
            tempUpdate.finalUpdateFolder = targetJRE;
            GenericUpdater.addDelayedJRELinkRequest(targetJRE, targetBundle);
        } else {
            File finalFolder = new File(master, arcdir);
            GenericUpdater.addDelayedFinalCopy(temp, finalFolder);
            tempUpdate.tempUpdateFolder = temp;
            tempUpdate.finalUpdateFolder = finalFolder;
        }
        latestUpdate = tempUpdate;
        return true;
    }

    private static void completeAnyAtomicRenames(File folder) {
        atomicUpdate = new AtomicRenamer(new File(folder, "JWUpdateARInstruction"));
        try {
            times.start("Renaming");
            atomicUpdate.completeAnyFailedAtomicMultiRenameNow();
        }
        catch (IOException x) {
            System.out.println("[GenericUpdater] Error in atomic rename? " + x);
            x.printStackTrace();
        }
        finally {
            times.stop("Renaming");
        }
    }

    private static void addDelayedFinalCopy(File from, File to) {
        atomicUpdate.addRenameInstruction(from, to);
        System.out.println("[GenericUpdater] Set up for atomic rename: " + to + " (from: " + from + ")");
    }

    private static void addDelayedJRELinkRequest(File targetJRE, File targetBundle) {
        atomicUpdate.addPostRenameRunner(new JRELinker(targetBundle, targetJRE));
    }

    private static void cancelAllOutstandingFinalCopies() throws IOException {
        System.out.println("[GenericUpdater] Cancelling all atomic renames now");
        atomicUpdate.cancelAtomicMultiRename();
    }

    private static void doAllOutstandingFinalCopies() throws IOException {
        System.out.println("[GenericUpdater] Performing all atomic renames now");
        atomicUpdate.performAtomicMultiRenameNow();
    }

    private static void doNoInternetFailAndExit(String errorMessage, String uiMessage, Throwable t) {
        System.out.println("[GenericUpdater] Showing app download failure image and exiting after 6 seconds...");
        if (swu != null) {
            swu.swipeSmallTo("SmallNoInternet");
            swu.hideProgress();
            if (uiMessage != null) {
                swu.setMessage(uiMessage);
            }
            swu.waitForAllSwipes();
        }
        try {
            Thread.sleep(6000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("[GenericUpdater] Exiting");
        ProcessOutputUtil.logProcessResult(LOG_SOURCE, 2);
        if (t != null) {
            ProcessOutputUtil.logProcessTrace(LOG_SOURCE, t);
        }
        ProcessOutputUtil.logProcessError(LOG_SOURCE, errorMessage);
        System.exit(0);
    }

    static void mustUpdateJreForPack200(File app, UpdaterInfo info, CACertsSource cacertsSource) throws IOException {
        try {
            System.out.println("[GenericUpdater] WARNING: need to update JRE since our pack200 does not support the packing on this archive");
            if (info == null) {
                System.out.println("[GenericUpdater] WARNING: no updater info available (update URL, master folder etc) unable to unpack the JRE, failing now");
                throw new IOException("Unable to unpack the JRE (un-p2 failure)");
            }
            if (GenericUpdater.updateJRE(null, info.master, info.base, info.jreAppName, false, info.allUsersInstall, cacertsSource)) {
                System.out.println("[GenericUpdater] JRE updated, will relaunch to process the update using latest JRE");
                preUpdatedJRE = latestUpdate;
            } else {
                System.out.println("[GenericUpdater] ERROR, FAILURE: Need to update JRE to allow un-p2ing of archive but JRE update failed: " + latestFailedUpdateUiReason);
                System.exit(0);
            }
        }
        catch (LatestVersionExists exver) {
            System.out.println("[GenericUpdater] WARNING: unexpected case.  Unable to unpack archive (un-p2 fail) but unable to update JRE as latest version already exists?");
            File jre = LaunchFile.getLatestVersionOf(info.jreAppName, info.master);
            File unpack200 = OS.isWindows() ? new File(jre, "bin\\unpack200.exe") : new File(jre, "bin/unpack200");
            unpack200exe = unpack200.getCanonicalPath();
            System.out.println("[GenericUpdater] Picked up unpack200 exe based on EXISTING JRE, despite this is likely the JRE we are using: " + unpack200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateGenericUpdater(UpdaterInfo updaterInfo, File master, String base, boolean needChmod) throws IOException {
        times.start("Update Generic Updater");
        try {
            boolean bl = GenericUpdater.updateNamed(updaterInfo, master, base, "JWrapper", false, needChmod, null);
            return bl;
        }
        catch (LatestVersionExists x) {
            boolean bl = false;
            return bl;
        }
        finally {
            times.stop("Update Generic Updater");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateJavaApp(UpdaterInfo updaterInfo, File master, String base, String app, boolean needChmod) throws IOException {
        boolean result;
        times.start("Update Java App");
        try {
            result = GenericUpdater.updateNamed(updaterInfo, master, base, app, matchVersions, needChmod, null);
        }
        catch (LatestVersionExists x) {
            result = false;
        }
        finally {
            times.stop("Update Java App");
        }
        times.start("Update OS Archive");
        try {
            File guWorkingDir = new File(JWLaunchProperties.getProperty("app_dir"));
            try {
                GenericUpdater.searchAndUpdateOsArchive(master, guWorkingDir);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        finally {
            times.stop("Update OS Archive");
        }
        return result;
    }

    public static boolean forceUpdateJreNow(CACertsSource source) throws IOException, LatestVersionExists {
        File master = JWSystem.getMyJreHome().getParentFile();
        String base = JWLaunchProperties.getProperty("update_url");
        String app = LaunchFile.pickAppNameFromAppFolder(JWSystem.getMyJreHome());
        boolean serverOrLaterIsOK = false;
        String installType = JWLaunchProperties.getProperty("install_type");
        boolean allUsersInstall = installType.equalsIgnoreCase("perm_all");
        UpdaterInfo info = new UpdaterInfo();
        info.allUsersInstall = allUsersInstall;
        info.master = master;
        info.base = base;
        info.jreAppName = app;
        return GenericUpdater.updateJRE(info, master, base, app, serverOrLaterIsOK, allUsersInstall, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateJRE(UpdaterInfo updaterInfo, File master, String base, String app, boolean serverOrLaterIsOK, boolean needChmod, CACertsSource cacertsSource) throws IOException, LatestVersionExists {
        times.start("Update JRE");
        try {
            if (GenericUpdater.updateNamed(updaterInfo, master, base, app, !serverOrLaterIsOK, needChmod, cacertsSource)) {
                GenericUpdater.patchCACerts(GenericUpdater.latestUpdate.tempUpdateFolder, cacertsSource);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            times.stop("Update JRE");
        }
    }

    static String autoCopyJWrapperUtils(File gudir, File dir) throws IOException {
        return "jwrapper_utils.jar";
    }

    public static File[] getUninstallExtras() {
        File[] uninst_extras = OS.isWindows() ? new File[]{new JWWindowsOS().getAppStartMenuFolder()} : (OS.isLinux() ? new File[]{} : new File[]{});
        return uninst_extras;
    }

    public static void removeAllStandardShortcuts(JWApp[] jwapps, boolean removeMacOsApplicationLaunchers) throws IOException {
        if (OS.isWindows()) {
            JWWindowsOS win = new JWWindowsOS();
            File appmenu = win.getAppStartMenuFolder();
            FileUtil.deleteDir(appmenu);
        } else if (OS.isLinux()) {
            System.out.println("[GenericUpdater] PostInstall App has requested standard setup of shortcuts etc");
            for (int i = 0; i < jwapps.length; ++i) {
                JWApp jwa = jwapps[i];
                System.out.println("[GenericUpdater] Removing shortcut to " + jwa.getUserVisibleName());
                JWInstallApp.removeAppShortcut(jwa.getUserVisibleName());
                System.out.println("[GenericUpdater] Removing shortcut to " + jwa.getUserVisibleName());
            }
            JWInstallApp.removeAppShortcut("Uninstall " + JWSystem.getAppBundleName());
        } else if (removeMacOsApplicationLaunchers) {
            for (int i = 0; i < jwapps.length; ++i) {
                JWApp jwa = jwapps[i];
                File launcher = JWSystem.getLauncherLocationForVirtualApp(new File("/Applications"), JWSystem.getAppBundleName());
                FileUtil.deleteDir(launcher);
            }
        }
    }

    private static int detectPostInstallMode(File master, String app, boolean sanityCheck) {
        int MODE = MODE_NORMAL;
        int appCount = LaunchFile.getAllVersionsOf(app, master).length;
        System.out.println("[GenericUpdaterMain] Detecting post install/update mode...");
        if (appCount == 0) {
            MODE = MODE_FIRST_RUN_POST_INSTALL;
            System.out.println("[GenericUpdaterMain] Mode: first run of new install (zero apps found)");
        } else {
            File currentApp = LaunchFile.getLatestVersionOf(app, master);
            File appFirstRun = new File(currentApp, FIRST_RUN_FILE);
            if (!appFirstRun.exists()) {
                try {
                    if (!sanityCheck) {
                        appFirstRun.createNewFile();
                    }
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
                if (appCount == 1) {
                    MODE = MODE_FIRST_RUN_POST_INSTALL;
                    System.out.println("[GenericUpdaterMain] Mode: first run of new install (one app found, never run)");
                } else {
                    MODE = MODE_FIRST_RUN_POST_UPDATE;
                    System.out.println("[GenericUpdaterMain] Mode: first run of new update (multiple apps found, latest never run)");
                }
            }
        }
        return MODE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDynamicImage(boolean canOverrideSplash, String dynamicBase64PNGSplash, File splashFile) {
        block13: {
            try {
                if (!canOverrideSplash || dynamicBase64PNGSplash == null || dynamicBase64PNGSplash.length() <= 0) break block13;
                System.out.println("[GenericUpdater] Saving custom slash image to " + splashFile);
                byte[] dynamicSplash = Base64.base64ToByteArray(dynamicBase64PNGSplash);
                FileOutputStream fout = new FileOutputStream(splashFile);
                try {
                    fout.write(dynamicSplash);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                finally {
                    try {
                        fout.close();
                    }
                    catch (Throwable throwable) {}
                    JWGenericOS.setWritableForAllUsers(splashFile, false);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void setupAllStandardShortcuts(String app, File appdir, JWApp[] jwapps, Properties defaultLaunchPropertiesOSX, Properties overridePropertiesOSX, boolean createMacOsApplicationLauncher) throws IOException {
        GenericUpdater.setupAllStandardShortcuts(app, appdir, jwapps, defaultLaunchPropertiesOSX, overridePropertiesOSX, createMacOsApplicationLauncher, null);
    }

    public static void setupAllStandardShortcuts(String app, File appdir, JWApp[] jwapps, Properties defaultLaunchPropertiesOSX, Properties overridePropertiesOSX, boolean createMacOsApplicationLauncher, File targetFolder) throws IOException {
        try {
            if (!OS.isMacOS()) {
                System.out.println("[GenericUpdater] PostInstall App has requested standard setup of shortcuts etc");
                for (int i = 0; i < jwapps.length; ++i) {
                    JWApp jwa = jwapps[i];
                    System.out.println("[GenericUpdater] Creating shortcut to " + jwa.getUserVisibleName());
                    String id = JWLaunchProperties.getProperty("windows_app_id");
                    if (id != null && id.length() > 0) {
                        JWInstallApp.addAppShortcutWithIDInFolder(jwa.getUserVisibleName(), jwa.getFilesystemName(), jwa.getICOFile(), 0, id, targetFolder);
                    } else {
                        JWInstallApp.addAppShortcutInFolder(jwa.getUserVisibleName(), jwa.getFilesystemName(), jwa.getICOFile(), 0, targetFolder);
                    }
                    System.out.println("[GenericUpdater] Created shortcut to " + jwa.getUserVisibleName());
                }
                JWInstallApp.addUninstallerShortcutInFolder("Uninstall " + JWSystem.getAppBundleName(), targetFolder);
            } else if (createMacOsApplicationLauncher) {
                String path;
                int i;
                Object[] keys;
                if (targetFolder == null) {
                    targetFolder = new File("/Applications");
                }
                File dotApp = JWSystem.getLauncherLocationForVirtualApp(targetFolder, JWSystem.getAppBundleName());
                Properties existingProperties = null;
                if (dotApp.exists()) {
                    System.out.println("[GenericUpdater] Got shortcut dot app: " + dotApp);
                    File paramsFile = JWMacOS.getParameterisationFile(dotApp);
                    if (paramsFile.exists()) {
                        System.out.println("[GenericUpdater] Located existing launch properties.");
                        existingProperties = new JWParameteriser().getParameters(paramsFile);
                    }
                }
                if (existingProperties == null) {
                    System.out.println("[GenericUpdater] No existing launch properties found. Populating with defaults.");
                    existingProperties = new Properties();
                    if (defaultLaunchPropertiesOSX != null) {
                        keys = defaultLaunchPropertiesOSX.keySet().toArray();
                        for (i = 0; i < keys.length; ++i) {
                            existingProperties.setProperty((String)keys[i], (String)defaultLaunchPropertiesOSX.get(keys[i]));
                        }
                    }
                }
                if (overridePropertiesOSX != null) {
                    keys = overridePropertiesOSX.keySet().toArray();
                    for (i = 0; i < keys.length; ++i) {
                        existingProperties.setProperty((String)keys[i], (String)overridePropertiesOSX.get(keys[i]));
                    }
                }
                if ((path = JWLaunchProperties.getProperty("launched_from_dynprops")).startsWith("/Applications")) {
                    System.out.println("[GenericUpdater] App was launched from /Applications, no need to write a launcher");
                } else {
                    System.out.println("[GenericUpdater] Writing launcher to /Applications");
                    File launcher = GenericUpdater.saveLauncherShortcutForVirtualApp(app, appdir, targetFolder, JWSystem.getAppBundleName(), existingProperties, false);
                    JWGenericOS.setWritableForAllUsers(launcher, true);
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static File saveLauncherShortcutForVirtualApp(String app, File appdir, File dir, String shortcutName, Properties launchProperties, boolean elevateToAdmin) throws IOException {
        dir.mkdirs();
        File target = JWSystem.getLauncherLocationForVirtualApp(dir, shortcutName);
        System.out.println("[GenericUpdater] Shortcut target is " + target);
        boolean is64 = false;
        if (OS.isLinux() && OS.isLinux64bit()) {
            is64 = true;
        } else if (OS.isMacOS() && JWMacOS.canRunLauncher64()) {
            is64 = true;
            File master = appdir.getParentFile();
            if (LaunchFile.getLatestVersionOf("Mac64JRE", master) == null) {
                is64 = false;
                System.out.println("[GenericUpdater] Capable of mac-64 but no Mac64JRE found in master folder " + master + " so will use mac-32");
            } else {
                System.out.println("[GenericUpdater] Capable of mac-64, will use mac-64");
            }
            if (is64) {
                System.out.println("[GenericUpdater] Setting mac64 launcher JRE name to Mac64JRE in LPs");
                launchProperties.setProperty("jre_name", "Mac64JRE");
            }
        }
        File launcherSrc = new File(appdir, GenericUpdater.getLauncherNameFor(app, OS.isLinux(), is64, OS.isMacOS(), OS.isARM()));
        System.out.println("[GenericUpdater] Shortcut launcher src is " + launcherSrc);
        if (OS.isWindows()) {
            FileUtil.copyFileOrDir(launcherSrc, target);
        } else {
            AutoChmodFile.autoChmodFile(launcherSrc, target, true);
        }
        System.out.println("[GenericUpdater] Copied launcher to shortcut");
        File paramsFile = OS.isMacOS() ? JWMacOS.getParameterisationFile(target) : target;
        if (paramsFile.exists()) {
            JWGenericOS.setWritableForAllUsers(paramsFile, true);
            JWParameteriser jwp = new JWParameteriser();
            jwp.setParameters(launchProperties, paramsFile, true);
            System.out.println("[GenericUpdater] Parameterised launcher created OK");
        } else {
            System.out.println("[GenericUpdater] Warning! Unable to locate parameterisation file");
        }
        return target;
    }

    private static void fixBugsFromPreviousJW(File me, File master) {
        try {
            String lines;
            StringBuffer sb = new StringBuffer();
            File arfile = new File(master, "JWUpdateARInstruction");
            if (arfile.exists() && (lines = FileUtil.readFileAsString(arfile.getAbsolutePath())).length() > 0) {
                String[] all = lines.split("\n");
                for (int i = 0; i < all.length; i += 2) {
                    String from = all[i];
                    String to = all[i + 1];
                    String name = new File(from).getName();
                    String suffix = name.substring(TEMP_FOLDER_PREFIX.length());
                    suffix = suffix.substring(0, suffix.indexOf(45));
                    long tempCreated = Long.parseLong(suffix);
                    long mins = (System.currentTimeMillis() - tempCreated) / 60000L;
                    if (mins > 40L) {
                        System.out.println("[GU BFx] Rename instruction " + name + " is " + mins + " mins old, will delete");
                        continue;
                    }
                    System.out.println("[GU BFx] Rename instruction " + name + " is " + mins + " mins old, will retain");
                    sb.append(from).append("\n");
                    sb.append(to).append("\n");
                }
                File instIncomplete = new File(arfile.getAbsolutePath() + ".ar-inst-incomplete");
                FileUtil.writeFileAsString(instIncomplete.getAbsolutePath(), sb.toString().trim());
                if (!instIncomplete.renameTo(arfile)) {
                    System.out.println("[GenericUpdater] WARNING: Renaming '" + instIncomplete + "' to '" + arfile + "' failed!? (" + arfile.exists() + ")");
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        File[] files = master.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File[] name = files[i].getName();
            if (!name.startsWith(TEMP_FOLDER_PREFIX)) continue;
            String suffix = name.substring(TEMP_FOLDER_PREFIX.length());
            suffix = suffix.substring(0, suffix.indexOf(45));
            long tempCreated = Long.parseLong(suffix);
            long mins = (System.currentTimeMillis() - tempCreated) / 60000L;
            if (mins <= 40L) continue;
            System.out.println("[GU BFx] Temp folder " + (String)name + " is " + mins + " mins old, will delete");
            FileUtil.deleteDir(files[i]);
        }
        if (OS.isMacOS()) {
            File existingBundle = null;
            File existingJRE = null;
            for (File folder : master.listFiles()) {
                if (!folder.isDirectory()) continue;
                if (FileUtil.containsChild(folder, "Contents")) {
                    existingBundle = folder;
                    continue;
                }
                if (!FileUtil.containsChild(folder, "bin") || !FileUtil.containsChild(folder, "lib")) continue;
                existingJRE = folder;
            }
            if (existingJRE != null && existingBundle != null) {
                System.out.println("[GenericUpdater][Repair] My JRE is " + existingJRE.getAbsolutePath());
                System.out.println("[GenericUpdater][Repair] My JRE Bundle is " + existingBundle.getAbsolutePath());
                if (existingJRE.getName().startsWith(TEMP_FOLDER_PREFIX)) {
                    try {
                        String base = JWLaunchProperties.getProperty("update_url");
                        String name = JRE_MAC64_APP;
                        URL versionURL = new URL(GenericUpdater.getSubURL(base, GenericUpdater.getVersionFileNameFor(name)));
                        versionURL = URIUtil.tryGetSafeURLFrom(versionURL);
                        System.out.println("[GenericUpdater] Querying " + versionURL + " for " + name + " version");
                        String text = GenericUpdater.grabAutoFetchedURL(versionURL, VERSION_TIMEOUT).trim();
                        System.out.println("[GenericUpdater] Got back \"" + text + "\"");
                        String filename = "JWrapper-Mac64JRE-" + text + "-complete";
                        File targetJRE = new File(existingJRE.getParentFile(), filename);
                        File targetBundle = new File(existingBundle.getParentFile(), filename + ".plugin");
                        System.out.println("[GenericUpdater][Repair] Renamed JRE is " + targetJRE.getAbsolutePath());
                        System.out.println("[GenericUpdater][Repair] Renamed JRE Bunlde is " + targetBundle.getAbsolutePath());
                        OSXBundleUtil.linkJREAndBundle(existingJRE, existingBundle, targetJRE, targetBundle);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            } else {
                System.out.println("[GenericUpdater][Repair] My JRE is " + existingJRE);
                System.out.println("[GenericUpdater][Repair] My JRE Bundle is " + existingBundle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] margs) {
        if (Switches.SH_guNoEncryptLaunchProps) {
            Switches.SH_encryptLaunchPropFile = false;
        }
        if (LocalSwitches.hardcode_debugAcceptAllSslCerts) {
            try {
                SSLHelper.setupSslAndHttpsToAcceptAllCerts(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        times.start("Total GU Time");
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
        System.setProperty("sun.net.client.defaultReadTimeout", "30000");
        try {
            JWNet.tryForceHttpAgentUnrestrictive();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Security.setProperty("networkaddress.cache.ttl", "30");
            Security.setProperty("networkaddress.cache.negative.ttl", "10");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            boolean isPermanentInstall;
            File useJRE;
            File latest;
            UpdaterInfo updaterInfo;
            LatestUpdate jreUpdate;
            long splashUntil;
            String[] remparams;
            String appVersionURL;
            File master;
            File me;
            int preUpdateMODE;
            String installType;
            String app;
            String jreAppName;
            boolean dynamicUpdateURL;
            String base;
            String guWorkingDir;
            block256: {
                ProxySelector defaultProxySelector;
                int i;
                String[] preargs = margs;
                margs = JWLaunchProperties.argsToNormalArgs(margs);
                guWorkingDir = JWLaunchProperties.getProperty("app_dir");
                File master2 = new File(guWorkingDir).getParentFile();
                StdLogging.startDebugLogging(master2, "GenericUpdater");
                if (JWLaunchProperties.getProperty("debug_logging").length() > 0 || StdLogging.beforeDebugLogUntil(JWLaunchProperties.getProperty("debug_logging_until"))) {
                    StdLogging.startLogging(master2, "GenericUpdater");
                }
                System.out.println("[GenericUpdater] Starting");
                System.out.println(JWLaunchProperties.INSTANCE);
                try {
                    FailoverMonitor.checkSetup(false, new GUFailoverProperties());
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
                SHOW_NO_UI = JWLaunchProperties.hideUI();
                System.out.println("[GenericUpdater] Hide the UI: " + SHOW_NO_UI);
                for (i = 0; i < preargs.length; ++i) {
                    System.out.println("preARG " + i + ": " + preargs[i]);
                }
                for (i = 0; i < margs.length; ++i) {
                    System.out.println("ARG " + i + ": " + margs[i]);
                    String arg = margs[i];
                    if (!arg.startsWith("GU_")) continue;
                    arg = arg.substring(3);
                    System.out.println("[JWrapper] DynProp GU ARG [" + arg + "]");
                    int eq = arg.indexOf(61);
                    if (eq == -1) continue;
                    String key = arg.substring(0, eq);
                    String value = arg.substring(eq + 1);
                    System.out.println("[JWrapper] DynProp GU ARG <" + key + ">=(" + value + ")");
                    JWLaunchProperties.overrideDynamicProperty(key, value);
                }
                String vapp = JWLaunchProperties.getProperty("gu_virt_app");
                if (vapp != null && (vapp = vapp.trim()).length() > 0) {
                    virtualApp = vapp;
                    System.out.println("Virtual app specified in launch properties: " + virtualApp);
                }
                for (int i2 = 0; i2 < 20; ++i2) {
                    String[] tmp;
                    if (margs.length <= 0) continue;
                    if (margs[0].equalsIgnoreCase("JWVAPP")) {
                        virtualApp = margs[1];
                        System.out.println("Virtual app specified in args: " + virtualApp);
                        tmp = new String[margs.length - 2];
                        System.arraycopy(margs, 2, tmp, 0, tmp.length);
                        margs = tmp;
                        continue;
                    }
                    if (!margs[0].equalsIgnoreCase("JWHEADLESS")) break;
                    SHOW_NO_UI = true;
                    System.out.println("Headless specified in args");
                    tmp = new String[margs.length - 1];
                    System.arraycopy(margs, 1, tmp, 0, tmp.length);
                    margs = tmp;
                }
                try {
                    JWNativeAPI.loadLibraryFrom(new File(guWorkingDir));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                base = JWLaunchProperties.getProperty("update_url");
                boolean noUpdateURL = base.equals("X");
                if (base.startsWith("http://0.0.254.254")) {
                    noUpdateURL = true;
                }
                if (noUpdateURL) {
                    System.out.println("[GenericUpdater] NO Update URL (" + base + ")");
                }
                dynamicUpdateURL = JWLaunchProperties.isDynamicUpdateURL();
                jreAppName = JWLaunchProperties.getProperty("jre_name");
                app = JWLaunchProperties.getProperty("app_name");
                int minSplashMS = Integer.parseInt(JWLaunchProperties.getProperty("min_splash_ms"));
                boolean canOverrideSplash = false;
                String canOverrideSplashStr = JWLaunchProperties.getProperty("can_override_splash");
                if (canOverrideSplashStr != null && canOverrideSplashStr.equals("1")) {
                    canOverrideSplash = true;
                }
                matchVersions = JWLaunchProperties.getProperty("match_versions").equalsIgnoreCase("true");
                installType = JWLaunchProperties.getProperty("install_type");
                String dynamicBase64PNGSplash = JWLaunchProperties.getProperty("splash_image");
                appArgs = JWLaunchProperties.getAsProperties();
                System.out.println("[GenericUpdater] Loaded properties");
                try {
                    EventThreadExceptionPrinter.setup();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                System.out.println("[GenericUpdaterMain] Done event exception setup");
                try {
                    String id;
                    if (OS.isWindowsVistaOrAbove() && (id = JWLaunchProperties.getProperty("windows_app_id")) != null && id.length() > 0) {
                        System.out.println("[GenericUpdater] Setting app ID to " + id);
                        JWWindowsOS windowsOS = new JWWindowsOS();
                        windowsOS.setWindowsAppID(id);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (OS.isMacOS()) {
                    System.out.println("[GenericUpdaterMain] Setting OSX app name: " + app);
                    HeadlessOsxUtil.setOSXAppName(app);
                    if (!SHOW_NO_UI) {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                System.out.println("[GenericUpdaterMain] We invoke this via SwingUtilities to load native libraries as we can't do it later for some reason.");
                            }
                        });
                        System.out.println("[GenericUpdaterMain] Showing application");
                        JWNativeAPI.getInstance().showApplication();
                        HeadlessOsxUtil.requestForeground();
                    }
                }
                try {
                    String ver = GenericUpdater.GetVersion();
                    System.out.println("[GenericUpdaterMain] Setting JW GU version of " + ver);
                    appArgs.setProperty("jwrapper_gu_version", ver);
                }
                catch (Throwable ver) {
                    // empty catch block
                }
                if (virtualApp != null) {
                    appArgs.setProperty("gu_virt_app", virtualApp);
                }
                if (virtualApp != null) {
                    if (virtualApp.equals(VAPP_SANITYCHECK)) {
                        System.out.println("[GenericUpdaterMain] doing SANITY CHECK only, will not launch or update");
                        AM_SANITY_CHECK = true;
                    }
                    if (virtualApp.equals(VAPP_UNINSTALLER)) {
                        System.out.println("[GenericUpdaterMain] we are UNINSTALLER, will not launch or update");
                        AM_UNINSTALLER = true;
                    }
                }
                JWLaunchProperties.cleanDir(new File(guWorkingDir));
                File override = new File(JWApp.getJWAppsFolder(new File(guWorkingDir).getParentFile()), GenericUpdater.getUpdateUrlOverrideFileName());
                if (override.exists()) {
                    String orig = base;
                    System.out.println("[GenericUpdaterMain] (update url is being overridden by app)");
                    base = FileUtil.readFileAsStringUTF8(override.getAbsolutePath());
                    appArgs.setProperty("update_url", base);
                    JWLaunchProperties.overrideProperty("update_url", base);
                    System.out.println("[GenericUpdaterMain] Base Update URL: " + base + " (overridden from " + orig + ")");
                } else {
                    System.out.println("[GenericUpdaterMain] Base Update URL: " + base);
                }
                System.out.println("[GenericUpdaterMain] My GU App Folder: " + guWorkingDir);
                System.out.println("[GenericUpdaterMain] JRE App: " + jreAppName);
                System.out.println("[GenericUpdaterMain] App: " + app);
                System.out.println("[GenericUpdaterMain] Min Splash (ms): " + minSplashMS);
                System.out.println("[GenericUpdaterMain] Can Override Splash: " + canOverrideSplash);
                if (dynamicBase64PNGSplash != null) {
                    if (dynamicBase64PNGSplash.length() > 100) {
                        System.out.println("[GenericUpdaterMain] Custom Splash: " + dynamicBase64PNGSplash.substring(0, 99) + "...");
                    } else {
                        System.out.println("[GenericUpdaterMain] Custom Splash: " + dynamicBase64PNGSplash);
                    }
                }
                if ((preUpdateMODE = GenericUpdater.detectPostInstallMode(new File(guWorkingDir).getParentFile(), app, AM_SANITY_CHECK)) == MODE_NORMAL) {
                    System.out.println("[GenericUpdaterMain] Pre-Update Mode: setting mode as normal run");
                } else if (preUpdateMODE == MODE_FIRST_RUN_POST_INSTALL) {
                    appArgs.setProperty("first_run_post_install", "true");
                    System.out.println("[GenericUpdaterMain] Pre-Update Mode: setting mode as post install");
                } else if (preUpdateMODE == MODE_FIRST_RUN_POST_UPDATE) {
                    appArgs.setProperty("first_run_post_update", "true");
                    System.out.println("[GenericUpdaterMain] Pre-Update Mode: setting mode as post update");
                }
                LaunchFile.setAutoCopyJWUtilsAndInclude(guWorkingDir);
                me = new File(guWorkingDir);
                master = me.getParentFile();
                appVersionURL = GenericUpdater.getSubURL(base, GenericUpdater.getVersionFileNameFor(app));
                times.start("JRE Override Writing / Reading");
                File jwapps = JWApp.getJWAppsFolder(master);
                File jreNameOverride = new File(jwapps, GenericUpdater.getJreNameOverrideFileName());
                try {
                    AtomicFileOutputStream.prepareForReading(jreNameOverride);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (jreNameOverride.exists()) {
                    System.out.println("[GenericUpdater] Reading JRE name override file");
                    FileInputStream in = new FileInputStream(jreNameOverride);
                    jreAppName = CFriendlyStreamUtils.readString(in);
                    in.close();
                    System.out.println("[GenericUpdater] Read JRE name " + jreAppName);
                } else {
                    jwapps.mkdirs();
                    System.out.println("[GenericUpdater] Writing JRE name override file");
                    AtomicFileOutputStream fout = new AtomicFileOutputStream(jreNameOverride);
                    BufferedOutputStream bout = new BufferedOutputStream(fout);
                    try {
                        CFriendlyStreamUtils.writeString(fout, jreAppName);
                    }
                    finally {
                        bout.close();
                    }
                    if (OS.isMacOS()) {
                        System.out.println("[GenericUpdater] Setting permissions for override");
                        try {
                            JWGenericOS.setWritableForAllUsers(jreNameOverride, true);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    System.out.println("[GenericUpdater] Wrote JRE name override file");
                }
                times.stop("JRE Override Writing / Reading");
                File appsSharedConfigFolder = new File(master, "JWAppsSharedConfig");
                if (!appsSharedConfigFolder.exists()) {
                    System.out.println("[GenericUpdater] Creating JWAppsSharedConfig folder");
                    appsSharedConfigFolder.mkdirs();
                }
                File wrapperProxy = new File(appsSharedConfigFolder, "DetectedProxy");
                File detectedProxies = new File(appsSharedConfigFolder, "DetectedProxies");
                File userProxies = new File(appsSharedConfigFolder, "AppProxies");
                File credentialsFile = new File(appsSharedConfigFolder, "ProxyCredentials");
                File lastProxy = new File(appsSharedConfigFolder, "LastProxy");
                if (!lastProxy.exists()) {
                    lastProxy.createNewFile();
                }
                if (installType.equalsIgnoreCase("perm_all") && preUpdateMODE == MODE_FIRST_RUN_POST_INSTALL) {
                    System.out.println("[GenericUpdater] Setting proxy files accessible for all users");
                    if (wrapperProxy.exists()) {
                        JWGenericOS.setWritableForAllUsers(wrapperProxy, false);
                    }
                    if (detectedProxies.exists()) {
                        JWGenericOS.setWritableForAllUsers(detectedProxies, false);
                    }
                    if (credentialsFile.exists()) {
                        JWGenericOS.setWritableForAllUsers(credentialsFile, false);
                    }
                    if (userProxies.exists()) {
                        JWGenericOS.setWritableForAllUsers(userProxies, false);
                    }
                    if (lastProxy.exists()) {
                        JWGenericOS.setWritableForAllUsers(lastProxy, false);
                    }
                }
                if ((defaultProxySelector = ProxySelector.getDefault()) != null) {
                    ProxySelector.setDefault(new ProxySelectorWrapper(defaultProxySelector));
                }
                times.start("Proxy Detection");
                if (!noUpdateURL) {
                    URL url = new URL(appVersionURL);
                    JWAsyncProxyDetector.detectAndSetProxyFor(app, appsSharedConfigFolder, url, 5000);
                    try {
                        AutoFetchURL.preFetchUrl(GenericUpdater.getSubURL(base, GenericUpdater.getVersionFileNameFor("JWrapper")), 150);
                        AutoFetchURL.preFetchUrl(appVersionURL, 150);
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
                times.stop("Proxy Detection");
                remparams = margs;
                GenericUpdater.completeAnyAtomicRenames(master);
                splashUntil = 0L;
                times.start("Loading splash + logo");
                try {
                    File splashImage;
                    Object logoPNG;
                    File latest2 = LaunchFile.getLatestVersionOf(app, master);
                    if (latest2 != null) {
                        System.out.println("[GenericUpdaterMain] Using splash + logo from latest app version: " + latest2);
                        System.out.println("[GenericUpdaterMain] Loaded logo");
                        if (!SHOW_NO_UI) {
                            logoPNG = HeadlessOsxUtil.loadImageFromICNS(new File(latest2, GenericUpdater.getIcnsFileNameFor(app)));
                            HeadlessOsxUtil.setOSXAppDockImage(logoPNG);
                            swu = new HeadlessSwipeLoadUtil(true);
                            splashImage = new File(latest2, GenericUpdater.getSplashFileNameFor(app));
                            GenericUpdater.loadDynamicImage(canOverrideSplash, dynamicBase64PNGSplash, splashImage);
                            swu.setBigTo(swu.loadImage(splashImage));
                            swu.setSmallTo(null);
                            System.out.println("[GenericUpdaterMain] Opening splash frame now");
                            swu.makeFrame(app, logoPNG);
                            splashUntil = System.currentTimeMillis() + (long)minSplashMS;
                        }
                    } else {
                        System.out.println("[GenericUpdaterMain] No latest app, will use own stored splash + logo");
                        System.out.println("[GenericUpdaterMain] Processing ICNS file");
                        if (!SHOW_NO_UI) {
                            logoPNG = HeadlessOsxUtil.loadImageFromICNS(new File(me, GenericUpdater.getIcnsFileNameFor(app)));
                            HeadlessOsxUtil.setOSXAppDockImage(logoPNG);
                            swu = new HeadlessSwipeLoadUtil(true);
                            splashImage = new File(me, GenericUpdater.getSplashFileNameFor(app));
                            GenericUpdater.loadDynamicImage(canOverrideSplash, dynamicBase64PNGSplash, splashImage);
                            swu.setBigTo(swu.loadImage(splashImage));
                            swu.setSmallTo(null);
                            System.out.println("[GenericUpdaterMain] Opening splash frame now");
                            System.out.flush();
                            swu.makeFrame(app, logoPNG);
                            splashUntil = System.currentTimeMillis() + (long)minSplashMS;
                        }
                    }
                }
                catch (Throwable t) {
                    System.out.println("[GenericUpdaterMain] Splash popup failed, headless?");
                    t.printStackTrace(System.out);
                }
                times.stop("Loading splash + logo");
                times.start("Loading SWU");
                if (swu == null) {
                    System.out.println("[GenericUpdaterMain] Creating SWU");
                    swu = new HeadlessSwipeLoadUtil(!SHOW_NO_UI);
                    System.out.println("[GenericUpdaterMain] Created SWU");
                }
                times.stop("Loading SWU");
                LatestUpdate appUpdate = null;
                LatestUpdate guUpdate = null;
                jreUpdate = null;
                updaterInfo = new UpdaterInfo();
                updaterInfo.master = master;
                updaterInfo.base = base;
                updaterInfo.jreAppName = jreAppName;
                updaterInfo.allUsersInstall = installType.equalsIgnoreCase("perm_all");
                if (AM_SANITY_CHECK) {
                    GenericUpdater.searchAndUpdateOsArchive(master, new File(guWorkingDir));
                    System.out.println("[GenericUpdaterMain] Not checking for updates (sanity check)");
                    if (matchVersions) {
                        System.out.println("[GenericUpdaterMain] Launch failed because we require matched versions but the latest version has not been sanity checked and installed yet (we are that sanity check) but sanity check will return OK");
                        GenericUpdater.fixBugsFromPreviousJW(me, master);
                        JWSanityTest.exitAndReturnSanityCheckOK();
                    }
                } else if (AM_UNINSTALLER) {
                    System.out.println("[GenericUpdaterMain] Not checking for updates (uninstaller)");
                } else if (!noUpdateURL) {
                    try {
                        System.out.println("[GenericUpdaterMain] Checking for updates...");
                        if (GenericUpdater.updateJavaApp(updaterInfo, master, base, app, installType.equalsIgnoreCase("perm_all"))) {
                            block255: {
                                System.out.println("[GenericUpdaterMain] Updated App");
                                appUpdate = latestUpdate;
                                boolean mustDownloadJRE = true;
                                times.start("JRE Version Check");
                                File latestJRE = LaunchFile.getLatestVersionOf(jreAppName, master);
                                times.stop("JRE Version Check");
                                if (latestJRE != null) {
                                    if (OS.isMacOS() && !jreAppName.equals(JRE_MAC64_APP)) {
                                        System.out.println("[GenericUpdater] JRE present but we are on MacOS-32 so must use the provided (system-copied) JRE");
                                    } else {
                                        int comp;
                                        System.out.println("[GenericUpdaterMain] Checking for app compatibility with latest JRE: " + latestJRE.getName());
                                        String latestJreVer = LaunchFile.pickVersionFromAppFolder(latestJRE);
                                        times.start("Checking JRE Compatability");
                                        try {
                                            comp = LaunchFile.runHookAppFrom(appUpdate.tempUpdateFolder, LaunchFile.JW_VAPP_COMPATIBILITY_APP, appArgs, latestJRE, base, remparams, app + "ECompatibility");
                                        }
                                        catch (AppDoesNotExistException x) {
                                            System.out.println("[GenericUpdater] No virtual app for checking JRE compatibility, will assume incompatible");
                                            comp = 73;
                                        }
                                        times.stop("Checking JRE Compatability");
                                        if (comp == 72) {
                                            System.out.println("[GenericUpdater] JRE is compatible (" + comp + "), App will be set to use JRE " + latestJreVer + " in the future (will not download latest JRE)");
                                            LaunchFile.setJreVersionForApp(appUpdate.tempUpdateFolder, latestJreVer);
                                            mustDownloadJRE = false;
                                        } else {
                                            System.out.println("[GenericUpdater] JRE is not (explicitly) compatible with App so must download JRE");
                                            mustDownloadJRE = true;
                                        }
                                    }
                                } else if (OS.isMacOS() && !jreAppName.equals(JRE_MAC64_APP)) {
                                    System.out.println("[GenericUpdater] No JRE but we are on MacOS-32 so use the system JRE");
                                    mustDownloadJRE = false;
                                } else {
                                    System.out.println("[GenericUpdater] No latest JRE found so will download JRE");
                                }
                                if (GenericUpdater.updateGenericUpdater(updaterInfo, master, base, installType.equalsIgnoreCase("perm_all"))) {
                                    System.out.println("[GenericUpdaterMain] Updated GU");
                                    guUpdate = latestUpdate;
                                    times.start("Auto Copy JWrapper Utils");
                                    GenericUpdater.autoCopyJWrapperUtils(guUpdate.tempUpdateFolder, appUpdate.tempUpdateFolder);
                                    times.stop("Auto Copy JWrapper Utils");
                                } else {
                                    System.out.println("[GenericUpdaterMain] GU not updated");
                                }
                                if (mustDownloadJRE) {
                                    System.out.println("[GenericUpdater] App cannot use an existing JRE so will update to a new one");
                                    try {
                                        if (GenericUpdater.updateJRE(updaterInfo, master, base, jreAppName, false, installType.equalsIgnoreCase("perm_all"), new CACertsSource(new File(guWorkingDir, "cacerts")))) {
                                            System.out.println("[GenericUpdaterMain] Updated JRE");
                                            jreUpdate = latestUpdate;
                                            times.start("Regenerating classes.jsa");
                                            String path = jreUpdate.tempUpdateFolder.getAbsolutePath();
                                            if (!path.endsWith(File.separator)) {
                                                path = path + File.separator;
                                            }
                                            path = path + "bin" + File.separator + "java";
                                            if (OS.isWindows()) {
                                                path = path + "w.exe";
                                            }
                                            try {
                                                System.out.println("[GenericUpdaterMain] Regenerating jsa... [" + path + "]");
                                                Process p = Runtime.getRuntime().exec(new String[]{path, "-Xshare:dump"});
                                                new ProcessPrinter(p, System.out, System.out);
                                                p.waitFor();
                                            }
                                            catch (Exception x) {
                                                System.out.println("[GenericUpdaterMain] Couldn't generate jsa: " + x);
                                            }
                                            times.stop("Regenerating classes.jsa");
                                            times.start("Setting JRE Version for App");
                                            System.out.println("[GenericUpdaterMain] Setting App " + appUpdate.paddedVersion + " to use JRE " + jreAppName + "-" + jreUpdate.paddedVersion);
                                            LaunchFile.setJreVersionForApp(appUpdate.tempUpdateFolder, jreUpdate.paddedVersion);
                                            times.stop("Setting JRE Version for App");
                                            break block255;
                                        }
                                        System.out.println("[GenericUpdaterMain] JRE not updated (due to some failure, not because it already exists), App is not explicitly compatible with latest, so cannot run.  Will fail and exit.");
                                        GenericUpdater.doNoInternetFailAndExit("The JRE update failed but the app is not explicitly compatible with the latest available JRE", JWLanguage.getString("ERROR_JRE_UPDATE_FAILED"), null);
                                    }
                                    catch (LatestVersionExists exver) {
                                        System.out.println("[GenericUpdaterMain] JRE paired with app for download already exists (may not have a compatibility app to automatically pick up latest or this may be an older app version), app will use its paired JRE");
                                        System.out.println("[GenericUpdaterMain] Setting App " + appUpdate.paddedVersion + " to use JRE " + jreAppName + "-" + exver.version);
                                        LaunchFile.setJreVersionForApp(appUpdate.tempUpdateFolder, exver.version);
                                    }
                                }
                            }
                            boolean updateSafe = true;
                            if (guUpdate != null) {
                                boolean sanityResult;
                                System.out.println("[GenericUpdaterMain] GU has been updated, will run sanity check on " + guUpdate.tempUpdateFolder.getName());
                                times.start("GU Sanity Check");
                                if (jreUpdate != null) {
                                    System.out.println("[GenericUpdaterMain] JRE has been updated, will test GU using new JRE " + jreUpdate.tempUpdateFolder.getName());
                                    sanityResult = LaunchFile.runGuSanityCheck(guUpdate.tempUpdateFolder, appArgs, jreUpdate.tempUpdateFolder, base, remparams, "JWSanCheck");
                                } else {
                                    System.out.println("[GenericUpdaterMain] JRE has not been updated, will test GU using current JRE " + JWSystem.getMyJreHome().getName());
                                    sanityResult = LaunchFile.runGuSanityCheck(guUpdate.tempUpdateFolder, appArgs, JWSystem.getMyJreHome(), base, remparams, "JWSanCheck");
                                }
                                times.stop("GU Sanity Check");
                                if (sanityResult) {
                                    System.out.println("[GenericUpdaterMain] Sanity check returned OK");
                                } else {
                                    System.out.println("[GenericUpdaterMain] Sanity check FAILED - will have to refuse this update");
                                    updateSafe = false;
                                    GenericUpdater.cancelAllOutstandingFinalCopies();
                                    File refused = new File(master, GenericUpdater.getRefusedUpdatesFolderName());
                                    refused.mkdirs();
                                    new File(refused, appUpdate.finalUpdateFolder.getName()).createNewFile();
                                }
                            }
                            if (updateSafe) {
                                GenericUpdater.doAllOutstandingFinalCopies();
                            }
                            break block256;
                        }
                        if (latestFailedUpdateUiReason != null) {
                            System.out.println("[GenericUpdaterMain] Failure: unable to update java app " + latestFailedUpdateUiReason);
                        }
                    }
                    catch (IOException x) {
                        System.out.println("[GenericUpdaterMain] Unable to update");
                        x.printStackTrace();
                    }
                } else {
                    System.out.println("[GenericUpdaterMain] Unable to update (this app does not use an update URL)");
                }
            }
            if (swu != null) {
                swu.showInfiniteProgress();
            }
            boolean failDueToServerUnavailable = false;
            if (matchVersions && !AM_UNINSTALLER) {
                try {
                    URL url2 = new URL(appVersionURL);
                    url2 = URIUtil.tryGetSafeURLFrom(url2);
                    String text = GenericUpdater.grabAutoFetchedURL(url2, VERSION_TIMEOUT).trim();
                    System.out.println("[GenericUpdater] Server app version matching required");
                    System.out.println("[GenericUpdater] Got back server app version of \"" + text + "\"");
                    int intver = Integer.parseInt(text);
                    String serverPadver = VersionUtil.padVersion(intver);
                    latest = LaunchFile.getSpecificVersionOf(app, serverPadver, master);
                }
                catch (NumberFormatException x) {
                    System.out.println("[GenericUpdater] Unable to parse server app version, assuming something is wrong with the URL right now, must fail");
                    x.printStackTrace();
                    failDueToServerUnavailable = true;
                    latest = LaunchFile.getLatestVersionOf(app, master);
                }
                catch (IOException x) {
                    System.out.println("[GenericUpdater] Problem fetching server version, assuming something is wrong with the URL right now, must fail");
                    x.printStackTrace();
                    failDueToServerUnavailable = true;
                    latest = LaunchFile.getLatestVersionOf(app, master);
                }
            } else {
                if (AM_UNINSTALLER) {
                    System.out.println("[GenericUpdater] Server app version matching not required (uninstaller), will run latest");
                } else {
                    System.out.println("[GenericUpdater] Server app version matching not required, will run latest");
                }
                latest = LaunchFile.getLatestVersionOf(app, master);
            }
            if (AM_SANITY_CHECK) {
                System.out.println("[GenericUpdaterMain] Avoiding any further setup as we are sanity check, will exit and return OK");
                GenericUpdater.fixBugsFromPreviousJW(me, master);
                JWSanityTest.exitAndReturnSanityCheckOK();
            }
            if (latest == null) {
                System.out.println("[GenericUpdater] No " + app + " apps found to launch!");
                if (latestFailedUpdateUiReason != null) {
                    GenericUpdater.doNoInternetFailAndExit("Unexpectedly, there were no extracted app bundles found even after the update process", latestFailedUpdateUiReason, null);
                } else {
                    GenericUpdater.doNoInternetFailAndExit("Unexpectedly, there were no extracted app bundles found even after the update process", JWLanguage.getString("ERROR_NO_APP_TO_LAUNCH"), null);
                }
            } else {
                System.out.println("[GenericUpdater] Will launch app " + latest.getName());
            }
            if (OS.isMacOS() && !jreAppName.equals(JRE_MAC64_APP)) {
                System.out.println("[GenericUpdater] No specific JRE required for MacOS");
                useJRE = null;
            } else {
                String jreVer;
                block258: {
                    String specifiedVer = LaunchFile.getJreVersionForApp(latest);
                    if (specifiedVer == null) {
                        String latestJreVer;
                        System.out.println("[GenericUpdater] No JRE specified for App " + latest.getName() + " so far");
                        File latestJRE = LaunchFile.getLatestVersionOf(jreAppName, master);
                        if (latestJRE == null) {
                            System.out.println("[GenericUpdater] No JRE (" + jreAppName + ") found to launch!");
                            GenericUpdater.doNoInternetFailAndExit("Unexpectedly, there were no extracted JRE bundles found even after the update process", JWLanguage.getString("ERROR_NO_RUNTIME_TO_LAUNCH"), null);
                        }
                        if (Long.parseLong(latestJreVer = LaunchFile.pickVersionFromAppFolder(latestJRE)) == 0L) {
                            int comp;
                            System.out.println("[GenericUpdater] Latest JRE is an existing system JRE, must check compatibility");
                            try {
                                times.start("JRE Sanity Check");
                                comp = LaunchFile.runHookAppFrom(latest, LaunchFile.JW_VAPP_COMPATIBILITY_APP, appArgs, latestJRE, base, remparams, app + "SCompatibility");
                            }
                            catch (AppDoesNotExistException x) {
                                System.out.println("[GenericUpdater] No virtual app for checking JRE compatibility, will assume incompatible");
                                comp = 73;
                            }
                            finally {
                                times.stop("JRE Sanity Check");
                            }
                            if (comp == 72) {
                                System.out.println("[GenericUpdater] JRE is compatible (" + comp + "), App will be set to use JRE " + latestJreVer + " in the future");
                                LaunchFile.setJreVersionForApp(latest, latestJreVer);
                                jreVer = latestJreVer;
                            } else {
                                System.out.println("[GenericUpdater] JRE is NOT compatible (" + comp + "), will download updated JRE now");
                                try {
                                    if (GenericUpdater.updateJRE(updaterInfo, master, base, jreAppName, false, installType.equalsIgnoreCase("perm_all"), new CACertsSource(new File(guWorkingDir, "cacerts")))) {
                                        System.out.println("[GenericUpdater] Updated JRE");
                                        jreUpdate = latestUpdate;
                                        GenericUpdater.patchCACerts(jreUpdate.tempUpdateFolder, new CACertsSource(new File(guWorkingDir, "cacerts")));
                                        System.out.println("[GenericUpdater] Setting App " + latest.getName() + " to use JRE " + jreAppName + "-" + jreUpdate.paddedVersion);
                                        times.start("Post Process JRE Download");
                                        GenericUpdater.doAllOutstandingFinalCopies();
                                        LaunchFile.setJreVersionForApp(latest, jreUpdate.paddedVersion);
                                        jreVer = jreUpdate.paddedVersion;
                                        times.stop("Post Process JRE Download");
                                        break block258;
                                    }
                                    jreVer = null;
                                    System.out.println("[GenericUpdater] App is not compatible with existing system JRE and update to JRE failed");
                                    GenericUpdater.doNoInternetFailAndExit("The app is not compatible with the existing (system-imported) JRE and the attempt to fetch a compatible one failed", JWLanguage.getString("ERROR_CANNOT_FETCH_RUNTIME"), null);
                                }
                                catch (LatestVersionExists exver) {
                                    System.out.println("[GenericUpdater] WARNING: unexpected case.  Latest JRE version reported as 0 (system) yet JRE updater reports paired JRE (" + exver.version + ") as already existing!");
                                    System.out.println("[GenericUpdater] Setting App " + latest.getName() + " to use (apparently preexisting!?) JRE paired for download " + jreAppName + "-" + exver.version);
                                    LaunchFile.setJreVersionForApp(latest, exver.version);
                                    jreVer = exver.version;
                                }
                            }
                        } else {
                            System.out.println("[GenericUpdater] Latest JRE is downloaded/extracted JRE so is acceptable");
                            System.out.println("[GenericUpdater] Will set App to use " + latestJreVer + " in the future");
                            LaunchFile.setJreVersionForApp(latest, latestJreVer);
                            jreVer = latestJreVer;
                        }
                    } else {
                        jreVer = specifiedVer;
                    }
                }
                useJRE = new File(master, GenericUpdater.getAppFolderNameFor(jreAppName, jreVer));
                if (!useJRE.exists()) {
                    System.out.println("[GenericUpdater] Specified App JRE " + jreAppName + "-" + jreVer + " does not exist!");
                    GenericUpdater.doNoInternetFailAndExit("Unexpectedly, the chosen JRE (" + jreAppName + "-" + jreVer + ") does not exist", JWLanguage.getString("ERROR_RUNTIME_DOES_NOT_EXIST"), null);
                }
                System.out.println("[GenericUpdater] Will use JRE " + useJRE.getName());
                System.out.println("[GenericUpdater] Launching app: " + latest.getName());
                System.out.println("[GenericUpdater] Using JRE: " + useJRE.getName() + " [exists=" + useJRE.exists() + "]");
            }
            if (swu != null) {
                swu.waitForAllSwipes();
                if (swu.isShowingFrame()) {
                    swu.swipeSmallTo("SmallLaunching");
                }
                swu.waitForAllSwipes();
                System.out.println("[GenericUpdater] Splash should be shown for " + (splashUntil - System.currentTimeMillis()));
                if (swu.isShowingFrame()) {
                    System.out.println("[GenericUpdater] waiting for splash...");
                    while (System.currentTimeMillis() < splashUntil) {
                        try {
                            Thread.sleep(25L);
                        }
                        catch (Exception jreVer) {}
                    }
                } else {
                    System.out.println("[GenericUpdater] not waiting for splash (none shown)");
                }
            }
            int postUpdateMODE = GenericUpdater.detectPostInstallMode(new File(guWorkingDir).getParentFile(), app, AM_SANITY_CHECK);
            if (preUpdateMODE == MODE_FIRST_RUN_POST_INSTALL) {
                postUpdateMODE = MODE_FIRST_RUN_POST_INSTALL;
                System.out.println("[GenericUpdaterMain] Post Update Mode: overridden by pre-update mode of post-install");
            }
            if (preUpdateMODE == MODE_FIRST_RUN_POST_UPDATE) {
                postUpdateMODE = MODE_FIRST_RUN_POST_UPDATE;
                System.out.println("[GenericUpdaterMain] Post Update Mode: overridden by pre-update mode of post-update");
            }
            if (postUpdateMODE == MODE_NORMAL) {
                appArgs.remove("first_run_post_install");
                appArgs.remove("first_run_post_update");
                System.out.println("[GenericUpdaterMain] Post Update Mode: setting mode as normal-run");
            } else if (postUpdateMODE == MODE_FIRST_RUN_POST_INSTALL) {
                appArgs.setProperty("first_run_post_install", "true");
                appArgs.remove("first_run_post_update");
                System.out.println("[GenericUpdaterMain] Post Update Mode: setting mode as post-install");
            } else if (postUpdateMODE == MODE_FIRST_RUN_POST_UPDATE) {
                appArgs.remove("first_run_post_install");
                appArgs.setProperty("first_run_post_update", "true");
                System.out.println("[GenericUpdaterMain] Post Update Mode: setting mode as post-update");
            }
            boolean bl = isPermanentInstall = installType.equalsIgnoreCase("perm_all") || installType.equalsIgnoreCase("perm_user");
            if (postUpdateMODE == MODE_FIRST_RUN_POST_INSTALL || postUpdateMODE == MODE_FIRST_RUN_POST_UPDATE) {
                int command;
                if (isPermanentInstall) {
                    File winLauncher32 = new File(latest, GenericUpdater.getLauncherNameFor(app, false, false, false, false));
                    File winLauncher64 = new File(latest, GenericUpdater.getLauncherNameFor(app, false, true, false, false));
                    File linLauncher32 = new File(latest, GenericUpdater.getLauncherNameFor(app, true, false, false, false));
                    File linLauncher64 = new File(latest, GenericUpdater.getLauncherNameFor(app, true, true, false, false));
                    File winTarget32 = new File(master, GenericUpdater.getLauncherNameFor(app, false, false, false, false));
                    File winTarget64 = new File(master, GenericUpdater.getLauncherNameFor(app, false, true, false, false));
                    File linTarget32 = new File(master, GenericUpdater.getLauncherNameFor(app, true, false, false, false));
                    File linTarget64 = new File(master, GenericUpdater.getLauncherNameFor(app, true, true, false, false));
                    JWParameteriser jwp = new JWParameteriser();
                    try {
                        if (postUpdateMODE != MODE_FIRST_RUN_POST_UPDATE) {
                            times.start("Setting up launchers");
                            if (OS.isWindows()) {
                                System.out.println("[GenericUpdater] Setting up/Updating windows app launcher");
                                if (JWWindowsOS.getWindowsInstance().is64BitWindowsOS()) {
                                    winTarget64.delete();
                                    FileUtil.copy(winLauncher64, winTarget64);
                                    System.out.println("[GenericUpdater] Set up windows 64 app launcher");
                                    jwp.setParameters(appArgs, winTarget64, true);
                                    System.out.println("[GenericUpdater] Set up windows 64 app launcher launch props");
                                } else {
                                    winTarget32.delete();
                                    FileUtil.copy(winLauncher32, winTarget32);
                                    System.out.println("[GenericUpdater] Set up windows 32 app launcher");
                                    jwp.setParameters(appArgs, winTarget32, true);
                                    System.out.println("[GenericUpdater] Set up windows 32 app launcher launch props");
                                }
                            } else if (OS.isLinux()) {
                                System.out.println("[GenericUpdater] Setting up/Updating linux app launcher");
                                if (OS.isLinux64bit()) {
                                    linTarget64.delete();
                                    AutoChmodFile.autoChmodFile(linLauncher64, linTarget64, true);
                                    System.out.println("[GenericUpdater] Set up linux 64 app launcher");
                                    jwp.setParameters(appArgs, linTarget64, true);
                                    System.out.println("[GenericUpdater] Set up linux 64 app launcher launch props");
                                } else {
                                    AutoChmodFile.autoChmodFile(linLauncher32, linTarget32, true);
                                    System.out.println("[GenericUpdater] Set up/Updating linux 32 app launcher");
                                    jwp.setParameters(appArgs, linTarget32, true);
                                    System.out.println("[GenericUpdater] Set up linux 32 app launcher launch props");
                                }
                            }
                            times.stop("Setting up launchers");
                        }
                    }
                    catch (Exception x) {
                        System.out.println("***WARNING*** Failed to set up/update launcher: " + x);
                        x.printStackTrace();
                    }
                }
                JWApp[] jwapps = JWApp.getAllJWApps(latest, true);
                for (int i = 0; i < jwapps.length; ++i) {
                    try {
                        try {
                            if (jwapps[i].getICOFile().exists()) {
                                JWGenericOS.setWritableForAllUsers(jwapps[i].getICOFile(), false);
                            }
                        }
                        catch (Throwable linLauncher32) {
                            // empty catch block
                        }
                        System.out.println("[GenericUpdater] Storing/Updating ICO file for " + jwapps[i].getUserVisibleName() + " (" + jwapps[i].getICOFile() + ")");
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(jwapps[i].getICOFile()));
                        ((OutputStream)out).write(jwapps[i].logoICO);
                        ((OutputStream)out).close();
                        JWGenericOS.setWritableForAllUsers(jwapps[i].getICOFile(), false);
                        continue;
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                        System.out.println("[GenericUpdater] ***WARNING*** Unable to update ICO file for " + jwapps[i].getUserVisibleName() + " (" + jwapps[i].getICOFile() + ") " + x);
                    }
                }
                if (isPermanentInstall) {
                    try {
                        IcoPng icp = new IcoPng(new File(latest, GenericUpdater.getUninstallerIcopngFileNameFor(app)));
                        File uninstallerICO = new File(JWApp.getJWAppsFolder(master), GenericUpdater.getUninstallerIcoFileNameFor(app));
                        try {
                            if (uninstallerICO.exists()) {
                                JWGenericOS.setWritableForAllUsers(uninstallerICO, false);
                            }
                        }
                        catch (Throwable linLauncher64) {
                            // empty catch block
                        }
                        FileUtil.writeFile(uninstallerICO, icp.getICO());
                        JWGenericOS.setWritableForAllUsers(uninstallerICO, false);
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                        System.out.println("[GenericUpdater] ***WARNING*** Unable to update Uninstaller ICO file " + x);
                    }
                }
                System.out.println("[GenericUpdater] Performing first time setup");
                try {
                    times.start("Post install app");
                    command = LaunchFile.runHookAppFrom(latest, LaunchFile.JW_VAPP_POST_INSTALL_APP, appArgs, useJRE, base, remparams, app + "Launcher");
                }
                catch (AppDoesNotExistException x) {
                    System.out.println("[GenericUpdater] No virtual app for post installation configuration, will perform standard config");
                    command = 41;
                }
                finally {
                    times.stop("Post install app");
                }
                if (!isPermanentInstall) {
                    System.out.println("[GenericUpdater] Temporary install, so skipping PostInstallApp setup.");
                } else if (command == 42) {
                    System.out.println("[GenericUpdater] PostInstall App has finished its own post install setup and does not require standard setup");
                } else if (command == 41) {
                    times.start("Standard shortcuts");
                    GenericUpdater.setupAllStandardShortcuts(app, latest, jwapps, appArgs, null, true);
                    times.stop("Standard shortcuts");
                } else if (command == 43) {
                    System.out.println("[GenericUpdater] PostInstall App has requested rollback and uninstall");
                    if (postUpdateMODE == MODE_FIRST_RUN_POST_INSTALL) {
                        try {
                            SelfDelete.deleteSelf(master, GenericUpdater.getUninstallExtras(), null, null, new byte[0], new byte[0]);
                        }
                        catch (IOException x) {
                            x.printStackTrace();
                        }
                        ProcessOutputUtil.logProcessResult(LOG_SOURCE, 3);
                        ProcessOutputUtil.logProcessError(LOG_SOURCE, "The post-install virtual app for this app bundle requested that the install be rolled back");
                        System.exit(0);
                    } else {
                        System.out.println("[GenericUpdater] Will not roll back since this is an update");
                    }
                }
            }
            times.start("Translations");
            String[] suplangs = JWSystem.getSupportedLanguages();
            for (int i = 0; i < suplangs.length; ++i) {
                System.out.println("[GenericUpdater] Supported language: " + suplangs[i]);
            }
            String mylang = JWInstallApp.getChosenLanguage();
            System.out.println("[GenericUpdater] Current chosen language is: " + mylang);
            if (mylang == null) {
                if (suplangs.length == 1) {
                    mylang = suplangs[0];
                    System.out.println("[GenericUpdater] Automatically choosing only supported language: " + mylang);
                    JWInstallApp.setChosenLanguage(mylang);
                } else if (SHOW_NO_UI) {
                    mylang = suplangs[0];
                    System.out.println("[GenericUpdater] Automatically choosing first supported language (not allowed to show UI to ask): " + mylang);
                    JWInstallApp.setChosenLanguage(mylang);
                } else {
                    System.out.println("[GenericUpdater] Showing language chooser");
                    mylang = JWInstallApp.showLanguageChooser();
                    if (mylang == null) {
                        System.out.flush();
                        System.err.flush();
                        System.exit(88);
                    }
                    System.out.println("[GenericUpdater] New chosen language is: " + mylang);
                    JWInstallApp.setChosenLanguage(mylang);
                }
            }
            JWLanguage.loadTranslations(mylang);
            times.stop("Translations");
            if (AM_UNINSTALLER) {
                int command;
                try {
                    command = LaunchFile.runHookAppFrom(latest, LaunchFile.JW_VAPP_PRE_UNINSTALL_APP, appArgs, useJRE, base, remparams, app + "Uninstall");
                }
                catch (AppDoesNotExistException x) {
                    boolean auto = false;
                    try {
                        String val = JWLaunchProperties.getProperty(AUTO_UNINSTALLER);
                        if (val != null && ((val = val.trim()).equalsIgnoreCase("yes") || val.equalsIgnoreCase("true"))) {
                            auto = true;
                        }
                    }
                    catch (Throwable val) {
                        // empty catch block
                    }
                    if (auto) {
                        System.out.println("[GenericUpdater] Configured to do immediate auto-uninstall");
                        command = 61;
                    }
                    System.out.println("[GenericUpdater] No virtual app for pre uninstallation configuration, will ask user");
                    command = 62;
                }
                File splash = new File(latest, GenericUpdater.getSplashFileNameFor(app));
                byte[] splashBytes = FileUtil.readFile(splash.getAbsolutePath());
                byte[] logoBytes = null;
                try {
                    logoBytes = (byte[])HeadlessOsxUtil.loadPngBytesFromICNS(new File(latest, GenericUpdater.getIcnsFileNameFor(app)));
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                if (command == 61) {
                    System.out.println("[GenericUpdater] Told to do immediate uninstall");
                    new Uninstaller(master, GenericUpdater.getUninstallExtras(), splashBytes, logoBytes, latest, useJRE, base, remparams, app).start();
                    return;
                }
                if (command == 62) {
                    System.out.println("[GenericUpdater] Told to do ask user if uninstall (show usual uninstaller UI)");
                    HeadlessSwipeLoadUtil suu = new HeadlessSwipeLoadUtil(true);
                    suu.setBigTo(suu.loadImage(splash));
                    suu.setSmallTo(null);
                    suu.makeUninstaller(app, suu.loadImage(logoBytes), new Uninstaller(suu, master, GenericUpdater.getUninstallExtras(), splashBytes, logoBytes, latest, useJRE, base, remparams, app));
                    suu.ensureShowing();
                    System.out.println("[GenericUpdater] Showing uninstaller UI to ask user");
                    return;
                }
                ProcessOutputUtil.logProcessResult(LOG_SOURCE, 3);
                ProcessOutputUtil.logProcessError(LOG_SOURCE, "The app bundle uninstaller virtual application returned that uninstallation should be cancelled");
                System.exit(0);
            }
            if (virtualApp == null) {
                System.out.println("[GenericUpdater] No virtual app specified, will check count");
                JWApp[] apps = JWApp.getAllJWApps(latest, true);
                if (apps.length == 0) {
                    throw new Exception("No JWAppSpec found!");
                }
                if (apps.length == 1) {
                    virtualApp = apps[0].name;
                    System.out.println("[GenericUpdater] Only one app, autoselecting " + virtualApp);
                } else {
                    System.out.println("[GenericUpdater] No virtual app specified, will check count");
                    if (swu != null) {
                        swu.hideFrame();
                    }
                    if ((virtualApp = HeadlessVirtualAppChooserUtil.chooseVirtualApp(latest, apps)) == null) {
                        System.out.flush();
                        System.err.flush();
                        System.exit(89);
                    }
                }
                System.out.println("[GenericUpdater] Virtual app set to: " + virtualApp);
                appArgs.setProperty("gu_virt_app", virtualApp);
            }
            if (swu != null) {
                swu.hideFrame();
            }
            if (failDueToServerUnavailable) {
                int ret;
                if (AM_SANITY_CHECK) {
                    System.out.println("[GenericUpdaterMain] Launch failed because server was unavailable (matched versions) but sanity check will return OK");
                    JWSanityTest.exitAndReturnSanityCheckOK();
                }
                if ((ret = LaunchFile.runHookAppFrom(latest, LaunchFile.JW_VAPP_MATCH_VERSIONS_SERVER_UNAVAILABLE, appArgs, useJRE, base, remparams, app + "Unavailable")) == 83) {
                    String newURL = JWSystem.getSourceLauncherUpdateURL();
                    String oldURL = base;
                    System.out.println("[GenericUpdaterMain] Server Unavailable App requested relaunch, old URL is " + oldURL + " new URL is " + newURL);
                    try {
                        System.out.println("[GenericUpdaterMain] URL has changed, will relaunch");
                        File latestGU = LaunchFile.getLatestVersionOf("JWrapper", master);
                        System.out.println("[GenericUpdaterMain] Will launch GU app " + latestGU);
                        appArgs.setProperty("update_url", newURL);
                        LaunchFile.runVirtualAppFromNoExit(latestGU, appArgs, useJRE, dynamicUpdateURL ? "D" : base, new String[0], "JWrapper", false);
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                    Thread.sleep(1500L);
                    System.exit(0);
                } else if (ret == 82) {
                    System.out.println("Unable to launch app since it may be the wrong version (couldn't check the update URL server)");
                    Exception x = new Exception("The server that this app connects to is offline (but is required for the app to launch)");
                    ProcessOutputUtil.logProcessResult(LOG_SOURCE, 2);
                    ProcessOutputUtil.logProcessTrace(LOG_SOURCE, x);
                    ProcessOutputUtil.logProcessError(LOG_SOURCE, "The server that this app connects to is offline (but is required for the app to launch)");
                    System.out.flush();
                    System.err.flush();
                    System.exit(1);
                } else {
                    throw new HumanMessageException("The server that this app connects to is offline (but is required for the app to launch)");
                }
            }
            ProcessOutputUtil.logProcessResult(LOG_SOURCE, 1);
            if (AM_SANITY_CHECK) {
                System.out.println("[GenericUpdaterMain] Sanity check will return OK");
                JWSanityTest.exitAndReturnSanityCheckOK();
            }
            if (JWDetectedProxy.DETECTED_PROXY_OK) {
                JWDetectedProxy.revertDefaultProxySettings();
            }
            MasterFolderCleaner.markUsed(latest);
            MasterFolderCleaner.markUsed(new File(guWorkingDir));
            if (useJRE != null) {
                MasterFolderCleaner.markUsed(useJRE);
            }
            int max_apps = 1;
            int max_gus = 1;
            try {
                max_apps = Integer.parseInt(JWLaunchProperties.getProperty("wrapper_app_versions"));
            }
            catch (Exception oldURL) {
                // empty catch block
            }
            try {
                max_gus = Integer.parseInt(JWLaunchProperties.getProperty("wrapper_gu_versions"));
            }
            catch (Exception oldURL) {
                // empty catch block
            }
            if (JWLaunchProperties.getProperty(JWTesting.JWA_REPORT_PORT).length() == 0) {
                MasterFolderCleaner.clean(master, max_apps, max_gus);
            } else {
                System.out.println("[GenericUpdater] Didn't clean log folder since we are testing");
            }
            if (installType.equalsIgnoreCase("perm_all") && postUpdateMODE == MODE_FIRST_RUN_POST_INSTALL) {
                System.out.println("[GenericUpdater] Initial run of all-users installation, setting master folder accessible for all users");
                JWGenericOS.setWritableForAllUsers(master, false);
                File[] tmp = master.listFiles();
                if (tmp != null) {
                    for (File subFile : tmp) {
                        JWGenericOS.setWritableForAllUsers(subFile, false);
                    }
                }
            }
            times.start("Licensing");
            RSADecryptor rsaDec = new RSADecryptor(new BigInteger[]{new BigInteger(new byte[]{0, -126, -92, -128, 105, -24, -21, 15, -79, 69, 30, -7, 122, -127, -33, 123, 8, -31, 62, -39, -109, 42, 80, -41, -125, 85, -98, 18, 72, 33, -80, 110, 116, -35, -42, 63, 115, 29, -99, 57, 45, 127, 56, 62, -78, 70, -114, -57, -16, 118, -98, -102, 97, 23, -80, 98, -104, -54, 86, -59, -95, -31, -108, 118, -103, 16, -74, 44, 42, -44, -33, -63, -128, 12, 32, 55, -70, 2, -92, 125, -46, 90, 80, -96, 39, 97, 84, -117, 49, 13, -48, 31, 68, -115, -16, -107, -103, -79, 82, -93, -106, -86, -17, -46, 64, -51, 47, -27, 33, -52, -123, 38, -9, 106, -16, 125, 99, -90, 34, -109, 90, 58, -5, -57, -34, -20, -100, 4, 62, 12, -21, -128, 65, -110, 90, 90, 92, -111, 23, -34, 89, 124, -11, 26, 8, 86, 100, 38, 14, -13, -98, -34, 78, 82, 95, 62, 45, 68, -93, 80, -116, 86, -56, -37, 33, -42, 125, 76, -121, 62, -68, 93, -69, 91, -102, 77, 12, -109, -100, -51, -76, 110, 59, 8, -40, -12, 126, -108, -6, -18, -59, -29, -94, 57, -10, 72, 14, -16, 48, -52, -19, 16, -111, 120, -102, 104, -81, 101, -65, 72, 40, -56, -25, -117, 0, -2, 68, -71, 115, -89, -113, -60, 77, 113, -76, 28, -117, -6, 72, -78, 87, 20, -1, -14, -127, -37, -30, -104, -29, -19, -95, 37, 68, -31, 67, -101, -5, -118, -3, -104, 39, -72, -82, 63, -81, 85, 70, -128, 94, 22, -8, 103, 114, -96, -120, -101, -15, 22, -20, -56, 54, 125, -53, 120, -39, 9, 73, 4, -98, 111, 57, -110, 40, 51, -90, 100, -76, 20, -117, 13, 4, -99, -80, 124, -56, -98, 28, 52, 69, -111, 29, 46, -63, -88, -46, -71, -77, -20, 82, 33, 102, 84, -4, 58, 34, -6, -28, -90, 56, 40, -84, -71, -55, -119, -91, 11, -76, 27, -127, 74, 21, 43, 16, -32, -13, 58, -13, 70, 77, 115, -8, -41, -103, -121, 55, 35, 112, 0, 63, -18, 40, -40, 126, 25, -40, -9, -87, -70, 20, -5, -24, 104, 50, -103, 19, 20, -34, -46, 21, -121, 120, 27, -74, 12, 74, -12, -29, 50, -98, 44, 31, 31, 51, 124, -2, 103, 20, 64, -80, -83, 95, 118, 121}), new BigInteger(new byte[]{23})});
            File jwlic = new File(latest, "jwrapper_license");
            boolean licensed = false;
            if (jwlic.exists()) {
                byte[] encrypted = FileUtil.readFile(jwlic.getPath());
                byte[] decrypted = rsaDec.decrypt(encrypted);
                String marshalled = new String(decrypted, "UTF8");
                StringBuffer expected = new StringBuffer();
                for (int i = 0; i < 10; ++i) {
                    expected.append("[BUNDLE_NAME]").append(app);
                }
                if (marshalled.equals(expected.toString())) {
                    licensed = true;
                }
            }
            if (licensed) {
                System.out.println("[GenericUpdater] JWrapper is licensed OK");
            } else {
                System.out.println("[GenericUpdater] JWrapper is NOT LICENSED");
            }
            times.stop("Licensing");
            appArgs.setProperty("update_url", base);
            times.stop("Total GU Time");
            times.dumpMetrics();
            LaunchFile.runVirtualAppFromNoExit(latest, appArgs, useJRE, dynamicUpdateURL ? "D" : base, remparams, app, true);
            long printOutputUntil = System.currentTimeMillis() + (long)LaunchFile.POST_LAUNCH_PRINT_FOR;
            while (System.currentTimeMillis() < printOutputUntil) {
                try {
                    Thread.sleep(25L);
                }
                catch (Exception exception) {}
            }
            System.out.flush();
            System.err.flush();
            System.exit(0);
        }
        catch (Throwable t) {
            try {
                if (SHOW_NO_UI) break block260;
                if (JWLanguage.isBundleLoaded()) break block261;
                String[] suplangs = JWSystem.getSupportedLanguages();
                if (suplangs == null) break block262;
                if (suplangs.length > 0) {
                    JWLanguage.loadTranslations(suplangs[0]);
                }
            }
            finally {
                t.printStackTrace();
            }
            {
                block260: {
                    block261: {
                        block262: {
                        }
                    }
                }
            }
        }
    }

    private static void patchCACerts(File tempUpdateFolder, CACertsSource caCertsSource) {
        try {
            if (caCertsSource == null) {
                return;
            }
            System.out.println("[GenericUpdater] Patching CACerts for JRE " + tempUpdateFolder);
            File cacertsTarget = new File(tempUpdateFolder.getPath() + "/lib/security/cacerts");
            System.out.println("[GenericUpdater] Target CACerts is " + cacertsTarget + " (" + cacertsTarget.exists() + ")");
            if (caCertsSource.cacertsFile != null) {
                System.out.println("[GenericUpdater] Source CACerts is " + caCertsSource.cacertsFile + " (" + caCertsSource.cacertsFile.exists() + ")");
                if (caCertsSource.cacertsFile.exists() && caCertsSource.cacertsFile.length() > 0L) {
                    FileUtil.copy(caCertsSource.cacertsFile, cacertsTarget);
                    System.out.println("[GenericUpdater] CACerts has been patched!");
                }
            } else if (caCertsSource.cacertsData != null && caCertsSource.cacertsData.length > 0) {
                System.out.println("[GenericUpdater] Source CACerts is data of length " + caCertsSource.cacertsData.length);
                FileUtil.writeFile(caCertsSource.cacertsFile, caCertsSource.cacertsData);
                System.out.println("[GenericUpdater] CACerts has been patched!");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        LOG_SOURCE = "JWrapper";
        TEMP_FOLDER_PREFIX = "JWrapperTemp-";
        SUCCESS_FOLDER_PREFIX = "JWrapper-";
        SUCCESS_FOLDER_SUFFIX = "-complete";
        DELTA_NAME = "delta";
        JRE_WIN32_APP = "Windows32JRE";
        JRE_WIN64_APP = "Windows64JRE";
        JRE_LIN32_APP = "Linux32JRE";
        JRE_LINARM32_APP = "LinuxARM32JRE";
        JRE_LIN64_APP = "Linux64JRE";
        JRE_MAC64_APP = "Mac64JRE";
        ARC_cross_platform = "_jwcp";
        ARC_windows = "_jwwin";
        ARC_mac32 = "_jwmac32";
        ARC_mac64 = "_jwmac64";
        ARC_lin32 = "_jwlin32";
        ARC_lin64 = "_jwlin64";
        ARC_arm = "_jwarm";
        BUILD_VER_FILE = "jwBuildVersion";
        FIRST_RUN_FILE = "jwFirstRun";
        AUTHOR_PUBKEY_FILE = "jwAuthorPublicKey";
        AUTO_UNINSTALLER = "JWAutoUninstall";
        VAPP_UNINSTALLER = "JWRAPPER_UNINSTALLER";
        VAPP_SANITYCHECK = "JWRAPPER_SANITYCHECK";
        MODE_NORMAL = 0;
        MODE_FIRST_RUN_POST_INSTALL = 1;
        MODE_FIRST_RUN_POST_UPDATE = 2;
        AM_SANITY_CHECK = false;
        AM_UNINSTALLER = false;
        alreadyDownloading = false;
        unpack200exe = null;
        preUpdatedJRE = null;
        SHOW_NO_UI = false;
        times = new TimeSet();
    }

    public static class CACertsSource {
        File cacertsFile;
        byte[] cacertsData;

        public CACertsSource(File cacerts) {
            this.cacertsFile = cacerts;
        }

        public CACertsSource(byte[] cacerts) {
            this.cacertsData = cacerts;
        }
    }

    static class GUFailoverProperties
    implements FailoverListener {
        GUFailoverProperties() {
        }

        @Override
        public long mustFailoverTo(String newURL, long maxDelay, long autoSwitchTimeMS) {
            return 0L;
        }

        @Override
        public void prepareForRelaunch(String newURL) {
        }
    }

    public static class JRELinker
    implements Runnable {
        private File targetBundle;
        private File targetJRE;

        public JRELinker(File targetBundle, File targetJRE) {
            this.targetBundle = targetBundle;
            this.targetJRE = targetJRE;
        }

        @Override
        public void run() {
            System.out.println("[JRELinker] Running...");
            OSXBundleUtil.setupOrRepairOSXJreBundle(this.targetBundle, this.targetJRE);
        }
    }

    static class LatestUpdate {
        File tempUpdateFolder;
        String paddedVersion;
        File finalUpdateFolder;

        LatestUpdate() {
        }
    }

    static class LatestVersionExists
    extends Throwable {
        public String version;

        public LatestVersionExists(String version) {
            this.version = version;
        }
    }

    static class Uninstaller
    extends Thread
    implements LPUninstallerListener {
        File latest;
        File useJRE;
        String base;
        String[] remparams;
        String app;
        HeadlessSwipeLoadUtil swu;
        File master;
        File[] extras;
        byte[] splashPNG;
        byte[] logoPNG;

        Uninstaller(HeadlessSwipeLoadUtil swu, File master, File[] extras, byte[] splashPNG, byte[] logoPNG, File latest, File useJRE, String base, String[] remparams, String app) {
            this.swu = swu;
            this.master = master;
            this.extras = extras;
            this.splashPNG = splashPNG;
            this.logoPNG = logoPNG;
            this.latest = latest;
            this.useJRE = useJRE;
            this.base = base;
            this.remparams = remparams;
            this.app = app;
        }

        Uninstaller(File master, File[] extras, byte[] splashPNG, byte[] logoPNG, File latest, File useJRE, String base, String[] remparams, String app) {
            this.master = master;
            this.extras = extras;
            this.splashPNG = splashPNG;
            this.logoPNG = logoPNG;
            this.latest = latest;
            this.useJRE = useJRE;
            this.base = base;
            this.remparams = remparams;
            this.app = app;
        }

        @Override
        public void doUninstall() {
            if (this.swu != null) {
                this.swu.disableButtons();
                this.swu.swipeSmallTo("SmallUninstall");
            }
            this.start();
        }

        @Override
        public void doExit() {
            ProcessOutputUtil.logProcessResult(LOG_SOURCE, 1);
            ProcessOutputUtil.logProcessMessage(LOG_SOURCE, "The user cancelled the uninstallation");
            System.exit(0);
        }

        @Override
        public void run() {
            int intercept;
            try {
                intercept = LaunchFile.runHookAppFrom(this.latest, LaunchFile.JW_VAPP_POST_UNINSTALL_APP, appArgs, this.useJRE, this.base, this.remparams, this.app + "Uninstall");
            }
            catch (AppDoesNotExistException x) {
                System.out.println("[GenericUpdater] No virtual app for post uninstallation procedures");
                intercept = 61;
            }
            catch (Throwable t) {
                intercept = 63;
                ProcessOutputUtil.logProcessResult(LOG_SOURCE, 2);
                ProcessOutputUtil.logProcessError(LOG_SOURCE, "An unexpected problem occurred while running the post-uninstall app (" + t.getMessage() + ")");
                ProcessOutputUtil.logProcessTrace(LOG_SOURCE, t);
                t.printStackTrace();
                System.out.flush();
                System.err.flush();
                System.exit(1);
            }
            if (intercept == 63) {
                ProcessOutputUtil.logProcessResult(LOG_SOURCE, 3);
                ProcessOutputUtil.logProcessError(LOG_SOURCE, "The app bundle uninstaller virtual application returned that uninstallation should be cancelled");
                System.exit(0);
            }
            if (this.swu != null) {
                this.swu.waitForAllSwipes();
            }
            try {
                String title = "Uninstalling";
                if (this.swu != null) {
                    title = this.swu.getTitle();
                }
                SelfDelete.deleteSelf(this.master, this.extras, this.swu, title, this.splashPNG, this.logoPNG);
            }
            catch (IOException x) {
                x.printStackTrace();
            }
            System.exit(0);
        }
    }

    public static class UpdaterInfo {
        public File master;
        public String base;
        public String jreAppName;
        public boolean allUsersInstall;
    }
}

