/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.ui;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import utils.stream.StreamUtils;

public class JWLanguage {
    private static HashMap translationsMap = null;
    private static boolean bundleLoaded = false;

    public static boolean isBundleLoaded() {
        return bundleLoaded;
    }

    public static void loadTranslations(String bundle) {
        JWLanguage.loadCoreTranslations();
        try {
            JWLanguage.readFileIntoMap("translations/" + bundle.toLowerCase() + ".properties", translationsMap);
            bundleLoaded = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void loadCoreTranslations() {
        if (translationsMap != null) {
            return;
        }
        try {
            translationsMap = new HashMap();
            JWLanguage.readFileIntoMap("translations/translations.properties", translationsMap);
            JWLanguage.readFileIntoMap("translations/en.properties", translationsMap);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void readFileIntoMap(String filename, HashMap targetMap) throws IOException {
        InputStream fin = JWLanguage.class.getResourceAsStream(filename);
        String allStrings = StreamUtils.readAllAsStringUTF8(fin);
        String[] strings = allStrings.split("\\n");
        for (int i = 0; i < strings.length; ++i) {
            int indexOfEquals;
            String text = strings[i];
            if (text == null || (indexOfEquals = text.indexOf(61)) == -1) continue;
            String key = text.substring(0, indexOfEquals).trim();
            String value = text.substring(indexOfEquals + 1).trim();
            targetMap.put(key, value);
        }
    }

    public static String getString(String key) {
        JWLanguage.loadCoreTranslations();
        if (translationsMap == null) {
            return key;
        }
        Object result = translationsMap.get(key);
        if (result != null) {
            return result.toString();
        }
        return key;
    }

    public static void main(String[] args) throws IOException {
        System.out.println(JWLanguage.getString("LANGUAGE_EN"));
        JWLanguage.loadTranslations("gb");
        System.out.println(JWLanguage.getString("LANGUAGE_EN"));
    }

    public static boolean containsTranslationFor(String key) {
        JWLanguage.loadCoreTranslations();
        if (translationsMap == null) {
            return false;
        }
        return translationsMap.containsKey(key);
    }
}

