/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils.test;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.swing.JWSwing;
import jwrapper.jwutils.test.JWTestProgress;
import utils.swing.browser.Browser;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.icons.CircularProgressLabel;
import utils.swing.icons.EmptyIcon;
import utils.swing.icons.InfiniteCircularProgressIcon;
import utils.swing.icons.colorproviders.HueColourProvider;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.GridPanel;
import utils.swing.layout.VariableLinePanel;

public class JWTestUI
implements JWTestProgress {
    SimpleHelpFrame frame;
    JScrollPane runningS;
    JScrollPane completedS;
    GridPanel mainGrid;
    VariableLinePanel completed;
    VariableLinePanel running;
    Border failBorder;
    Border winBorder;
    Border border;
    Color failCol;
    Color normCol;
    Color failClick;
    Color winCol;
    UpdateThread updates;
    boolean finished = false;
    String failPrefix = "FAIL ";
    int FAIL = 0;
    boolean showRunning = true;
    Object LOCK = new Object();
    HashMap<String, BasicPanel> map = new HashMap();
    ArrayList<BasicPanel> runList = new ArrayList();

    @Override
    public void setSequential(boolean sequential) {
        if (sequential && this.showRunning) {
            this.mainGrid.remove(this.runningS);
            this.showRunning = false;
        } else if (!sequential && !this.showRunning) {
            this.mainGrid.add(this.runningS);
            this.showRunning = true;
        }
        this.mainGrid.revalidate();
        this.mainGrid.repaint();
    }

    public void quit() {
        this.finished = true;
    }

    public void showIfNecessary() {
        if (!this.frame.isVisible()) {
            this.completed.removeAll();
            this.running.removeAll();
            this.frame.setVisible(true);
        }
    }

    public JWTestUI() {
        GridPanel gp;
        JWSwing.tryToSetAllFontsAntialiased();
        this.frame = SimpleHelpFrame.getTestFrame();
        this.frame.setTitle("Test Results");
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JWTestUI.this.frame.setVisible(false);
                JWTestUI.this.setSequential(false);
                JWTestUI.this.quit();
            }
        });
        this.frame.setAlwaysOnTop(true);
        this.winCol = new Color(198, 246, 216, 255);
        this.winBorder = new LineBorder(this.winCol, 5, true);
        this.failCol = new Color(255, 204, 217, 255);
        this.failBorder = new LineBorder(this.failCol, 5, true);
        this.failClick = this.normCol = new JPanel().getBackground();
        this.border = new LineBorder(this.normCol, 5, true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int wborder = (int)((double)screenSize.width * 0.05);
        int hborder = (int)((double)screenSize.width * 0.05);
        int height = screenSize.height / 3;
        int width = screenSize.width - wborder;
        int x = wborder / 2;
        int y = screenSize.height - height - hborder;
        this.frame.setBounds(x, y, width, height);
        ScaledInsets insets = new ScaledInsets(5, 5, 0, 5);
        this.completed = new VariableLinePanel(0, false, true);
        this.completed.setGridSpacing(insets);
        this.completed.setOpaque(false);
        this.running = new VariableLinePanel(0, false, true);
        this.running.setGridSpacing(insets);
        this.running.setOpaque(false);
        Color base = new Color(221, 221, 221);
        this.mainGrid = gp = new GridPanel(1, 2, insets);
        gp.setOpaque(true);
        gp.setBackground(base);
        GridPanel cbg = new GridPanel(1, 1);
        cbg.setBackground(base);
        cbg.add(this.completed);
        cbg.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.completedS = new JScrollPane(cbg);
        this.completedS.setHorizontalScrollBarPolicy(31);
        this.completedS.setBorder(null);
        GridPanel rbg = new GridPanel(1, 1);
        rbg.setBackground(base);
        rbg.add(this.running);
        rbg.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.runningS = new JScrollPane(rbg);
        this.runningS.setHorizontalScrollBarPolicy(31);
        this.runningS.setBorder(null);
        gp.add(this.completedS);
        gp.add(this.runningS);
        this.frame.getContentPane().add(gp);
        this.updates = new UpdateThread();
        this.updates.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicPanel getCompleted(String name, long millis) {
        Object object = this.LOCK;
        synchronized (object) {
            BasicPanel bp = this.map.get(name);
            if (bp == null) {
                final BasicPanel fbp = bp = new BasicPanel(name, false, millis);
                try {
                    final JScrollBar sb = this.completedS.getVerticalScrollBar();
                    int endVal = sb.getValue() + sb.getVisibleAmount();
                    final boolean autoScroll = endVal >= sb.getMaximum() - sb.getBlockIncrement();
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            JWTestUI.this.completed.add(fbp);
                            JWTestUI.this.completed.revalidate();
                            JWTestUI.this.completed.repaint();
                        }
                    });
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (autoScroll) {
                                sb.setValue(sb.getMaximum());
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            this.map.put(name, bp);
            return bp;
        }
    }

    @Override
    public void testError(String error) {
        BasicPanel failure = this.getCompleted(this.failPrefix + ", TEST ERROR : " + error, 99999999L);
        failure.addOne();
        File file = JWSystem.getMyLogFile();
        failure.setLogFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testAttempt(String name, String details, long millis, String logFilePath) {
        System.out.println("[JWTestUI] Attempt: " + name + " (" + millis / 1000L + " secs)");
        System.out.println("[JWTestUI] " + details);
        BasicPanel panel = this.getCompleted(name, millis);
        panel.setDetails(details);
        panel.updateTimeout(millis);
        panel.setLogFile(new File(logFilePath));
        final BasicPanel run = new BasicPanel(name, true, millis);
        Object object = this.LOCK;
        synchronized (object) {
            this.runList.add(run);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JWTestUI.this.running.add(run);
                    JWTestUI.this.running.revalidate();
                    JWTestUI.this.running.repaint();
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testSuccess(String name) {
        System.out.println("[JWTestUI] Success: " + name);
        Object object = this.LOCK;
        synchronized (object) {
            this.removeRunning(name);
            this.getCompleted(name, 99999999L).addOne();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeRunning(String name) {
        Object object = this.LOCK;
        synchronized (object) {
            for (int i = 0; i < this.runList.size(); ++i) {
                BasicPanel bp = this.runList.get(i);
                if (!bp.identify(name)) continue;
                System.out.println("[JWTestUI] REMOVED running " + bp.name);
                this.runList.remove(i--);
                this.running.remove(bp);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            JWTestUI.this.running.revalidate();
                            JWTestUI.this.running.repaint();
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                return true;
            }
        }
        return false;
    }

    class BasicPanel
    extends BorderPanel {
        String name;
        JLabel title;
        JLabel count;
        CircularProgressLabel progress;
        int num = 0;
        public long timeout = 0L;
        String details;
        File logFile;
        long lastAdded = 0L;
        long showFor = 2250L;

        public void addOne() {
            this.lastAdded = System.currentTimeMillis();
            ++this.num;
            this.updateCount();
        }

        private void updateCount() {
            if (this.name.startsWith(JWTestUI.this.failPrefix)) {
                this.count.setText(this.num + " failed ");
            } else {
                this.count.setText(this.num + " successes ");
            }
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            if (this.count != null && !this.name.startsWith(JWTestUI.this.failPrefix)) {
                if (System.currentTimeMillis() - this.lastAdded < this.showFor) {
                    this.setBorder(JWTestUI.this.winBorder);
                    this.count.setBackground(JWTestUI.this.winCol);
                    this.title.setBackground(JWTestUI.this.winCol);
                    if (this.progress != null) {
                        this.progress.setBackground(JWTestUI.this.winCol);
                    }
                } else {
                    this.setBorder(JWTestUI.this.border);
                    this.count.setBackground(JWTestUI.this.normCol);
                    this.title.setBackground(JWTestUI.this.normCol);
                    if (this.progress != null) {
                        this.progress.setBackground(JWTestUI.this.normCol);
                    }
                }
            }
            super.paint(g);
        }

        public boolean identify(String name) {
            return name.equals(this.name);
        }

        public boolean timedOut() {
            return this.getTimeLeft() < 0L;
        }

        public void setLogFile(File file) {
            this.logFile = file;
        }

        public void updateTimeout(long timeout) {
            this.timeout = System.currentTimeMillis() + timeout;
        }

        public long getTimeLeft() {
            return this.timeout - System.currentTimeMillis();
        }

        public void setDetails(String details) {
            this.details = details;
        }

        public BasicPanel(String name, boolean running, long timeout) {
            Color col;
            JWTestUI.this.showIfNecessary();
            this.name = name;
            this.updateTimeout(timeout);
            if (name.startsWith(JWTestUI.this.failPrefix)) {
                this.setBorder(JWTestUI.this.failBorder);
                col = JWTestUI.this.failCol;
            } else {
                this.setBorder(JWTestUI.this.border);
                col = JWTestUI.this.normCol;
            }
            this.setOpaque(false);
            this.title = new JLabel(" " + name);
            this.title.setToolTipText(this.title.getText());
            this.title.setOpaque(true);
            this.title.setBackground(col);
            this.addCenter(this.title);
            if (running) {
                InfiniteCircularProgressIcon icon = new InfiniteCircularProgressIcon(24, 24);
                icon.setColorProvider(new HueColourProvider(new Color(13, 123, 84)));
                icon.setSleep(0L);
                icon.setArcDimensions(SimpleHelpLookAndFeel.scale(14), SimpleHelpLookAndFeel.scale(2));
                icon.reinitRingCount(3);
                this.progress = new CircularProgressLabel(icon);
                this.progress.setOpaque(true);
                this.progress.setBackground(col);
                icon.setUpdateComponent(this.progress);
                icon.switchOn();
                this.addEast(this.progress);
            } else {
                this.count = new JLabel("", new EmptyIcon(24), 0);
                this.updateCount();
                this.count.setOpaque(true);
                this.count.setBackground(col);
                this.addEast(this.count);
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                    if (BasicPanel.this.logFile != null) {
                        Browser.openFileExplorerAndSelectFile(BasicPanel.this.logFile);
                    }
                }
            });
        }
    }

    class UpdateThread
    extends Thread {
        public UpdateThread() {
            super("JWTestUI Updates");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!JWTestUI.this.finished) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Object object = JWTestUI.this.LOCK;
                synchronized (object) {
                    BasicPanel[] panels;
                    for (BasicPanel panel : panels = JWTestUI.this.map.values().toArray(new BasicPanel[0])) {
                        if (!panel.timedOut()) continue;
                        while (JWTestUI.this.removeRunning(panel.name)) {
                            System.out.println("[JWTestUI] Removed running " + panel.name + ", timed out, r=" + JWTestUI.this.runList.size());
                            ++JWTestUI.this.FAIL;
                            BasicPanel failure = JWTestUI.this.getCompleted(JWTestUI.this.failPrefix + JWTestUI.this.FAIL + ": " + panel.name, 99999999L);
                            failure.addOne();
                            failure.setLogFile(panel.logFile);
                        }
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JWTestUI.this.completed.repaint();
                    }
                });
            }
        }
    }
}

