/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils;

import java.io.File;
import java.io.IOException;
import jwrapper.updater.GenericUpdater;
import jwrapper.updater.LaunchFile;
import jwrapper.updater.VersionUtil;

public class JWRepair {
    public static void incrementVersionOnBundlesForReDownload(File deployedBundleFolder, boolean jwrapper, boolean app, boolean jre) throws IOException {
        File[] files = deployedBundleFolder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!LaunchFile.isAppArchive(files[i])) continue;
            String appName = LaunchFile.pickAppNameFromAppFolder(files[i]);
            if (appName.equals("JWrapper")) {
                if (!jwrapper) {
                    System.out.println("Skipping " + files[i].getName());
                    continue;
                }
            } else if (appName.endsWith("JRE")) {
                if (!jre) {
                    System.out.println("Skipping " + files[i].getName());
                    continue;
                }
            } else if (!app) {
                System.out.println("Skipping " + files[i].getName());
                continue;
            }
            int ver = LaunchFile.pickIntegerVersionFromAppArchive(files[i]);
            String newArchiveName = GenericUpdater.getArchiveNameFor(appName, VersionUtil.padVersion(++ver));
            System.out.println("[JWRepair] Moving " + files[i].getName() + " to " + newArchiveName);
            files[i].renameTo(new File(deployedBundleFolder, newArchiveName));
            VersionUtil.writeAppVersionFile(deployedBundleFolder, appName, ver);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: JWRepair <deployed app bundle folder> <update jwrapper (true/false)> <update app (true/false)> <update jre (true/false)>");
        } else {
            File f = new File(args[0]);
            System.out.println("[JWRepair] Incrementing version on " + f);
            JWRepair.incrementVersionOnBundlesForReDownload(f, args[1].equals("true"), args[2].equals("true"), args[3].equals("true"));
        }
    }
}

