/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWLinuxOS;
import jwrapper.jwutils.JWMacOS;
import jwrapper.jwutils.JWWindowsOS;
import utils.files.PermissionsUtil;
import utils.ostools.OS;
import utils.progtools.ProcessPrinter;
import utils.progtools.net.SafeHostname;

public abstract class JWGenericOS {
    protected static JWWindowsOS winInstance = new JWWindowsOS();
    protected static JWLinuxOS linInstance = new JWLinuxOS();
    protected static JWMacOS macInstance = new JWMacOS();
    private static JWOSDescription description = null;

    public abstract String[] getAllConsoleUsers();

    public String getHostname() {
        try {
            String hostname = SafeHostname.getCanonicalHostname();
            if (hostname != null) {
                return hostname.trim();
            }
            return null;
        }
        catch (Exception x) {
            return "Unknown";
        }
    }

    public static JWGenericOS getInstance() {
        if (OS.isWindows()) {
            return winInstance;
        }
        if (OS.isMacOS()) {
            return macInstance;
        }
        return linInstance;
    }

    public String getOSName() {
        return System.getProperty("os.name");
    }

    public String getOSVersion() {
        return System.getProperty("os.version");
    }

    public String getOSNameWithBitness() {
        return this.getOSDescription().getOSNameWithBitness();
    }

    public boolean is64Bit() {
        return System.getProperty("os.arch").contains("64");
    }

    public static void setCurrentDirectory(File dir) throws IOException {
        String directoryPath = dir.getCanonicalPath();
        JWNativeAPI.getInstance().setCurrentDirectory(directoryPath);
        System.setProperty("user.dir", directoryPath);
    }

    public static void setWritableForAllUsersAndWait(File dir, boolean recursive) throws IOException {
        Process p = JWGenericOS.setWritableForAllUsers(dir, recursive);
        if (p != null) {
            try {
                int retCode = p.waitFor();
                System.out.println("[AutoChmod] Completed " + dir + " chmod (" + retCode + ")");
            }
            catch (InterruptedException x) {
                System.out.println("[AutoChmod] Interrupted " + dir + " chmod");
            }
        }
    }

    public static Process setWritableForAllUsers(File dir, boolean recursive) throws IOException {
        System.out.println("[JWGenericOS] Ensuring " + dir.getAbsolutePath() + " is writeable (" + recursive + ")");
        String path = dir.getCanonicalPath();
        if (OS.isLinux() || OS.isMacOS()) {
            String command = "chmod";
            File chmod = new File("/bin/chmod");
            if (chmod.exists()) {
                command = "/bin/chmod";
            }
            Process p = recursive ? Runtime.getRuntime().exec(new String[]{command, "-R", "777", dir.getCanonicalPath()}) : Runtime.getRuntime().exec(new String[]{command, "777", dir.getCanonicalPath()});
            new ProcessPrinter(p, System.out, System.err);
            return p;
        }
        if (OS.isWindows()) {
            return JWGenericOS.setWindowsPermissions(path, "F", recursive, false);
        }
        return null;
    }

    private static Process setWindowsPermissions(String path, String mode, boolean recursive) {
        return JWGenericOS.setWindowsPermissions(path, mode, recursive, false);
    }

    private static Process setWindowsPermissions(String path, String mode, boolean recursive, boolean replace) {
        try {
            System.out.println("[JWGenericOS] Setting permissions for " + path + " to " + mode + " (recursive: " + recursive + ")");
            Process p = Runtime.getRuntime().exec("cacls \"" + path + "\" " + (recursive ? "/t " : "") + "/e " + (replace ? "/p " : "/g ") + "\"Users\":" + mode);
            try {
                OutputStream out = p.getOutputStream();
                out.write("Y\r\n".getBytes());
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                System.out.println("[PermissionsUtil] Warning: unable to flush output stream. (" + ex.getMessage() + ")");
            }
            new ProcessPrinter(p, new PermissionsUtil.NullOutputStream(), System.out);
            return p;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static void setReadableForAllUsersAndWait(File dir, boolean recursive) throws IOException {
        Process p = JWGenericOS.setReadableForAllUsers(dir, recursive);
        if (p != null) {
            try {
                int retCode = p.waitFor();
                System.out.println("[AutoChmod] Completed " + dir + " chmod (" + retCode + ")");
            }
            catch (InterruptedException x) {
                System.out.println("[AutoChmod] Interrupted " + dir + " chmod");
            }
        }
    }

    public static Process setReadableForAllUsers(File dir, boolean recursive) throws IOException {
        System.out.println("[JWGenericOS] Ensuring " + dir.getAbsolutePath() + " is readable (" + recursive + ")");
        if (OS.isLinux() || OS.isMacOS()) {
            Process p = recursive ? Runtime.getRuntime().exec(new String[]{"chmod", "-R", "755", dir.getCanonicalPath()}) : Runtime.getRuntime().exec(new String[]{"chmod", "755", dir.getCanonicalPath()});
            new ProcessPrinter(p, System.out, System.err);
            return p;
        }
        if (OS.isWindows()) {
            return JWGenericOS.setWindowsPermissions(dir.getCanonicalPath(), "R", recursive, true);
        }
        return null;
    }

    public int getCurrentProcessID() {
        return JWNativeAPI.getInstance().getProcessID();
    }

    public static boolean terminateProcess(int pid) {
        if (OS.isLinux()) {
            return JWLinuxOS.getLinuxInstance().killProcess(pid);
        }
        if (OS.isMacOS()) {
            return JWMacOS.getMacOSInstance().killProcess(pid);
        }
        return JWWindowsOS.getWindowsInstance().killProcess(pid);
    }

    public String getOSBuild() {
        return null;
    }

    public String getOSProductName() {
        return null;
    }

    public JWOSDescription getOSDescription() {
        if (description != null) {
            return description;
        }
        description = new JWOSDescription();
        JWGenericOS.description.osName = this.getOSName();
        try {
            JWGenericOS.description.bitString = this.is64Bit() ? "x64" : "x86";
        }
        catch (Throwable t) {
            t.printStackTrace();
            JWGenericOS.description.bitString = System.getProperty("os.arch").contains("64") ? "x64" : "x86";
        }
        try {
            JWGenericOS.description.osVersion = this.getOSVersion();
        }
        catch (Throwable t) {
            t.printStackTrace();
            JWGenericOS.description.osVersion = System.getProperty("os.version");
        }
        try {
            JWGenericOS.description.build = this.getOSBuild();
        }
        catch (Throwable t) {
            t.printStackTrace();
            JWGenericOS.description.build = null;
        }
        try {
            JWGenericOS.description.osProductName = this.getOSProductName();
        }
        catch (Throwable t) {
            t.printStackTrace();
            JWGenericOS.description.osProductName = null;
        }
        return description;
    }

    public static void main(String[] args) throws IOException {
        JWNativeAPI.loadLibrary();
        JWOSDescription desc = JWGenericOS.getInstance().getOSDescription();
        System.out.println("Name: " + desc.osName);
        System.out.println("Bit: " + desc.bitString);
        System.out.println("OSVersion: " + desc.osVersion);
        System.out.println("Build: " + desc.build);
        System.out.println("Product: " + desc.osProductName);
        System.out.println("Full: " + desc.getFullName());
        System.out.println("OS with Bitness: " + desc.getOSNameWithBitness());
    }

    public static class JWOSDescription {
        String osName;
        String bitString;
        String osVersion;
        String build;
        String osProductName;

        public String getFullName() {
            StringBuilder result = new StringBuilder();
            result.append(this.osName);
            if (this.bitString != null) {
                result.append(" ").append(this.bitString);
            }
            result.append(" (");
            if (this.osProductName != null) {
                result.append(this.osProductName);
            }
            if (this.build != null) {
                if (this.osProductName != null) {
                    result.append(" ");
                }
                result.append(this.build);
            }
            if (this.osProductName == null && this.build == null) {
                result.append(this.osVersion);
            }
            result.append(")");
            return result.toString();
        }

        public String getOSNameWithBitness() {
            StringBuilder result = new StringBuilder();
            result.append(this.osName);
            if (this.bitString != null) {
                result.append(" ").append(this.bitString);
            }
            return result.toString();
        }

        public String getOSName() {
            return this.osName;
        }

        public String getBitString() {
            return this.bitString;
        }

        public String getOSVersion() {
            return this.osVersion;
        }

        public String getBuild() {
            return this.build;
        }

        public String getOSProductName() {
            return this.osProductName;
        }
    }
}

