/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import jwrapper.crypt.JWCrypt_Rijndael;
import jwrapper.crypt.JWCrypt_TA;
import utils.files.FileUtil;
import utils.stream.StreamUtils;

public class JWCrypt {
    private static Class[] cparams = new Class[]{String.class};

    public static byte[] loadFile(String path) throws IOException {
        byte[] enc = FileUtil.readFile(path);
        return JWCrypt_TA.processor.process(enc);
    }

    public static byte[] loadResource(String path) throws IOException {
        try {
            InputStream in = JWCrypt.class.getResourceAsStream(path);
            if (in == null) {
                System.out.println("[JWC] Resource at path " + path + " is null");
                return null;
            }
            System.out.println("[JWC] Attempting decrypt of resource at path " + path);
            return JWCrypt_TA.processor.process(StreamUtils.readAll(in));
        }
        catch (Exception x) {
            x.printStackTrace();
            return StreamUtils.readAll(JWCrypt_Rijndael.class.getResourceAsStream(path));
        }
    }

    public static InputStream loadResourceAsStream(String path) throws IOException {
        return new ByteArrayInputStream(JWCrypt.loadResource(path));
    }
}

