/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.hidden;

import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import jwrapper.hidden.events.JWMacOSEventManager;
import jwrapper.jwutils.JWOSXEventListener;
import jwrapper.jwutils.JWWindowsOS;
import jwrapper.jwutils.JWWindowsRegistry;
import jwrapper.jwutils.JWWmi;
import jwrapper.jwutils.pty.WinSize;
import jwrapper.jwutils.wmi.JWWmiQueryResult;
import utils.osstats.winutils.WMIProvider;
import utils.osstats.winutils.WMIRegistry;
import utils.osstats.winutils.WMIResults;
import utils.ostools.OS;

public class JWNativeAPI
implements WMIProvider {
    public static final String JWUTILS_PREFIX = "jwutils_";
    private static final String LIB_WINDOWS_32 = "jwutils_win32";
    private static final String LIB_WINDOWS_64 = "jwutils_win64";
    private static final String LIB_MACOS_32 = "jwutils_macos32";
    private static final String LIB_MACOS_64 = "jwutils_macos64";
    private static final String LIB_LINUX_32 = "jwutils_linux32";
    private static final String LIB_LINUX_64 = "jwutils_linux64";
    private static final String LIB_LINUX_32_ARM = "jwutils_linux32arm";
    private static final String LIB_LINUX_64_ARM = "jwutils_linux64arm";
    static JWNativeAPI INSTANCE = null;
    private static boolean nativeLibrariesLoaded = false;
    public static int TS_GET_SESSION_FAILED = -999;
    private KeybookHookCallback keyboardHookCallback;
    private boolean isKeyboardHookEnabled = false;
    private boolean hasUIGotFocus = true;
    private Object HOOKS_LOCK = new Object();

    public static boolean isLoaded() {
        return nativeLibrariesLoaded;
    }

    public static String getAppropriateLibName(boolean fullname) {
        boolean x86_64 = System.getProperty("os.arch").toLowerCase().contains("64");
        boolean isArm = System.getProperty("os.arch").toLowerCase().contains("arm");
        String osname = System.getProperty("os.name").toLowerCase();
        if (x86_64) {
            System.out.println("[JWrapperNative] Detected 64-bit architecture");
        } else {
            System.out.println("[JWrapperNative] Detected 32-bit architecture");
        }
        String libName = null;
        String extension = "";
        String prefix = "lib";
        if (osname.contains("win")) {
            System.out.println("[JWrapperNative] Detected Windows OS");
            extension = ".dll";
            prefix = "";
            libName = x86_64 ? LIB_WINDOWS_64 : LIB_WINDOWS_32;
        } else if (osname.contains("mac") || osname.contains("darwin")) {
            System.out.println("[JWrapperNative] Detected Mac OS");
            extension = ".jnilib";
            libName = x86_64 ? LIB_MACOS_64 : LIB_MACOS_32;
        } else if (osname.contains("lin")) {
            System.out.println("[JWrapperNative] Detected Linux OS");
            extension = ".so";
            libName = isArm ? (x86_64 ? LIB_LINUX_64_ARM : LIB_LINUX_32_ARM) : (x86_64 ? LIB_LINUX_64 : LIB_LINUX_32);
        } else {
            System.out.println("[JWrapperNative] Unknown OS");
            return null;
        }
        if (fullname) {
            return prefix + libName + extension;
        }
        return libName;
    }

    public static void loadLibrary() throws IOException {
        File jw = new File("../JWrapper");
        if (!jw.exists()) {
            jw = new File("JWrapper");
        }
        if (jw.exists()) {
            if (OS.isMacOS()) {
                JWNativeAPI.loadLibraryFrom(new File(jw, "wrappers/osx"));
            } else if (OS.isWindows()) {
                JWNativeAPI.loadLibraryFrom(new File(jw, "wrappers/windows"));
            } else if (OS.isLinux() && !OS.isARM()) {
                JWNativeAPI.loadLibraryFrom(new File(jw, "wrappers/linux"));
            } else if (OS.isLinux() && !OS.isARM()) {
                JWNativeAPI.loadLibraryFrom(new File(jw, "wrappers/arm"));
            }
        } else {
            JWNativeAPI.loadLibraryFrom(new File("."));
        }
    }

    public static void loadLibraryFrom(File dir) throws IOException {
        if (nativeLibrariesLoaded) {
            return;
        }
        String appropriateLibName = JWNativeAPI.getAppropriateLibName(true);
        if (appropriateLibName == null) {
            nativeLibrariesLoaded = true;
            return;
        }
        System.load(new File(dir, appropriateLibName).getCanonicalPath());
        System.out.println("[JWNativeAPI] Loaded " + new File(dir, appropriateLibName));
        nativeLibrariesLoaded = true;
        WMIRegistry.registerProvider(JWNativeAPI.getInstance());
        if (OS.isMacOS()) {
            JWNativeAPI.getInstance().registerOSXEventListener(JWMacOSEventManager.INSTANCE);
        }
    }

    public static synchronized JWNativeAPI getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JWNativeAPI();
        }
        return INSTANCE;
    }

    public native void OSXListKeyboardInputs();

    public native String getKeyboardLayoutName();

    public native long getCurrentKeyboardLayout();

    public native long getCurrentKeyboardLayoutForThread(int var1);

    public native long[] getKeyboardLayoutList();

    public native void loadKeyboardLayoutName(String var1);

    public native String getShortPath(String var1);

    public native String getEnvShortPath(String var1);

    public native String getHostname();

    public native void setPointer(int var1, int var2);

    public native void mouseDown(int var1);

    public native void mouseUp(int var1);

    public native int getTsMySessionId();

    public native int getTsConsoleSessionId();

    public native int getPointerX();

    public native int getPointerY();

    public native int getCaretX();

    public native int getCaretY();

    public native boolean is32Bit();

    public native boolean setAppID(String var1);

    public native void createShortcut(String var1, String var2, String var3, String var4, String var5, int var6);

    public native void createShortcutWithID(String var1, String var2, String var3, String var4, String var5, int var6, String var7);

    public native boolean terminateProcess(int var1);

    public native String getSpecialFolderPath(int var1);

    public native boolean initJWCom();

    public native JWWmiQueryResult queryJWCom(String var1);

    public native void disconnectJWCom();

    @Override
    public WMIResults queryWMI(String query) {
        return JWWmi.runQuery(query);
    }

    @Override
    public void disconnectWMI() {
        JWWmi.disconnect();
    }

    public void setFrameAlwaysOnTop(Frame window) {
        this.setForceOnTop(window.getTitle());
    }

    public void setWindowAlwaysOnTop(Window window) {
        window.setAlwaysOnTop(true);
    }

    public native String getWindowsEnv(String var1);

    public native String getWindowsUserProgramsFolder();

    public native String getWindowsAllProgramsFolder();

    public native void setForceOnTop(String var1);

    public native void jiggleMouseBySendInput();

    @Override
    public native boolean regDeleteValue(String var1, String var2, String var3);

    @Override
    public native boolean regDeleteKey(String var1, String var2, String var3);

    @Override
    public native boolean regSetBinary(String var1, String var2, String var3, byte[] var4, int var5, String var6);

    @Override
    public native boolean regSet(String var1, String var2, String var3, String var4, String var5);

    @Override
    public native String regGet(String var1, String var2, String var3);

    @Override
    public native String[] regGetChildren(String var1, String var2);

    @Override
    public native boolean regCreateKey(String var1, String var2);

    public native Object[] getRDPSessions();

    public native Object[][] getNetworkInfo();

    private native void installHook();

    public void installKeyboardHookAndBlockThread(KeybookHookCallback keyboardHookCallback) {
        System.out.println("[JWrapperNative] Installing keyboard hook");
        this.keyboardHookCallback = keyboardHookCallback;
        this.installHook();
    }

    public native void uninstallHook();

    private native void setHookEnabled(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyboardHookEnabled(boolean enabled) {
        System.out.println("[JWrapperNative] Keyboard hook enabled state has changed (setting to " + enabled + ")");
        Object object = this.HOOKS_LOCK;
        synchronized (object) {
            this.isKeyboardHookEnabled = enabled;
            this.setHookEnabled(this.isKeyboardHookEnabled && this.hasUIGotFocus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUIHasFocus(boolean hasFocus) {
        System.out.println("[JWrapperNative] UI has focus has changed (now is " + hasFocus + ")");
        Object object = this.HOOKS_LOCK;
        synchronized (object) {
            this.hasUIGotFocus = hasFocus;
            this.setHookEnabled(this.isKeyboardHookEnabled && hasFocus);
        }
    }

    private void processKey(int key, boolean pressed) {
        System.out.println("[JWrapperNative] Keyboard Hook Caught Key: " + key + " (down=" + pressed + ")");
        if (this.keyboardHookCallback != null) {
            this.keyboardHookCallback.keyEvent(key, pressed);
        }
    }

    public void setBlockInputHookEnabled(boolean enabled) {
        System.out.println("[JWrapperNative] Input hook enabled state has changed (now is " + enabled + ")");
        this.setInputHookEnabled(enabled);
    }

    private native void setInputHookEnabled(boolean var1);

    public native void installMouseHook();

    public native void uninstallMouseHook();

    public native void setMouseHookEnabled(boolean var1);

    public native String getUsernameForSession(int var1);

    public native String getDomainForSession(int var1);

    public native String getCurrentUserSid();

    public boolean isConsoleSession() {
        int myID;
        int consoleID = this.getTsConsoleSessionId();
        return consoleID == (myID = this.getTsMySessionId());
    }

    public String getConsoleUserSid() {
        return this.getUserSidForSession(this.getTsConsoleSessionId());
    }

    public String getMySessionUserSid() {
        return this.getUserSidForSession(this.getTsMySessionId());
    }

    public String getFullUsernameForSession(int sessionID) {
        String username = this.getUsernameForSession(sessionID);
        String domain = this.getDomainForSession(sessionID);
        if (domain == null || domain.length() == 0) {
            return username;
        }
        return domain + "\\" + username;
    }

    private String getUserSidForSession(int sessionID) {
        String user = this.getFullUsernameForSession(sessionID);
        System.out.println("[NativeUtils] User for session " + sessionID + " is " + user);
        String sid = this.getSidForUsername(user);
        System.out.println("[NativeUtils] Sid for " + user + " is " + sid);
        return sid;
    }

    public native long openEventLog(String var1, String var2);

    public native boolean closeEventLog(long var1);

    public native long getNumberOfEventLogRecords(long var1);

    public native Object readEventLog(long var1, String var3, int var4, int var5, int var6);

    public String[] getEventLogSources() {
        ArrayList<String> sources = new ArrayList<String>();
        String[][] logNames = JWWindowsRegistry.regGetChildren("HKLM\\SYSTEM\\CurrentControlSet\\services\\eventlog");
        if (logNames != null && logNames.length > 0) {
            for (String logName : logNames[0]) {
                String[][] sourceNames = JWWindowsRegistry.regGetChildren("HKLM\\SYSTEM\\CurrentControlSet\\services\\eventlog\\" + logName);
                if (sourceNames == null || sourceNames.length <= 0) continue;
                sources.addAll(Arrays.asList(sourceNames[0]));
            }
        }
        return sources.toArray(new String[0]);
    }

    public native int getProcessID();

    public native boolean setProcessPriorityHigh(int var1);

    public native boolean setProcessPriorityLow(int var1);

    public native boolean setProcessPriorityNormal(int var1);

    public native String getSidForUsername(String var1);

    public native boolean setCurrentDirectory(String var1);

    public native void showApplication();

    public static void main(String[] args) throws Exception {
        JWNativeAPI.loadLibrary();
        System.out.println(JWWindowsOS.getWindowsInstance().getSpecialFolderPath(0));
    }

    public native void getWindowsVersionInfo(JWWindowsOS.OSVersionInfo var1);

    public native boolean registerURLHandler(String var1, String var2);

    public native void registerOSXEventListener(JWOSXEventListener var1);

    public native boolean isProcessDPIAware();

    public native void keyEvent(int var1, boolean var2);

    public native boolean bringWindowToFront(long var1);

    public native boolean setForegroundWindow(long var1);

    public native int fcntl(int var1, int var2, int var3);

    public native int close(int var1);

    public native int errno();

    public native int tcdrain(int var1);

    public native int kill(int var1, int var2);

    public native int waitpid(int var1, int[] var2, int var3);

    public native int read(int var1, byte[] var2, int var3);

    public native int write(int var1, byte[] var2, int var3);

    public native int execve(String var1, String[] var2, String[] var3);

    public native int forkpty(int[] var1, byte[] var2, Object var3, WinSize var4);

    public native int ioctlAvailable(int var1, int[] var2);

    public native int ioctlGetWinSize(int var1, WinSize var2);

    public native int ioctlSetWinSize(int var1, int var2, int var3, int var4, int var5);

    public static interface KeybookHookCallback {
        public void keyEvent(int var1, boolean var2);
    }
}

