/*
 * Decompiled with CFR 0.152.
 */
package com.simplehelp.macos.uid;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import utils.ostools.OS;
import utils.progtools.ProcessPrinter;
import utils.stream.StreamUtils;

public class UidSetterUtil {
    private static boolean is64Bit() {
        boolean x86_64 = System.getProperty("os.arch").toLowerCase().indexOf("64") != -1;
        return x86_64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getUidSetter() throws IOException {
        if (OS.isMacOS()) {
            File file = File.createTempFile("uidsetter", "");
            try (FileOutputStream fout = new FileOutputStream(file);){
                InputStream resourceAsStream = UidSetterUtil.is64Bit() ? UidSetterUtil.class.getResourceAsStream("uidsetter64") : UidSetterUtil.class.getResourceAsStream("uidsetter32");
                byte[] allData = StreamUtils.readAll(resourceAsStream);
                fout.write(allData);
                fout.flush();
            }
            System.out.println("[UidSetter] Size is " + file.length());
            try {
                Process p = Runtime.getRuntime().exec(new String[]{"chmod", "777", file.getCanonicalFile().getAbsolutePath()});
                new ProcessPrinter(p, System.out, System.err);
                p.waitFor();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return file;
        }
        return null;
    }
}

