/*
 * Decompiled with CFR 0.152.
 */
package com.simplehelp.linux;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import utils.progtools.ProcessPrinter;

public class LinuxServiceManager {
    public static boolean DEBUG_SERVICES_FAIL = false;
    private File initDDirectory = null;
    private File upstartDirectory = null;
    private File systemDDirectory = null;
    private String chkConfigExe = null;
    private String insServExe = null;
    private String initCtlExe = null;
    private String systemctl = null;
    private String service = null;
    private boolean triedUpstart = false;
    private boolean triedInsServ = false;
    private boolean triedChkConfig = false;
    private boolean triedSystemCtl = false;
    private boolean triedService = false;
    private final boolean neverUseUpstart = false;
    private final boolean neverUseInsServ = false;
    private final boolean neverUseChkConfig = false;
    private final boolean neverUseSystemCtl = false;
    private final boolean neverUseService = false;
    private static final String START_RUN_LEVELS = "2 3 4 5";
    private static final String STOP_RUN_LEVELS = "0 1 6";
    private static final String START_PRIORITY = "80";
    private static final String STOP_PRIORITY = "20";
    private final String startRunLevels;
    private final String stopRunLevels;
    private final String stopPriority;
    private final String startPriority;
    private final String startRunLevels_condensed;
    private final String stopRunLevels_condensed;
    private final String postFix = " > /dev/null 2>&1";

    public static void main(String[] args) throws Exception {
    }

    public LinuxServiceManager() {
        this(START_RUN_LEVELS, STOP_RUN_LEVELS, START_PRIORITY, STOP_PRIORITY);
    }

    public LinuxServiceManager(String startRunLevels, String stopRunLevels, String startPriority, String stopPriority) {
        this.startRunLevels = startRunLevels;
        this.stopRunLevels = stopRunLevels;
        this.startPriority = startPriority;
        this.stopPriority = stopPriority;
        this.startRunLevels_condensed = startRunLevels.replaceAll("\\s", "");
        this.stopRunLevels_condensed = stopRunLevels.replaceAll("\\s", "");
    }

    private File getInitDDirectory() {
        if (this.initDDirectory != null) {
            return this.initDDirectory;
        }
        File candidate = new File("/etc/init.d");
        if (this.fileExists(candidate) && this.fileIsDir(candidate)) {
            this.initDDirectory = candidate;
        }
        candidate = new File("/etc/rc.d/init.d");
        if (this.initDDirectory != null && this.fileExists(candidate) && this.fileIsDir(candidate)) {
            this.initDDirectory = candidate;
        }
        System.out.println("[LinuxServiceManager] InitD directory is " + this.initDDirectory);
        return this.initDDirectory;
    }

    private File getSystemDDirectory() {
        if (this.systemDDirectory != null) {
            return this.systemDDirectory;
        }
        File candidate = new File("/etc/systemd/system");
        if (this.fileExists(candidate) && this.fileIsDir(candidate)) {
            this.systemDDirectory = candidate;
        }
        System.out.println("[LinuxServiceManager] SystemD directory is " + this.systemDDirectory);
        return this.systemDDirectory;
    }

    private File getUpstartInitDirectory() {
        if (this.upstartDirectory != null) {
            return this.upstartDirectory;
        }
        File candidate = new File("/etc/init");
        if (this.fileExists(candidate) && this.fileIsDir(candidate)) {
            this.upstartDirectory = candidate;
        }
        System.out.println("[LinuxServiceManager] Upstart directory is " + this.upstartDirectory);
        return this.upstartDirectory;
    }

    private String getChkConfig() {
        if (this.chkConfigExe != null) {
            return this.chkConfigExe;
        }
        if (this.triedChkConfig) {
            return null;
        }
        this.triedChkConfig = true;
        int code = this.runCommandSafe(new String[]{"/bin/sh", "-c", "chkconfig -h"});
        if (code == 0) {
            this.chkConfigExe = "chkconfig";
            System.out.println("[LinuxServiceManager] Detected chkconfig (" + this.chkConfigExe + ")");
        } else {
            code = this.runCommandSafe(new String[]{"/bin/sh", "-c", "/sbin/chkconfig -h"});
            if (code == 0) {
                this.chkConfigExe = "/sbin/chkconfig";
                System.out.println("[LinuxServiceManager] Detected chkconfig (" + this.chkConfigExe + ")");
            }
        }
        return this.chkConfigExe;
    }

    private String getSystemCtl() {
        if (this.systemctl != null) {
            return this.systemctl;
        }
        if (this.triedSystemCtl) {
            return null;
        }
        this.triedSystemCtl = true;
        int code = this.runCommandSafe(new String[]{"/bin/sh", "-c", "systemctl -h"});
        if (code == 0) {
            this.systemctl = "systemctl";
            System.out.println("[LinuxServiceManager] Detected systemctl (" + this.systemctl + ")");
            return this.systemctl;
        }
        code = this.runCommandSafe(new String[]{"/bin/sh", "-c", "/sbin/systemctl -h"});
        if (code == 0) {
            this.systemctl = "/sbin/systemctl";
            System.out.println("[LinuxServiceManager] Detected systemctl (" + this.systemctl + ")");
            return this.systemctl;
        }
        return this.systemctl;
    }

    private String getService() {
        if (this.service != null) {
            return this.service;
        }
        if (this.triedService) {
            return null;
        }
        this.triedService = true;
        int code = this.runCommandSafe(new String[]{"/bin/sh", "-c", "service -h"});
        if (code == 0) {
            this.service = "service";
            System.out.println("[LinuxServiceManager] Detected service (" + this.service + ")");
        } else {
            code = this.runCommandSafe(new String[]{"/bin/sh", "-c", "/sbin/service -h"});
            this.service = "/sbin/service";
            System.out.println("[LinuxServiceManager] Detected service (" + this.service + ")");
        }
        return this.service;
    }

    private String getInsserv() {
        if (this.insServExe != null) {
            return this.insServExe;
        }
        if (this.triedInsServ) {
            return null;
        }
        this.triedInsServ = true;
        int code = this.runCommandSafe(new String[]{"/bin/sh", "-c", "insserv --help"});
        if (code == 0) {
            this.insServExe = "insserv";
            System.out.println("[LinuxServiceManager] Detected insserv (" + this.insServExe + ")");
            return this.insServExe;
        }
        code = this.runCommandSafe(new String[]{"/bin/sh", "-c", "/sbin/insserv --help"});
        if (code == 0) {
            this.insServExe = "/sbin/insserv";
            System.out.println("[LinuxServiceManager] Detected insserv (" + this.insServExe + ")");
            return this.insServExe;
        }
        code = this.runCommandSafe(new String[]{"/bin/sh", "-c", "/etc/insserv --help"});
        if (code == 0) {
            this.insServExe = "/etc/insserv";
            System.out.println("[LinuxServiceManager] Detected insserv (" + this.insServExe + ")");
            return this.insServExe;
        }
        return null;
    }

    private String getUpstart() {
        if (this.initCtlExe != null) {
            return this.initCtlExe;
        }
        if (this.triedUpstart) {
            return null;
        }
        this.triedUpstart = true;
        int code = this.runCommandSafe(new String[]{"/bin/sh", "-c", "initctl --version"});
        if (code == 0) {
            this.initCtlExe = "initctl";
            System.out.println("[LinuxServiceManager] Detected initctl (" + this.initCtlExe + ")");
            return this.initCtlExe;
        }
        code = this.runCommandSafe(new String[]{"/bin/sh", "-c", "/sbin/initctl --version"});
        if (code == 0) {
            this.initCtlExe = "/sbin/initctl";
            System.out.println("[LinuxServiceManager] Detected initctl (" + this.initCtlExe + ")");
            return this.initCtlExe;
        }
        return this.initCtlExe;
    }

    public void installAndStart(String shortName, String desc, String startExec, String stopExec, String workingDir, boolean tryToRespawn) throws Exception {
        boolean worked;
        if (this.getUpstart() != null) {
            try {
                worked = this.installForUpstart(shortName, desc, startExec, workingDir, tryToRespawn);
                if (worked) {
                    System.out.println("[LinuxServiceManager] Installed using Upstart");
                    return;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.getSystemCtl() != null) {
            try {
                worked = this.installForSystemD(shortName, desc, startExec, workingDir, tryToRespawn);
                if (worked) {
                    System.out.println("[LinuxServiceManager] Installed using SystemD");
                    return;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.installForInitD(shortName, desc, startExec, stopExec, workingDir);
        System.out.println("[LinuxServiceManager] Installed using InitD");
    }

    public void remove(String shortName) throws Exception {
        File systemDScriptFile;
        File upstartScriptFile;
        this.stop(shortName);
        shortName = this.normalise(shortName);
        if (this.getUpstart() != null && this.fileExists(upstartScriptFile = this.getUpstartScriptFile(shortName))) {
            this.fileDelete(upstartScriptFile);
            return;
        }
        if (this.getSystemCtl() != null && this.fileExists(systemDScriptFile = this.getSystemDScriptFile(shortName))) {
            this.fileDelete(systemDScriptFile);
            return;
        }
        File initDScriptFile = this.getInitDScript(shortName);
        this.setInitDRunLevels(shortName, initDScriptFile, false);
        this.fileDelete(initDScriptFile);
    }

    public void start(String shortName) throws Exception {
        shortName = this.normalise(shortName);
        if (this.getUpstart() != null && this.setUpstartScriptStatus(shortName, true)) {
            return;
        }
        if (this.getSystemCtl() != null && this.setSystemDScriptStatus(shortName, true)) {
            return;
        }
        File initDScriptFile = this.getInitDScript(shortName);
        this.setInitDScriptStatus(shortName, initDScriptFile, true);
    }

    public void stop(String shortName) throws Exception {
        shortName = this.normalise(shortName);
        if (this.getUpstart() != null && this.setUpstartScriptStatus(shortName, false)) {
            return;
        }
        if (this.getSystemCtl() != null && this.setSystemDScriptStatus(shortName, false)) {
            return;
        }
        File initDScriptFile = this.getInitDScript(shortName);
        this.setInitDScriptStatus(shortName, initDScriptFile, false);
    }

    private boolean installForSystemD(String shortName, String desc, String exec, String workingDir, boolean respawn) throws Exception {
        shortName = this.normalise(shortName);
        File systemdScript = this.installSystemDScript(shortName, desc, exec, workingDir, respawn);
        this.setOwnershipAndPermissions(systemdScript, false);
        if (this.setSystemDScriptStatus(shortName, true)) {
            return true;
        }
        if (!DEBUG_SERVICES_FAIL) {
            this.fileDelete(systemdScript);
        }
        return false;
    }

    private boolean installForUpstart(String shortName, String desc, String exec, String workingDir, boolean respawn) throws IOException, InterruptedException {
        shortName = this.normalise(shortName);
        File upstartScript = this.installUpstartScript(shortName, desc, exec, workingDir, respawn);
        this.setOwnershipAndPermissions(upstartScript, false);
        if (this.setUpstartScriptStatus(shortName, true)) {
            return true;
        }
        if (!DEBUG_SERVICES_FAIL) {
            this.fileDelete(upstartScript);
        }
        return false;
    }

    private File installForInitD(String shortName, String desc, String startExec, String stopExec, String workingDir) throws IOException, InterruptedException {
        shortName = this.normalise(shortName);
        File initDScript = this.installInitDScript(shortName, desc, startExec, stopExec, workingDir);
        this.setOwnershipAndPermissions(initDScript, true);
        this.setInitDRunLevels(shortName, initDScript, true);
        this.setInitDScriptStatus(shortName, initDScript, true);
        return initDScript;
    }

    private String normalise(String shortName) {
        shortName = shortName.toLowerCase();
        shortName = shortName.replaceAll("\\s", "");
        return shortName;
    }

    private void setInitDScriptStatus(String scriptName, File initDScript, boolean startIt) throws IOException, InterruptedException {
        int retCode;
        System.out.println("[LinuxServiceManager] Setting script status for '" + scriptName + "' in dir '" + initDScript + "' where start=" + startIt);
        boolean worked = false;
        if (this.getChkConfig() != null) {
            if (startIt) {
                retCode = this.runCommand(new String[]{"/bin/sh", "-c", this.getChkConfig() + " " + scriptName + " on"});
                System.out.println("[LinuxServiceManager] Set " + scriptName + " to start using ChkConfig (" + retCode + ")");
                retCode = this.runCommand(new String[]{"/bin/sh", "-c", this.getSystemCtl() + " start " + scriptName + ".service"});
                if (retCode == 0) {
                    System.out.println("[LinuxServiceManager] Started " + scriptName + " using systemctl");
                } else {
                    retCode = this.runCommand(new String[]{"/bin/sh", "-c", this.getService() + " " + scriptName + " start" + " > /dev/null 2>&1"});
                    System.out.println("[LinuxServiceManager] Started " + scriptName + " using service (" + retCode + ")");
                }
                worked = retCode == 0;
            } else {
                retCode = this.runCommand(new String[]{"/bin/sh", "-c", this.getChkConfig() + " " + scriptName + " off"});
                System.out.println("[LinuxServiceManager] Stopped " + scriptName + " using ChkConfig (" + retCode + ")");
                retCode = this.runCommand(new String[]{"/bin/sh", "-c", this.getSystemCtl() + " stop " + scriptName + ".service"});
                if (retCode == 0) {
                    System.out.println("[LinuxServiceManager] Stopped " + scriptName + " using systemctl");
                } else {
                    retCode = this.runCommand(new String[]{"/bin/sh", "-c", this.getService() + " " + scriptName + " stop" + " > /dev/null 2>&1"});
                    System.out.println("[LinuxServiceManager] Stopped " + scriptName + " using service (" + retCode + ")");
                }
                boolean bl = worked = retCode == 0;
            }
        }
        if (!worked) {
            if (startIt) {
                retCode = this.runCommand(new String[]{"/bin/sh", "-c", this.getFullPath(initDScript) + " start"});
                System.out.println("[LinuxServiceManager] Started " + scriptName + " (" + retCode + ")");
            } else {
                retCode = this.runCommand(new String[]{"/bin/sh", "-c", this.getFullPath(initDScript) + " stop"});
                System.out.println("[LinuxServiceManager] Stopped " + scriptName + " (" + retCode + ")");
            }
        }
    }

    private void setInitDRunLevels(String scriptName, File initDScript, boolean addIt) throws InterruptedException, IOException {
        block12: {
            int i;
            int retCode;
            boolean worked = false;
            if (this.getChkConfig() != null) {
                if (addIt) {
                    retCode = this.runCommand(new String[]{"/bin/sh", "-c", this.getChkConfig() + " --add " + scriptName});
                    System.out.println("[LinuxServiceManager] Added " + scriptName + " using ChkConfig (" + retCode + ")");
                    worked = retCode == 0;
                } else {
                    retCode = this.runCommand(new String[]{"/bin/sh", "-c", this.getChkConfig() + " --del " + scriptName});
                    System.out.println("[LinuxServiceManager] Removed " + scriptName + " using ChkConfig (" + retCode + ")");
                    boolean bl = worked = retCode == 0;
                }
            }
            if (!worked && this.getInsserv() != null) {
                if (addIt) {
                    retCode = this.runCommand(new String[]{"/bin/sh", "-c", this.getInsserv() + " " + scriptName});
                    System.out.println("[LinuxServiceManager] Added " + scriptName + " using Insserv (" + retCode + ")");
                    worked = retCode == 0;
                } else {
                    retCode = this.runCommand(new String[]{"/bin/sh", "-c", this.getInsserv() + " -r " + scriptName});
                    System.out.println("[LinuxServiceManager] Removed " + scriptName + " using Insserv (" + retCode + ")");
                    boolean bl = worked = retCode == 0;
                }
            }
            if (worked) break block12;
            if (addIt) {
                for (i = 0; i <= 6; ++i) {
                    File targetFile;
                    File runLevelDir;
                    if (this.startRunLevels.contains(Integer.toString(i))) {
                        runLevelDir = new File("/etc/rc" + i + ".d");
                        targetFile = new File(runLevelDir, "S" + this.startPriority + scriptName);
                        this.symlink(initDScript, targetFile);
                    }
                    if (!this.stopRunLevels.contains(Integer.toString(i))) continue;
                    runLevelDir = new File("/etc/rc" + i + ".d");
                    targetFile = new File(runLevelDir, "K" + this.stopPriority + scriptName);
                    this.symlink(initDScript, targetFile);
                }
            } else {
                for (i = 0; i <= 6; ++i) {
                    File runLevelDir;
                    File targetFile;
                    if (this.startRunLevels.contains(Integer.toString(i)) && this.fileExists(targetFile = new File(runLevelDir = new File("/etc/rc" + i + ".d"), "S" + this.startPriority + scriptName))) {
                        this.fileDelete(targetFile);
                    }
                    if (!this.stopRunLevels.contains(Integer.toString(i)) || !this.fileExists(targetFile = new File(runLevelDir = new File("/etc/rc" + i + ".d"), "K" + this.stopPriority + scriptName))) continue;
                    this.fileDelete(targetFile);
                }
            }
        }
    }

    private void symlink(File initDScript, File targetFile) {
        try {
            int retCode = -1;
            try {
                retCode = this.runCommand(new String[]{"/bin/sh", "-c", "ln -sf " + this.getFullPath(initDScript) + " " + this.getFullPath(targetFile)});
            }
            catch (Exception ex) {
                System.out.println("[LinuxServiceManager] ERROR symlinking " + this.getFullPath(initDScript) + " -> " + this.getFullPath(targetFile));
                ex.printStackTrace();
            }
            if (retCode == 0) {
                System.out.println("[LinuxServiceManager] Symlinked " + this.getFullPath(initDScript) + " -> " + this.getFullPath(targetFile));
            } else {
                System.out.println("[LinuxServiceManager] ERROR symlinking " + this.getFullPath(initDScript) + " -> " + this.getFullPath(targetFile));
            }
        }
        catch (IOException ex) {
            System.out.println("[LinuxServiceManager] ERROR determining paths for symlinking " + initDScript + " -> " + targetFile);
            ex.printStackTrace();
        }
    }

    protected void writeFile(File targetFile, byte[] dat) throws IOException {
        FileOutputStream fout = new FileOutputStream(targetFile);
        fout.write(dat);
        fout.close();
    }

    protected boolean fileExists(File f) {
        return f.exists();
    }

    protected boolean fileIsDir(File f) {
        return f.isDirectory();
    }

    protected boolean fileDelete(File f) {
        return f.delete();
    }

    protected String getFullPath(File f) throws IOException {
        return f.getCanonicalPath();
    }

    protected int runCommand(String[] command) throws IOException, InterruptedException {
        System.out.println("[LinuxServiceManager] Executing '" + Arrays.toString(command) + "'");
        Process p = Runtime.getRuntime().exec(command);
        ProcessPrinter processPrinter = new ProcessPrinter(p, System.out, System.err, false);
        int ret = p.waitFor();
        System.out.println("[LinuxServiceManager] Completed with return code: " + ret);
        processPrinter.closeAll();
        return ret;
    }

    private int runCommandSafe(String[] command) {
        try {
            return this.runCommand(command);
        }
        catch (IOException x) {
            x.printStackTrace();
            return -1;
        }
        catch (InterruptedException x) {
            x.printStackTrace();
            return -1;
        }
    }

    private boolean setSystemDScriptStatus(String shortName, boolean enabled) throws Exception {
        try {
            if (this.runCommand(new String[]{"/bin/sh", "-c", "systemctl daemon-reload"}) != 0) {
                return false;
            }
            String action = "enable";
            if (!enabled) {
                action = "disable";
            }
            if (this.runCommand(new String[]{"/bin/sh", "-c", "systemctl " + action + " " + shortName}) != 0) {
                return false;
            }
            action = "start";
            if (!enabled) {
                action = "stop";
            }
            int retCode = this.runCommand(new String[]{"/bin/sh", "-c", "systemctl " + action + " " + shortName});
            System.out.println("[LinuxServiceManager] SystemD script status (" + retCode + ")");
            return retCode == 0;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    private boolean setUpstartScriptStatus(String shortName, boolean enabled) throws IOException, InterruptedException {
        try {
            int retCode;
            if (this.runCommand(new String[]{"/bin/sh", "-c", "initctl reload-configuration"}) != 0) {
                return false;
            }
            String action = "start";
            if (!enabled) {
                action = "stop";
            }
            if ((retCode = this.runCommand(new String[]{"/bin/sh", "-c", "initctl " + action + " " + shortName})) == 1 && action.equals("start")) {
                System.out.println("[LinuxServiceManager] upstart start action failed (" + retCode + ").");
                retCode = this.runCommand(new String[]{"/bin/sh", "-c", "initctl restart " + shortName});
            }
            System.out.println("[LinuxServiceManager] Updated upstart script status (" + retCode + ")");
            return retCode == 0;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    private File installSystemDScript(String shortName, String desc, String exec, String workingDir, boolean respawn) throws Exception {
        shortName = shortName.toLowerCase();
        shortName = shortName.replaceAll("\\s", "");
        String contents = this.createSystemDScript(shortName, desc, exec, workingDir, respawn);
        File targetFile = this.getSystemDScriptFile(shortName);
        this.writeFile(targetFile, contents.getBytes(StandardCharsets.ISO_8859_1));
        return targetFile;
    }

    private File installUpstartScript(String shortName, String desc, String exec, String workingDir, boolean respawn) throws IOException {
        shortName = shortName.toLowerCase();
        shortName = shortName.replaceAll("\\s", "");
        String contents = this.createUpstartScript(shortName, desc, exec, workingDir, respawn);
        File targetFile = this.getUpstartScriptFile(shortName);
        this.writeFile(targetFile, contents.getBytes(StandardCharsets.ISO_8859_1));
        return targetFile;
    }

    private File getSystemDScriptFile(String shortName) {
        File systemDDirectory = this.getSystemDDirectory();
        return new File(systemDDirectory, shortName + ".service");
    }

    private File getUpstartScriptFile(String shortName) {
        File upstartDirectory = this.getUpstartInitDirectory();
        return new File(upstartDirectory, shortName + ".conf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOwnershipAndPermissions(File target, boolean executable) throws InterruptedException, IOException {
        int retCode;
        try {
            retCode = 0;
            retCode = executable ? this.runCommand(new String[]{"chmod", "-R", "755", this.getFullPath(target)}) : this.runCommand(new String[]{"chmod", "-R", "644", this.getFullPath(target)});
            System.out.println("[LinuxServiceManager] Completed chmod (" + retCode + ")");
        }
        catch (Throwable throwable) {
            int retCode2 = this.runCommand(new String[]{"chown", "root:root", this.getFullPath(target)});
            System.out.println("[LinuxServiceManager] Completed chown (" + retCode2 + ")");
            throw throwable;
        }
        retCode = this.runCommand(new String[]{"chown", "root:root", this.getFullPath(target)});
        System.out.println("[LinuxServiceManager] Completed chown (" + retCode + ")");
    }

    private File installInitDScript(String shortName, String desc, String startExec, String stopExec, String workingDir) throws IOException {
        String contents = this.createInitDScript(shortName, desc, startExec, stopExec, workingDir);
        File targetFile = this.getInitDScript(shortName);
        this.writeFile(targetFile, contents.getBytes(StandardCharsets.ISO_8859_1));
        return targetFile;
    }

    private File getInitDScript(String shortName) throws IOException {
        File initDDirectory = this.getInitDDirectory();
        return new File(initDDirectory, shortName);
    }

    private String createInitDScript(String shortName, String desc, String startExec, String stopExec, String workingDir) {
        workingDir = this.quoteIfRequired(workingDir);
        StringBuilder buffer = new StringBuilder();
        buffer.append("#!/bin/bash\n");
        buffer.append("# ").append(shortName).append(" Daemon\n");
        buffer.append("# chkconfig: ").append(this.startRunLevels_condensed).append(" ").append(this.startPriority).append(" ").append(this.stopPriority).append("\n");
        buffer.append("# description: ").append(desc).append("\n\n");
        buffer.append("### BEGIN INIT INFO\n");
        buffer.append("# Provides: ").append(shortName).append("\n");
        buffer.append("# Required-Start: $local_fs $network $all\n");
        buffer.append("# Required-Stop: $local_fs $network\n");
        buffer.append("# Default-Start: ").append(this.startRunLevels).append("\n");
        buffer.append("# Default-Stop: ").append(this.stopRunLevels).append("\n");
        buffer.append("# Short-Description: ").append(shortName).append(" service script\n");
        buffer.append("# Description: ").append(desc).append("\n");
        buffer.append("### END INIT INFO\n");
        buffer.append("case \"$1\" in\n");
        buffer.append("start)\n");
        buffer.append("\tprintf \"%-50s\" \"Starting ").append(shortName).append("\"\n");
        buffer.append("\tcd ").append(workingDir).append("\n");
        buffer.append("\t").append(startExec).append(" &\n");
        buffer.append("\tprintf \"%s\\n\" \"Ok\"\n");
        buffer.append(";;\n");
        buffer.append("stop)\n");
        if (stopExec != null) {
            buffer.append("\tprintf \"%-50s\" \"Stopping ").append(shortName).append("\"\n");
            buffer.append("\tcd ").append(workingDir).append("\n");
            buffer.append("\t").append(stopExec).append("\n");
            buffer.append("\tprintf \"%s\\n\" \"Ok\"\n");
        }
        buffer.append(";;\n");
        buffer.append("restart)\n");
        buffer.append("\t$0 stop\n");
        buffer.append("\t$0 start\n");
        buffer.append(";;\n");
        buffer.append("*)\n");
        buffer.append("\techo \"Usage: $0 {status|start|stop}\"\n");
        buffer.append("\texit 1\n");
        buffer.append(";;\n");
        buffer.append("esac\n");
        return buffer.toString();
    }

    private String quoteIfRequired(String workingDir) {
        if (workingDir.startsWith("\"")) {
            return workingDir;
        }
        return "\"" + workingDir + "\"";
    }

    private String createSystemDScript(String shortName, String desc, String exec, String workingDir, boolean respawn) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[Unit]\n");
        buffer.append("Description=").append(desc).append("\n");
        buffer.append("After=network.target\n\n");
        if (workingDir.startsWith("\"") && workingDir.endsWith("\"") || workingDir.startsWith("'") && workingDir.endsWith("'")) {
            workingDir = workingDir.substring(1, workingDir.length() - 1);
        }
        if (exec.startsWith("\"")) {
            if (exec.contains(".sh")) {
                exec = "/bin/sh " + exec;
            } else if (new File("/usr/bin/env").exists()) {
                exec = "/usr/bin/env " + exec;
            }
        }
        buffer.append("[Service]\n");
        buffer.append("WorkingDirectory=").append(workingDir).append("\n");
        buffer.append("ExecStart=").append(exec).append("\n\n");
        buffer.append("[Install]\n");
        buffer.append("WantedBy=graphical.target\n");
        return buffer.toString();
    }

    private static String stripQuotes(String exec) {
        int next;
        if (exec.startsWith("\"") && (next = (exec = exec.substring(1)).indexOf(34)) != -1) {
            String first = exec.substring(0, next).replace(" ", "\\ ");
            String second = "";
            if (next + 1 < exec.length()) {
                second = exec.substring(next + 1);
            }
            exec = first + second;
        }
        return exec;
    }

    private String createUpstartScript(String shortName, String desc, String exec, String workingDir, boolean respawn) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("# Upstart script for ").append(shortName).append("\n");
        buffer.append("description \"").append(desc).append("\"\n\n");
        buffer.append("# Specify the target run levels\n");
        buffer.append("start on runlevel [").append(this.startRunLevels_condensed).append("]\n");
        buffer.append("stop on runlevel [").append(this.stopRunLevels_condensed).append("]\n\n");
        if (respawn) {
            buffer.append("# Automatically restart process\n");
            buffer.append("respawn\n\n");
        }
        buffer.append("chdir ").append(workingDir).append("\n");
        buffer.append("exec ").append(exec).append("\n");
        return buffer.toString();
    }
}

