/*
 * Decompiled with CFR 0.152.
 */
package bcutil;

import bcutil.BCUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import utils.progtools.ObjectPool;
import utils.progtools.OnDemandPipeline;
import utils.progtools.PipelineJob;
import utils.stream.OpenByteArrayOutputStream;

public class BCUtilPool
extends ObjectPool {
    BCUtil orig;

    public BCUtilPool(BCUtil orig, int max) {
        super(max);
        this.orig = orig;
    }

    public BCUtil getBCU() {
        return (BCUtil)this.get();
    }

    @Override
    protected Object allocate() {
        return this.orig.clone();
    }

    @Override
    protected void clean(Object o) {
    }

    public static void main(String[] args) {
        OnDemandPipeline pipeline = new OnDemandPipeline();
        BCUtil.removeCpuBounding();
        BCUtil orig = new BCUtil();
        orig.initFromSecret("x", "x", 1);
        final BCUtilPool bcus = new BCUtilPool(orig, pipeline.getConcurrency() * 4);
        final byte[] dat = new byte[100000];
        new Random().nextBytes(dat);
        int MAX = 2000;
        final long T = System.currentTimeMillis();
        int i = 1;
        while (i <= 2000) {
            final int myIndex = i++;
            final BCUtil mybcu = bcus.getBCU();
            pipeline.add(new PipelineJob(){

                public String toString() {
                    return "Job " + myIndex;
                }

                public void parallelTask() {
                    try {
                        OpenByteArrayOutputStream plain = new OpenByteArrayOutputStream(dat.length);
                        OpenByteArrayOutputStream interim = new OpenByteArrayOutputStream(dat.length);
                        OpenByteArrayOutputStream bout = new OpenByteArrayOutputStream(dat.length);
                        byte[] buffer = new byte[100000];
                        mybcu.wrap(dat, dat.length, new DataOutputStream(bout));
                        byte[] encrypted = bout.getByteArray();
                        mybcu.unwrapHighPerformance(new DataInputStream(new ByteArrayInputStream(encrypted)), interim, buffer, plain);
                        bcus.done(mybcu);
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                    }
                }

                public void finalOrderedTask() {
                    if (myIndex == 2000) {
                        System.out.println("task " + myIndex + " done after " + (System.currentTimeMillis() - T) + "ms");
                    }
                }
            });
        }
    }
}

