/*
 * Decompiled with CFR 0.152.
 */
package utils.vnc.encoders;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import utils.progtools.streams.BitInputStream;
import utils.stream.StreamUtils;
import utils.vnc.PixelFormat;
import utils.vnc.VNC;
import utils.vnc.encoders.datatarget.ImageDataInterface;
import utils.vnc.utils.PixelInputStream;

public class ZRLEDecoder {
    private Inflater inflater = new Inflater();
    private byte[] buffer;
    static long time = 0L;

    private static long time() {
        long newTime = System.currentTimeMillis();
        long diff = newTime - time;
        time = newTime;
        return diff;
    }

    public void doDecoding(PixelInputStream in, int xpos, int ypos, int subWidth, int subHeight, ImageDataInterface image, PixelFormat format) throws IOException {
        long start = System.currentTimeMillis();
        ZRLEDecoder.time();
        if (VNC.VNC_DEBUG_ENCODINGS) {
            System.out.println("[ZRLE] Start Decoding");
        }
        int[] pixels = image.getPixels();
        int noTilesW = subWidth / 64;
        if (subWidth % 64 != 0) {
            ++noTilesW;
        }
        int noTilesH = subHeight / 64;
        if (subHeight % 64 != 0) {
            ++noTilesH;
        }
        int length = in.readInt();
        if (this.buffer == null || this.buffer.length < subWidth * subHeight * 4) {
            this.buffer = new byte[subWidth * subHeight * 4];
        }
        if (VNC.VNC_DEBUG_ENCODINGS) {
            System.out.println("[ZRLE] Length of compressed data is " + length);
        }
        byte[] compressedData = StreamUtils.readBytes(in, length);
        this.inflater.setInput(compressedData);
        try {
            if (VNC.VNC_DEBUG_ENCODINGS) {
                System.out.println("Uncompressed " + this.inflater.inflate(this.buffer) + " [buffersize=" + this.buffer.length + "]");
            } else {
                this.inflater.inflate(this.buffer);
            }
        }
        catch (DataFormatException e) {
            e.printStackTrace();
            IOException res = new IOException();
            res.initCause(e);
            throw res;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(this.buffer);
        PixelInputStream zlibIn = new PixelInputStream(format, bin);
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (VNC.VNC_DEBUG_ENCODINGS) {
            System.out.println("[ZRLE] Tiles (" + noTilesW + "," + noTilesH + ")");
        }
        for (int j = 0; j < noTilesH; ++j) {
            int absY = ypos + j * 64;
            for (int i = 0; i < noTilesW; ++i) {
                int target;
                int ii;
                int paletteSize;
                int absX = xpos + i * 64;
                int tileWidth = 64;
                if ((i + 1) * 64 > subWidth) {
                    tileWidth = subWidth % 64;
                }
                int tileHeight = 64;
                if ((j + 1) * 64 > subHeight) {
                    tileHeight = subHeight % 64;
                }
                int encodingForTile = zlibIn.read();
                if (VNC.VNC_DEBUG_ENCODINGS) {
                    System.out.println("[ZRLE]\tTile " + i + "," + j + "(" + tileWidth + "x" + tileHeight + ") encoding: " + encodingForTile);
                }
                if (encodingForTile == 0) {
                    for (int y = 0; y < tileHeight; ++y) {
                        for (int x = 0; x < tileWidth; ++x) {
                            int rgb = zlibIn.readCPixel();
                            if (absX + x >= imageWidth || absY + y >= imageHeight) continue;
                            int target2 = (y + absY) * imageWidth + absX + x;
                            pixels[target2] = rgb;
                        }
                    }
                    continue;
                }
                if (encodingForTile == 1) {
                    int rgb = zlibIn.readCPixel();
                    for (int y = 0; y < tileHeight; ++y) {
                        for (int x = 0; x < tileWidth; ++x) {
                            if (absX + x >= imageWidth || absY + y >= imageHeight) continue;
                            int target3 = (y + absY) * imageWidth + absX + x;
                            pixels[target3] = rgb;
                        }
                    }
                    continue;
                }
                if (encodingForTile <= 16) {
                    paletteSize = encodingForTile;
                    int[] palette = new int[paletteSize];
                    for (ii = 0; ii < palette.length; ++ii) {
                        palette[ii] = zlibIn.readCPixel();
                    }
                    int bitFieldSize = ZRLEDecoder.getBitFieldSize(encodingForTile);
                    BitInputStream bis = new BitInputStream(zlibIn);
                    int paletteIndex = 0;
                    for (int y = 0; y < tileHeight; ++y) {
                        for (int x = 0; x < tileWidth; ++x) {
                            paletteIndex = bis.readBits(bitFieldSize);
                            int target4 = (y + absY) * imageWidth + absX + x;
                            pixels[target4] = palette[paletteIndex];
                        }
                        bis.clearBuffer();
                    }
                    continue;
                }
                if (encodingForTile <= 127) {
                    new Exception(encodingForTile + "").printStackTrace();
                    continue;
                }
                if (encodingForTile == 128) {
                    int runLength = 0;
                    int runColor = 0;
                    for (int y = 0; y < tileHeight; ++y) {
                        for (int x = 0; x < tileWidth; ++x) {
                            if (runLength > 0) {
                                --runLength;
                                int target5 = (y + absY) * imageWidth + absX + x;
                                pixels[target5] = runColor;
                                continue;
                            }
                            runColor = zlibIn.readCPixel();
                            int nextByte = zlibIn.read();
                            int count255 = 0;
                            while (nextByte == 255) {
                                ++count255;
                                nextByte = zlibIn.read();
                            }
                            runLength = 255 * count255 + nextByte + 1;
                            --runLength;
                            target = (y + absY) * imageWidth + absX + x;
                            pixels[target] = runColor;
                        }
                    }
                    continue;
                }
                if (encodingForTile <= 255) {
                    paletteSize = encodingForTile - 128;
                    int[] palette = new int[paletteSize];
                    for (ii = 0; ii < palette.length; ++ii) {
                        palette[ii] = zlibIn.readCPixel();
                    }
                    int runLength = 0;
                    int runPaletteIndex = 0;
                    for (int y = 0; y < tileHeight; ++y) {
                        for (int x = 0; x < tileWidth; ++x) {
                            if (runLength > 0) {
                                --runLength;
                                target = (y + absY) * imageWidth + absX + x;
                                pixels[target] = palette[runPaletteIndex];
                                continue;
                            }
                            runPaletteIndex = zlibIn.read();
                            if (runPaletteIndex <= 127) {
                                runLength = 1;
                            } else {
                                runPaletteIndex -= 128;
                                int nextByte = zlibIn.read();
                                int count255 = 0;
                                while (nextByte == 255) {
                                    ++count255;
                                    nextByte = zlibIn.read();
                                }
                                runLength = 255 * count255 + nextByte + 1;
                            }
                            --runLength;
                            target = (y + absY) * imageWidth + absX + x;
                            pixels[target] = palette[runPaletteIndex];
                        }
                    }
                    continue;
                }
                new Exception("[ZRLE] Unknown encoding " + encodingForTile).printStackTrace();
            }
        }
        if (VNC.VNC_DEBUG_ENCODINGS) {
            long end = System.currentTimeMillis();
            System.out.println("[ZRLE] Total decompess took ZRLE " + (end - start) + " ms");
        }
    }

    private static int getBitFieldSize(int encodingForTile) {
        switch (encodingForTile) {
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        return 4;
    }
}

