/*
 * Decompiled with CFR 0.152.
 */
package utils.vnc.encoders;

import java.io.IOException;
import java.util.Arrays;
import utils.vnc.PixelFormat;
import utils.vnc.VNC;
import utils.vnc.encoders.datatarget.ImageDataInterface;
import utils.vnc.utils.PixelInputStream;

public class RREDecoder {
    public static void doDecoding(PixelInputStream in, int xpos, int ypos, int width, int height, ImageDataInterface image, PixelFormat format) throws IOException {
        if (VNC.VNC_DEBUG_ENCODINGS) {
            System.out.println("[RRE] Start Decoding");
        }
        int[] pixels = image.getPixels();
        int numberOfSubRectangles = in.readInt();
        if (VNC.VNC_DEBUG_ENCODINGS) {
            System.out.println("[RRE] " + numberOfSubRectangles + " Rectangles");
        }
        int backgroundColor = in.readPixel();
        int imageWidth = image.getWidth();
        for (int y = 0; y < height; ++y) {
            int startLine = (y + ypos) * imageWidth + xpos;
            Arrays.fill(pixels, startLine, startLine + width, backgroundColor);
        }
        for (int i = 0; i < numberOfSubRectangles; ++i) {
            int subRectColor = in.readPixel();
            int x = in.readUnsignedShort();
            int y = in.readUnsignedShort();
            int w = in.readUnsignedShort();
            int h = in.readUnsignedShort();
            if (VNC.VNC_DEBUG_ENCODINGS) {
                System.out.println("[RRE] Sub Rectangle (" + x + "," + y + ")->(" + w + "," + h + ")");
            }
            for (int yindex = 0; yindex < h; ++yindex) {
                int startLine = (y + ypos + yindex) * imageWidth + xpos + x;
                Arrays.fill(pixels, startLine, startLine + w, subRectColor);
            }
        }
    }
}

