/*
 * Decompiled with CFR 0.152.
 */
package utils.vnc.authentication;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.SecretKeySpec;
import utils.stream.StreamUtils;
import utils.vnc.exceptions.FailedSecurityException;

public class ARDAuthentication {
    public static void authenticate(InputStream in, OutputStream out, String username, String password) throws FailedSecurityException {
        try {
            byte[] baseGenerator = StreamUtils.readBytes(in, 2);
            short keyLength = StreamUtils.readShort(in);
            byte[] prime = StreamUtils.readBytes(in, keyLength);
            byte[] otherPersonsKey = StreamUtils.readBytes(in, keyLength);
            DHResult dh = ARDAuthentication.performDHKeyAgreement(new BigInteger(1, prime), new BigInteger(1, baseGenerator), new BigInteger(1, otherPersonsKey), keyLength);
            byte[] secret = ARDAuthentication.performMD5(dh.secretKey);
            byte[] credentials = new byte[128];
            SecureRandom random = new SecureRandom();
            ((Random)random).nextBytes(credentials);
            byte[] userBytes = username.getBytes("UTF-8");
            byte[] passBytes = password.getBytes("UTF-8");
            int userLength = userBytes.length < 63 ? userBytes.length : 63;
            int passLength = passBytes.length < 63 ? passBytes.length : 63;
            System.arraycopy(userBytes, 0, credentials, 0, userLength);
            System.arraycopy(passBytes, 0, credentials, 64, passLength);
            credentials[userLength] = 0;
            credentials[64 + passLength] = 0;
            byte[] ciphertext = ARDAuthentication.performAES128(secret, credentials);
            out.write(ciphertext);
            out.write(dh.publicKey);
        }
        catch (Exception ex) {
            throw new FailedSecurityException(ex);
        }
    }

    private static DHResult performDHKeyAgreement(BigInteger prime, BigInteger generator, BigInteger peerKey, int keyLength) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
        KeyAgreement keyAgreement = KeyAgreement.getInstance("DH");
        KeyFactory keyFactory = KeyFactory.getInstance("DH");
        DHPublicKeySpec peerKeySpec = new DHPublicKeySpec(peerKey, prime, generator);
        DHPublicKey peerPublicKey = (DHPublicKey)keyFactory.generatePublic(peerKeySpec);
        keyPairGenerator.initialize(new DHParameterSpec(prime, generator));
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        keyAgreement.init(keyPair.getPrivate());
        keyAgreement.doPhase(peerPublicKey, true);
        DHResult result = new DHResult();
        DHResult.access$102(result, ARDAuthentication.keyToBytes(keyPair.getPublic(), keyLength));
        DHResult.access$302(result, ARDAuthentication.keyToBytes(keyPair.getPrivate(), keyLength));
        DHResult.access$002(result, keyAgreement.generateSecret());
        return result;
    }

    private static byte[] performMD5(byte[] input) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.update(input);
        return digest.digest();
    }

    private static byte[] performAES128(byte[] key, byte[] plaintext) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(1, secretKeySpec);
        return cipher.doFinal(plaintext);
    }

    private static byte[] convertBigIntegerToByteArray(BigInteger bigInteger, int length) {
        byte[] bytes = bigInteger.toByteArray();
        if (bytes.length > length) {
            byte[] array = new byte[length];
            System.arraycopy(bytes, bytes.length - length, array, 0, length);
            return array;
        }
        if (bytes.length < length) {
            byte[] array = new byte[length];
            System.arraycopy(bytes, 0, array, length - bytes.length, bytes.length);
            return array;
        }
        return bytes;
    }

    private static byte[] keyToBytes(Key key, int length) throws IOException {
        if (key == null) {
            return null;
        }
        if (key instanceof DHPublicKey) {
            return ARDAuthentication.convertBigIntegerToByteArray(((DHPublicKey)key).getY(), length);
        }
        if (key instanceof DHPrivateKey) {
            return ARDAuthentication.convertBigIntegerToByteArray(((DHPrivateKey)key).getX(), length);
        }
        return null;
    }

    private static class DHResult {
        private byte[] publicKey;
        private byte[] privateKey;
        private byte[] secretKey;

        private DHResult() {
        }

        static /* synthetic */ byte[] access$102(DHResult x0, byte[] x1) {
            x0.publicKey = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$302(DHResult x0, byte[] x1) {
            x0.privateKey = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$002(DHResult x0, byte[] x1) {
            x0.secretKey = x1;
            return x1;
        }
    }
}

