/*
 * Decompiled with CFR 0.152.
 */
package utils.vm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import utils.files.FileUtil;
import utils.ostools.OS;
import utils.progtools.ProcessPrinter;

public class VMFork {
    private static final boolean USE_PATH_CONDENSING = false;
    private static String defaultJavaExe = null;
    boolean useWindowedJava = true;
    String cname;
    String[] args;
    String[] vmargs;
    int megs = 0;
    int stack = 0;
    String[] jars;
    String[] basejars;
    String[] libdirs;
    File dir;
    boolean mergeAllAfterPreExec = false;
    boolean escapeSpaces = false;
    private String java_exe = null;
    private boolean condenseClasspath = false;
    private String processName;

    public static void main(String[] args) {
        System.out.println("Classpath separator = '" + VMFork.getClassPathSeparator() + "'");
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("memory")) {
                int n = 1024;
                try {
                    while (true) {
                        byte[] b = new byte[n];
                        n *= 2;
                    }
                }
                catch (OutOfMemoryError b) {
                    Runtime r = Runtime.getRuntime();
                    System.out.println("<" + n / 1024 + "k");
                }
            }
            return;
        }
        try {
            VMFork fork = new VMFork("-version", null, new File("."));
            Process p = fork.fork();
            ProcessPrinter printer = new ProcessPrinter(p, System.out, System.err);
            p.waitFor();
            fork = new VMFork(VMFork.class.getName(), new String[]{"memory"}, new File("."));
            p = fork.fork();
            fork.setMergeAllCommandsAfterPreExec(true);
            System.out.println(fork);
            printer = new ProcessPrinter(p, System.out, System.err);
            p.waitFor();
            fork = new VMFork(VMFork.class.getName(), new String[]{"memory"}, new File("."));
            fork.setVMSpecificArgs(new String[]{"-Xmx512m"});
            p = fork.fork();
            printer = new ProcessPrinter(p, System.out, System.err);
            p.waitFor();
            fork = new VMFork(VMFork.class.getName(), new String[]{"memory"}, new File("."));
            fork.setJvmMemory(99);
            p = fork.fork();
            printer = new ProcessPrinter(p, System.out, System.err);
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getJavaExe(String javaHome) {
        return VMFork.getJavaExe(javaHome, true);
    }

    public static String getJavaExe(String javaHome, boolean windowsUseW) {
        char c = File.separatorChar;
        StringBuffer java = new StringBuffer(javaHome);
        java.append(c);
        java.append("bin");
        java.append(c);
        java.append("java");
        if (OS.isWindows()) {
            if (windowsUseW) {
                java.append("w.exe");
            } else {
                java.append(".exe");
            }
        }
        return java.toString();
    }

    public static String getJavaExe(boolean useWindowedVersion) {
        String jhome = System.getProperty("java.home");
        return VMFork.getJavaExe(jhome, useWindowedVersion);
    }

    public static String getJavaExe() {
        String jhome = System.getProperty("java.home");
        return VMFork.getJavaExe(jhome);
    }

    public static String getClassPathSeparator() {
        String sep = System.getProperty("path.separator");
        return sep;
    }

    public static String ZZZgetClassPath(String[] extra_jars) throws IOException {
        return VMFork.getClassPath(null, extra_jars, null, false);
    }

    private static String getLibPath(String[] libdirs) {
        StringBuffer sb = new StringBuffer();
        String sep = VMFork.getClassPathSeparator();
        if (libdirs != null) {
            for (int i = 0; i < libdirs.length; ++i) {
                sb.append(libdirs[i]);
                if (i >= libdirs.length - 1) continue;
                sb.append(sep);
            }
        }
        return sb.toString();
    }

    private static String getCondensedPath(File wdir, String jar, boolean condenseClasspath) throws IOException {
        return jar;
    }

    private static String getClassPath(String[] base_jars, String[] extra_jars, File wdir, boolean condenseClasspath) throws IOException {
        String jar_path;
        int i;
        String classpath = System.getProperty("java.class.path");
        String sep = VMFork.getClassPathSeparator();
        HashMap<String, String> added = new HashMap<String, String>();
        if (base_jars != null) {
            classpath = "";
            for (i = 0; i < base_jars.length; ++i) {
                jar_path = wdir != null ? VMFork.getCondensedPath(wdir, base_jars[i], condenseClasspath) : base_jars[i];
                if (added.containsKey(jar_path)) continue;
                added.put(jar_path, jar_path);
                classpath = classpath + jar_path + sep;
            }
        }
        if (extra_jars != null) {
            for (i = 0; i < extra_jars.length; ++i) {
                jar_path = wdir != null ? VMFork.getCondensedPath(wdir, base_jars[i], condenseClasspath) : base_jars[i];
                if (added.containsKey(jar_path)) continue;
                added.put(jar_path, jar_path);
                if (!classpath.endsWith(sep)) {
                    classpath = classpath + sep;
                }
                classpath = classpath + jar_path;
            }
        }
        while (classpath != null && classpath.endsWith(sep)) {
            classpath = classpath.substring(0, classpath.length() - 1);
        }
        if (OS.isMacOS()) {
            classpath = classpath + sep + classpath;
        }
        return classpath;
    }

    public static void overrideDefaultJavaExe(String javaExe) {
        defaultJavaExe = javaExe;
    }

    public void setCondenseClasspath(boolean b) {
        this.condenseClasspath = b;
    }

    public void setUseJavaWOnWindows(boolean b) {
        this.useWindowedJava = b;
    }

    public VMFork(String cname) {
        this.cname = cname;
    }

    public VMFork(String cname, String[] args) {
        this.cname = cname;
        this.args = args;
    }

    public VMFork(String cname, String[] args, File working_dir) {
        this.cname = cname;
        this.args = args;
        this.dir = working_dir;
    }

    public void setClassName(String cname) {
        this.cname = cname;
    }

    public void setClassArgs(String[] args) {
        this.args = args;
    }

    public void setVMSpecificArgs(String[] args) {
        this.vmargs = args;
    }

    public void setJvmMemory(int megs) {
        this.megs = megs;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void setClasspathExtras(String[] jars) {
        this.jars = jars;
    }

    public void setMergeAllCommandsAfterPreExec(boolean b) {
        this.mergeAllAfterPreExec = b;
    }

    public void setEscapeSpacesAfterPreExec(boolean b) {
        this.escapeSpaces = b;
    }

    public void setLibpathExtras(String[] libdirs) {
        this.libdirs = libdirs;
    }

    public void setWorkingDir(File dir) {
        this.dir = dir;
    }

    public void setBaseClasspath(String[] jars) {
        this.basejars = jars;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("WDIR:" + this.dir + "\n");
            ArrayList<String> list = new ArrayList<String>();
            this.fork(list, new String[0]);
            for (int i = 0; i < list.size(); ++i) {
                sb.append("CMD:" + list.get(i) + "\n");
            }
        }
        catch (Exception e) {
            sb.append("VMFork problem: " + e);
        }
        return sb.toString();
    }

    public Process fork() throws IOException {
        return this.fork(null, null);
    }

    public Process fork(String[] preJvmExec) throws IOException {
        return this.fork(null, preJvmExec);
    }

    public String[] forkAsCommandArray(String[] preJvmExec) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        this.fork(list, preJvmExec, true);
        return list.toArray(new String[0]);
    }

    public String forkAsCommandString(String[] preJvmExec) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        this.fork(list, preJvmExec);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            String cmd = list.get(i);
            if (!cmd.startsWith("\"")) {
                sb.append('\"');
                sb.append(cmd);
                sb.append('\"');
            } else {
                sb.append(cmd);
            }
            if (i >= list.size() - 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public String getClasspath() throws IOException {
        return VMFork.getClassPath(this.basejars, this.jars, this.dir, this.condenseClasspath);
    }

    public String getClasspathNoCondensing() throws IOException {
        return VMFork.getClassPath(this.basejars, this.jars, this.dir, false);
    }

    public String getClassname() {
        return this.cname;
    }

    public String[] getParams() {
        if (this.args == null) {
            return new String[0];
        }
        return this.args;
    }

    private Process fork(ArrayList<String> cmds, String[] preJvmExec) throws IOException {
        return this.fork(cmds, preJvmExec, false);
    }

    private Process fork(ArrayList<String> cmds, String[] preJvmExec, boolean quoteAsAppropriate) throws IOException {
        int i;
        if (this.java_exe == null) {
            this.java_exe = defaultJavaExe == null ? VMFork.getJavaExe(this.useWindowedJava) : defaultJavaExe;
        }
        try {
            File targetExeFile;
            File javaExeFile = new File(this.java_exe);
            if (javaExeFile.exists() && this.processName != null && !(targetExeFile = new File(javaExeFile.getParentFile(), this.processName)).exists()) {
                FileUtil.copy(javaExeFile, targetExeFile);
                this.java_exe = targetExeFile.getCanonicalPath();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String libpath = VMFork.getLibPath(this.libdirs);
        String classpath = VMFork.getClassPath(this.basejars, this.jars, this.dir, this.condenseClasspath);
        if (this.args == null) {
            this.args = new String[0];
        }
        if (this.vmargs == null) {
            this.vmargs = new String[0];
        }
        ArrayList<String> commands = new ArrayList<String>();
        if (quoteAsAppropriate) {
            commands.add("\"" + this.java_exe + "\"");
        } else {
            commands.add(this.java_exe);
        }
        if (libpath.length() > 0) {
            commands.add("-Djava.library.path=\"" + libpath + "\"");
        }
        if (classpath.length() > 0) {
            commands.add("-cp");
            if (quoteAsAppropriate) {
                commands.add("\"" + classpath + "\"");
            } else if (OS.isWindows()) {
                if (this.mergeAllAfterPreExec && !this.escapeSpaces) {
                    commands.add("\"" + classpath + "\"");
                } else {
                    commands.add(classpath);
                }
            } else {
                commands.add(classpath);
            }
        }
        if (this.megs != 0) {
            commands.add("-Xmx" + this.megs + "m");
        }
        for (i = 0; i < this.vmargs.length; ++i) {
            commands.add(this.vmargs[i]);
        }
        commands.add(this.cname);
        for (i = 0; i < this.args.length; ++i) {
            commands.add(this.args[i]);
        }
        if (this.escapeSpaces) {
            for (i = 0; i < commands.size(); ++i) {
                String cmd = (String)commands.get(i);
                cmd = cmd.replace(" ", "\\ ");
                commands.set(i, cmd);
            }
        }
        if (this.mergeAllAfterPreExec) {
            StringBuffer sb = new StringBuffer();
            for (int i2 = 0; i2 < commands.size(); ++i2) {
                if (i2 > 0) {
                    sb.append(' ');
                }
                String cmd = (String)commands.get(i2);
                sb.append(cmd);
            }
            commands.clear();
            commands.add(sb.toString());
        }
        String[] commands_array = new String[commands.size()];
        commands.toArray(commands_array);
        if (cmds == null) {
            if (preJvmExec != null) {
                String[] tmp = new String[commands_array.length + preJvmExec.length];
                System.arraycopy(preJvmExec, 0, tmp, 0, preJvmExec.length);
                System.arraycopy(commands_array, 0, tmp, preJvmExec.length, commands_array.length);
                StringBuffer buffer = new StringBuffer();
                for (int i3 = 0; i3 < tmp.length; ++i3) {
                    if (i3 > 0) {
                        buffer.append(" ");
                    }
                    buffer.append(tmp[i3]);
                    System.out.println(i3 + ") " + tmp[i3]);
                }
                System.out.println("|" + buffer + "|");
                Process p = Runtime.getRuntime().exec(tmp, null, this.dir);
                return p;
            }
            Process p = Runtime.getRuntime().exec(commands_array, null, this.dir);
            return p;
        }
        if (preJvmExec != null) {
            for (int i4 = 0; i4 < preJvmExec.length; ++i4) {
                cmds.add(preJvmExec[i4]);
            }
        }
        for (int i5 = 0; i5 < commands_array.length; ++i5) {
            cmds.add(commands_array[i5]);
        }
        return null;
    }

    public File getWorkingDir() {
        return this.dir;
    }

    public void setJavaExe(String javaExe) {
        this.java_exe = javaExe;
    }
}

