/*
 * Decompiled with CFR 0.152.
 */
package utils.udp.bidirectional;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import utils.udp.bidirectional.UDPListener;
import utils.udp.bidirectional.UDPResponder;
import utils.udp.bidirectional.UnrecognisedPacketHandler;
import utils.udp.util.UDPWrapUtil;

public class UDPReader
extends Thread {
    public static final int DEF_MAX_READ = 4096;
    Object LOCK;
    private DatagramSocket sock;
    int maxRead;
    UDPListener listener;
    UDPResponder respond;
    boolean die = false;
    UDPWrapUtil util = new UDPWrapUtil();
    UnrecognisedPacketHandler failHandler;

    public void setUnrecognisedPacketHandler(UnrecognisedPacketHandler failHandler) {
        this.failHandler = failHandler;
    }

    public UDPReader(Object LOCK, DatagramSocket sock, int maxRead, UDPListener listener, UDPResponder respond) {
        super("UDPReader");
        this.LOCK = LOCK;
        this.sock = sock;
        this.maxRead = maxRead;
        this.listener = listener;
        this.respond = respond;
        this.setPriority(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DatagramPacket pack = new DatagramPacket(new byte[4096], 4096);
        while (!this.die) {
            try {
                Object object = this.LOCK;
                synchronized (object) {
                    this.sock.receive(pack);
                }
                if (this.die) break;
                SocketAddress socketAddress = pack.getSocketAddress();
                this.listener.handleMessage(this.util.unwrap(pack), socketAddress, this.respond, this.respond.getHostFor(socketAddress));
            }
            catch (SocketException x) {
                if (this.sock.isClosed()) {
                    System.out.println("[UDPReader] UDPReader Terminating: " + x);
                    x.printStackTrace();
                    return;
                }
                System.out.println("[UDPReader] Received socket close notification but socket still open, continuing (" + pack + ")");
            }
            catch (IOException x) {
                if (this.failHandler != null) {
                    this.failHandler.unrecognisedUdpPacket(pack.getData(), pack.getLength(), pack.getSocketAddress(), this.respond);
                    continue;
                }
                System.out.println("[UDPReader] " + x);
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void die() {
        this.die = true;
    }
}

