/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.tree;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import utils.swing.tree.IconCheckNode;

public class CheckNodeSelectionListener
extends MouseAdapter {
    protected JTree tree;
    int lmargin = 0;
    int tmargin = 0;
    int buttonWidth = 10;

    public CheckNodeSelectionListener(JTree tree) {
        this.tree = tree;
    }

    public CheckNodeSelectionListener(JTree tree, int lmargin, int tmargin) {
        this.tree = tree;
        this.lmargin = lmargin;
        this.tmargin = tmargin;
    }

    public void setButtonWidth(int n) {
        this.buttonWidth = n;
    }

    protected JTree getTree() {
        return this.tree;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int row = this.tree.getRowForLocation(x -= this.lmargin, y -= this.tmargin);
        TreePath path = this.tree.getPathForLocation(x, y);
        if (path != null && path.getLastPathComponent() instanceof IconCheckNode) {
            IconCheckNode node = (IconCheckNode)path.getLastPathComponent();
            int indent = UIManager.getInt("Tree.leftChildIndent");
            indent += UIManager.getInt("Tree.rightChildIndent");
            int pathCount = path.getPathCount() - 1;
            if (!this.tree.isRootVisible()) {
                --pathCount;
            }
            int offset = 0;
            if (this.tree.getShowsRootHandles()) {
                offset = this.tree.getRowHeight();
            }
            if (x < offset + indent * pathCount || x > offset + indent * pathCount + this.buttonWidth) {
                return;
            }
            boolean isSelected = !node.isSelected();
            node.setSelected(isSelected);
            ((DefaultTreeModel)this.tree.getModel()).nodeChanged(node);
            if (row == 0) {
                this.tree.revalidate();
                this.tree.repaint();
            }
        }
    }
}

