/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.simplelist.wrapper;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.listener.ListEvent;
import utils.swing.simplelist.listener.ListListener;

public class SortWrapper<E>
extends SimpleList<E>
implements ListListener<E> {
    private SimpleList<E> unsortedList;
    private Comparator comparator;
    public static final Comparator LEXICAL_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    public static final Comparator LEXICAL_COMPARATOR_IGNORE_CASE = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().toLowerCase().compareTo(o2.toString().toLowerCase());
        }
    };

    public SortWrapper(SimpleList<E> list, Comparator<E> comparator) {
        this.unsortedList = list;
        this.comparator = comparator;
        list.addListListener(this);
    }

    public void setComparator(Comparator c) {
        this.comparator = c;
        this.doFullSort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doFullSort() {
        this.startBatch();
        try {
            Object[] source = this.unsortedList.toArray();
            Arrays.sort(source, this.comparator);
            boolean doSort = false;
            for (int i = 0; i < source.length; ++i) {
                Object orig = this.get(i);
                if (source[i].equals(orig)) continue;
                doSort = true;
                break;
            }
            if (doSort) {
                this.clear();
                for (Object o : source) {
                    this.add(o);
                }
            }
            boolean bl = doSort;
            return bl;
        }
        finally {
            this.endBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listAltered(ListEvent<E> event) {
        switch (event.getBlockType()) {
            case 0: {
                this.startBatch();
                try {
                    for (int i = 0; i < event.getAffectedElements().size(); ++i) {
                        E o = event.getAffectedElements().get(i);
                        int insertionIndex = Collections.binarySearch(this, o, this.comparator);
                        if (insertionIndex < 0) {
                            insertionIndex = -1 * insertionIndex - 1;
                        }
                        this.add(insertionIndex, o);
                    }
                }
                finally {
                    this.endBatch();
                }
                return;
            }
            case 1: {
                this.startBatch();
                try {
                    for (int i = 0; i < event.getAffectedElements().size(); ++i) {
                        E o = event.getAffectedElements().get(i);
                        int index = Collections.binarySearch(this, o, this.comparator);
                        if (index <= -1) continue;
                        this.remove(index);
                    }
                }
                finally {
                    this.endBatch();
                }
                return;
            }
            case 2: {
                if (!this.doFullSort()) {
                    this.startBatch();
                    try {
                        this.updateAll(event.getAffectedElements());
                    }
                    finally {
                        this.endBatch();
                    }
                }
                return;
            }
        }
    }

    @Override
    public void debugDump(String tab) {
        System.out.println(tab + "--- Sort Wrapper---");
        super.debugDump(tab);
        System.out.println(tab + "--- sorting ---");
        this.unsortedList.debugDump(tab + "\t");
    }
}

