/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.simplelist.listener;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import utils.swing.simplelist.SimpleLock;
import utils.swing.simplelist.listener.ListEvent;
import utils.swing.simplelist.listener.ListListener;

public class SimpleEventManager<E> {
    private static final boolean BATCH_UP_EVENTS = false;
    private SimpleLock lock = new SimpleLock();
    private ConcurrentLinkedQueue<ListEvent<E>> list = new ConcurrentLinkedQueue();
    private ArrayList<ListListener<E>> listeners = new ArrayList();
    private ListEvent<E> listEvent = null;

    public void start() {
        this.lock.getReadWriteLock();
    }

    public void end() {
        if (this.listEvent != null) {
            this.list.add(this.listEvent);
            this.listEvent = null;
        }
        while (this.list.size() > 0) {
            this.fireEvent((ListEvent)this.list.remove());
        }
        this.lock.releaseReadWriteLock();
    }

    private void addEvent(int start, int end, int type, E o) {
        if (this.listEvent != null && this.listEvent.getBlockType() == type) {
            if (type == 2) {
                if (this.listEvent.getBlockEnd() + 1 == start) {
                    this.listEvent.setBlockEnd(end);
                    this.listEvent.getAffectedElements().add(o);
                    return;
                }
                if (this.listEvent.getBlockStart() - 1 == end) {
                    this.listEvent.setBlockStart(start);
                    this.listEvent.getAffectedElements().add(0, o);
                    return;
                }
            } else {
                if (this.listEvent.getBlockEnd() == start) {
                    this.listEvent.setBlockEnd(end);
                    if (o != null) {
                        this.listEvent.getAffectedElements().add(o);
                    }
                    return;
                }
                if (this.listEvent.getBlockStart() == end) {
                    this.listEvent.setBlockStart(start);
                    this.listEvent.setBlockEnd(this.listEvent.getBlockEnd() + 1);
                    if (o != null) {
                        this.listEvent.getAffectedElements().add(0, o);
                    }
                    return;
                }
            }
        }
        if (this.listEvent != null) {
            this.fireEvent(this.listEvent);
        }
        ArrayList<E> newList = new ArrayList<E>();
        newList.add(o);
        this.listEvent = new ListEvent(start, end, type, newList);
    }

    public void createInsertEvent(int size, E e) {
        this.addEvent(size, size, 0, e);
    }

    public void createRemoveEvent(int i, E object) {
        this.addEvent(i, i, 1, object);
    }

    public void createUpdateEvent(int index, E element) {
        this.addEvent(index, index, 2, element);
    }

    public void addListListener(ListListener l) {
        this.listeners.add(l);
    }

    public void removeListListener(ListListener l) {
        this.listeners.remove(l);
    }

    public void fireEvent(ListEvent<E> event) {
        for (ListListener<E> listener : this.listeners) {
            listener.listAltered(event);
        }
    }
}

