/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.simplelist.jtree;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import utils.swing.simplelist.SimpleLock;

public class SimpleTreeModel<T extends Comparable<T>> {
    private TreeNode<T> root = new TreeNode<Object>(null, null);
    private final ArrayList<TreeModelListener> listeners = new ArrayList();
    private HashMap<T, TreeNode<T>> valueToTreeNode = new HashMap();
    protected SimpleLock lock = new SimpleLock();
    protected TreeModelImplementation treeModel = new TreeModelImplementation();
    private TreeModelEditorListener editorListener;
    public final Comparator<TreeNode<T>> treeNodeComparator = new Comparator<TreeNode<T>>(){

        @Override
        public int compare(TreeNode<T> o1, TreeNode<T> o2) {
            return o1.compareTo(o2.value);
        }
    };

    public void ensureCorrectOrdering(T parentValue, T childValue) {
        TreeNode<T> parent = this.getTreeNodeFor(parentValue);
        TreeNode child = null;
        if (parent.areChildrenOrderedByValue) {
            int insertIndex = -1;
            for (int i = 0; i < parent.children.size(); ++i) {
                TreeNode childNode = parent.children.get(i);
                if (childNode.value != childValue) {
                    if (insertIndex != -1 || childNode.value.compareTo(childValue) <= 0) continue;
                    insertIndex = i;
                    continue;
                }
                child = childNode;
            }
            if (insertIndex == -1) {
                insertIndex = parent.children.size();
            }
            if (child != null) {
                this.moveChild(parent, child, insertIndex);
            }
        }
    }

    public TreeModelImplementation getTreeModel() {
        return this.treeModel;
    }

    public void setModelEditorListener(TreeModelEditorListener editorListener) {
        this.editorListener = editorListener;
    }

    public int getChildCount(T value) {
        TreeNode<T> parent = this.getTreeNodeFor(value);
        return this.treeModel.getChildCount(parent);
    }

    public T getChild(T parent, int index) {
        TreeNode<T> parentNode = this.getTreeNodeFor(parent);
        TreeNode child = (TreeNode)this.treeModel.getChild(parentNode, index);
        if (child == null) {
            return null;
        }
        return child.value;
    }

    public TreeNode<T> reIndexMapRemove(T value) {
        return this.valueToTreeNode.remove(value);
    }

    public void reIndexMapAdd(T value, TreeNode<T> treeNodeValue) {
        this.valueToTreeNode.put(value, treeNodeValue);
    }

    private void startEdit(T preEditedValue) {
        this.valueToTreeNode.remove(preEditedValue);
    }

    private void endEdit(TreeNode<T> node) {
        this.valueToTreeNode.put(node.value, node);
        this.update(node.value);
    }

    public TreeNode<T> getTreeNodeFor(T value) {
        if (value == null) {
            return this.root;
        }
        return this.valueToTreeNode.get(value);
    }

    public T getChildWithValueThatEquals(T parentValue, T childValue) {
        TreeNode<T> parent = this.getTreeNodeFor(parentValue);
        if (parent == null) {
            return null;
        }
        TreeNode<T> child = parent.getChildWithValue(childValue);
        if (child == null) {
            return null;
        }
        return child.value;
    }

    public boolean addChild(T parentValue, T childValue) {
        return this.addChild(parentValue, childValue, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChild(T parentValue, T childValue, boolean allowDuplicate, boolean inOrder) {
        int insertIndex;
        TreeNode<T> child;
        TreeNode<T> parent;
        this.lock.getReadWriteLock();
        try {
            parent = this.getTreeNodeFor(parentValue);
            if (!allowDuplicate && parent.getChildWithValue(childValue) != null) {
                boolean bl = false;
                return bl;
            }
            child = new TreeNode<T>(childValue, parent);
            this.valueToTreeNode.put(childValue, child);
            if (!inOrder) {
                insertIndex = parent.children.size();
                parent.areChildrenOrderedByValue = false;
            } else {
                if (parent == null || parent.children == null) {
                    boolean bl = false;
                    return bl;
                }
                insertIndex = Collections.binarySearch(parent.children, child, this.treeNodeComparator);
                if (insertIndex < 0) {
                    insertIndex = -(insertIndex + 1);
                }
            }
            parent.children.add(insertIndex, child);
        }
        finally {
            this.lock.releaseReadWriteLock();
        }
        final TreeModelEvent event = new TreeModelEvent((Object)this, this.getPathFrom(parent), new int[]{insertIndex}, new Object[]{child});
        if (EventQueue.isDispatchThread()) {
            this.fireNotifyAddChild(event);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleTreeModel.this.fireNotifyAddChild(event);
                }
            });
        }
        return true;
    }

    private void debug_checkOrdering(TreeNode<T> parent) {
        if (parent.areChildrenOrderedByValue) {
            TreeNode last = null;
            for (TreeNode child : parent.children) {
                if (last != null && last.value.compareTo(child.value) > 0) {
                    System.out.println("OUT OF ORDER! 1");
                }
                last = child;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveChild(T parentValue, T childValue, int moveIndex) {
        this.lock.getReadWriteLock();
        try {
            TreeNode<T> parent = this.getTreeNodeFor(parentValue);
            TreeNode<T> child = parent.getChildWithValue(childValue);
            this.moveChild(parent, child, moveIndex);
        }
        finally {
            this.lock.releaseReadWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveChild(TreeNode<T> parent, TreeNode<T> child, int moveIndex) {
        int originalIndex;
        this.lock.getReadWriteLock();
        try {
            if (child == null) {
                return;
            }
            originalIndex = parent.children.indexOf(child);
            parent.children.remove(child);
            int targetIndex = moveIndex;
            if (moveIndex > originalIndex) {
                --targetIndex;
            }
            parent.children.add(targetIndex, child);
        }
        finally {
            this.lock.releaseReadWriteLock();
        }
        final TreeModelEvent removeEvent = new TreeModelEvent((Object)this, this.getPathFrom(parent), new int[]{originalIndex}, new Object[]{child});
        if (EventQueue.isDispatchThread()) {
            this.fireNotifyRemoveChild(removeEvent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleTreeModel.this.fireNotifyRemoveChild(removeEvent);
                }
            });
        }
        final TreeModelEvent addEvent = new TreeModelEvent((Object)this, this.getPathFrom(parent), new int[]{moveIndex}, new Object[]{child});
        if (EventQueue.isDispatchThread()) {
            this.fireNotifyAddChild(addEvent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleTreeModel.this.fireNotifyAddChild(addEvent);
                }
            });
        }
    }

    public boolean insertChildAfter(T parentValue, T childValue, T preSiblingValue) {
        InsertRunner runner = new InsertRunner(this, parentValue, childValue, preSiblingValue);
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
            return runner.result;
        }
        try {
            SwingUtilities.invokeAndWait(runner);
            return runner.result;
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite);
        }
    }

    private void fireNotifyAddChild(TreeModelEvent event) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesInserted(event);
        }
    }

    private void fireNotifyRemoveChild(TreeModelEvent event) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesRemoved(event);
        }
    }

    private void fireNotifyUpdateNode(TreeModelEvent event) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesChanged(event);
        }
    }

    private Object[] getPathFrom(TreeNode node) {
        ArrayList path = new ArrayList();
        path.add(node);
        while (node.parent != null) {
            path.add(node.parent);
            node = node.parent;
        }
        Object[] result = new Object[path.size()];
        for (int i = 0; i < path.size(); ++i) {
            result[result.length - i - 1] = path.get(i);
        }
        return result;
    }

    public void update(T nodeValue) {
        UpdateRunner runner = new UpdateRunner(this, nodeValue);
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite);
            }
        }
    }

    public boolean remove(T childValue) {
        RemoveRunner runner = new RemoveRunner(this, childValue);
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
            return runner.result;
        }
        try {
            SwingUtilities.invokeAndWait(runner);
            return runner.result;
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite);
        }
    }

    public boolean remove(T parentValue, int index) {
        RemoveRunner runner = new RemoveRunner(this, parentValue, index);
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
            return runner.result;
        }
        try {
            SwingUtilities.invokeAndWait(runner);
            return runner.result;
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite);
        }
    }

    public boolean contains(T value) {
        return this.getTreeNodeFor(value) != null;
    }

    class RemoveRunner
    implements Runnable {
        public boolean result;
        private T childValue;
        private T parentValue;
        private int childIndex;
        final /* synthetic */ SimpleTreeModel this$0;

        RemoveRunner(T childValue) {
            this.this$0 = this$0;
            this.result = false;
            this.childIndex = -1;
            this.childValue = childValue;
        }

        /*
         * WARNING - Possible parameter corruption
         */
        RemoveRunner(T parentValue, int childIndex) {
            this.this$0 = (SimpleTreeModel)this$0;
            this.result = false;
            this.childIndex = -1;
            this.parentValue = parentValue;
            this.childIndex = childIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.this$0.lock.getReadWriteLock();
            try {
                if (this.childIndex == -1) {
                    TreeNode child = this.this$0.getTreeNodeFor(this.childValue);
                    if (child == null) {
                        return;
                    }
                    if (child.parent == null) {
                        return;
                    }
                    TreeNodeLocation nodeToRemove = child.parent.getChildWithValueLocation(this.childValue);
                    if (nodeToRemove == null) {
                        System.out.println("Warning: unable to remove " + this.childValue + " from " + child.parent + " where nodeToRemove=null");
                        return;
                    }
                    child.parent.children.remove(nodeToRemove.node);
                    this.this$0.valueToTreeNode.remove(nodeToRemove.node.value);
                    TreeModelEvent event = new TreeModelEvent((Object)this, this.this$0.getPathFrom(child.parent), new int[]{nodeToRemove.index}, new Object[]{child});
                    this.this$0.fireNotifyRemoveChild(event);
                    this.result = true;
                } else {
                    TreeNode parent = this.this$0.getTreeNodeFor(this.parentValue);
                    if (parent == null) {
                        return;
                    }
                    TreeNode child = parent.children.remove(this.childIndex);
                    this.this$0.valueToTreeNode.remove(child.value);
                    TreeModelEvent event = new TreeModelEvent((Object)this, this.this$0.getPathFrom(child.parent), new int[]{this.childIndex}, new Object[]{child});
                    this.this$0.fireNotifyRemoveChild(event);
                    this.result = true;
                }
            }
            finally {
                this.this$0.lock.releaseReadWriteLock();
            }
        }
    }

    static class UpdateRunner
    implements Runnable {
        private T nodeValue;
        public boolean result = false;
        final /* synthetic */ SimpleTreeModel this$0;

        UpdateRunner(T value) {
            this.this$0 = this$0;
            this.nodeValue = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int updateIndex;
            TreeNode parent;
            TreeNode child;
            this.this$0.lock.getReadLock();
            try {
                child = this.this$0.getTreeNodeFor(this.nodeValue);
                if (child == null) {
                    return;
                }
                if (child.parent == null) {
                    return;
                }
                parent = child.parent;
                ArrayList children = parent.children;
                updateIndex = children.indexOf(child);
                if (updateIndex == -1) {
                    return;
                }
            }
            finally {
                this.this$0.lock.releaseReadLock();
            }
            this.result = true;
            TreeModelEvent event = new TreeModelEvent((Object)this, this.this$0.getPathFrom(parent), new int[]{updateIndex}, new Object[]{child});
            this.this$0.fireNotifyUpdateNode(event);
        }
    }

    static class InsertRunner
    implements Runnable {
        public boolean result;
        private T preSiblingValue;
        private T childValue;
        private T parentValue;
        final /* synthetic */ SimpleTreeModel this$0;

        InsertRunner(T parentValue, T childValue, T preSiblingValue) {
            this.this$0 = this$0;
            this.parentValue = parentValue;
            this.childValue = childValue;
            this.preSiblingValue = preSiblingValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int insertedIndex;
            TreeNode child;
            TreeNode parent;
            this.this$0.lock.getReadWriteLock();
            try {
                parent = this.this$0.getTreeNodeFor(this.parentValue);
                TreeNode preSibling = this.this$0.getTreeNodeFor(this.preSiblingValue);
                int index = parent.children.indexOf(preSibling);
                if (index == -1) {
                    return;
                }
                child = new TreeNode(this.childValue, parent);
                this.this$0.valueToTreeNode.put(this.childValue, child);
                insertedIndex = index + 1;
                if (parent.children.size() == index + 1) {
                    parent.children.add(child);
                } else {
                    parent.children.add(insertedIndex, child);
                }
            }
            finally {
                this.this$0.lock.releaseReadWriteLock();
            }
            TreeModelEvent event = new TreeModelEvent((Object)this, this.this$0.getPathFrom(parent), new int[]{insertedIndex}, new Object[]{child});
            this.this$0.fireNotifyAddChild(event);
            this.result = true;
        }
    }

    static class TreeNodeLocation<T extends Comparable<T>> {
        public TreeNode<T> node;
        public int index;

        TreeNodeLocation(TreeNode<T> node, int index) {
            this.node = node;
            this.index = index;
        }
    }

    public static class TreeNode<T extends Comparable<T>>
    implements Comparable<T> {
        public T value = null;
        public TreeNode<T> parent = null;
        public ArrayList<TreeNode<T>> children = new ArrayList<TreeNode<T>>(){};
        boolean areChildrenOrderedByValue = true;

        public TreeNode(T value, TreeNode<T> parent) {
            this.value = value;
            this.parent = parent;
        }

        private int search(T value) {
            int lo = 0;
            int hi = this.children.size() - 1;
            while (lo <= hi) {
                int mid = lo + (hi - lo) / 2;
                int cmp = value.compareTo(this.children.get((int)mid).value);
                if (cmp < 0) {
                    hi = mid - 1;
                    continue;
                }
                if (cmp > 0) {
                    lo = mid + 1;
                    continue;
                }
                return mid;
            }
            return -1;
        }

        public TreeNode<T> getChildWithValue(T value) {
            if (this.areChildrenOrderedByValue) {
                int index = this.search(value);
                if (index == -1) {
                    return null;
                }
                return this.children.get(index);
            }
            for (TreeNode<T> child : this.children) {
                if (!child.value.equals(value)) continue;
                return child;
            }
            return null;
        }

        TreeNodeLocation<T> getChildWithValueLocation(T value) {
            if (this.areChildrenOrderedByValue) {
                int index = this.search(value);
                if (index == -1) {
                    return null;
                }
                TreeNode<T> node = this.children.get(index);
                if (node != null) {
                    return new TreeNodeLocation<T>(node, index);
                }
                return null;
            }
            for (int i = 0; i < this.children.size(); ++i) {
                TreeNode<T> child = this.children.get(i);
                if (!child.value.equals(value)) continue;
                return new TreeNodeLocation<T>(child, i);
            }
            return null;
        }

        public Iterator<TreeNode<T>> getIterator() {
            return this.children.iterator();
        }

        public String toString() {
            if (this.value == null && this.parent == null) {
                return "(ROOT)";
            }
            return "" + this.value;
        }

        @Override
        public int compareTo(T o) {
            return this.value.compareTo(o);
        }
    }

    public class TreeModelImplementation
    implements TreeModel {
        @Override
        public Object getRoot() {
            return SimpleTreeModel.this.root;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getChild(Object parent, int index) {
            SimpleTreeModel.this.lock.getReadLock();
            try {
                ArrayList children;
                TreeNode treeNode = (TreeNode)parent;
                if (parent == null) {
                    treeNode = SimpleTreeModel.this.root;
                }
                if ((children = treeNode.children).size() > index) {
                    TreeNode treeNode2 = children.get(index);
                    return treeNode2;
                }
                Object var5_6 = null;
                return var5_6;
            }
            finally {
                SimpleTreeModel.this.lock.releaseReadLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getChildCount(Object parentTreeNode) {
            SimpleTreeModel.this.lock.getReadLock();
            try {
                TreeNode treeNode = (TreeNode)parentTreeNode;
                if (parentTreeNode == null) {
                    treeNode = SimpleTreeModel.this.root;
                }
                if (treeNode != null) {
                    int n = treeNode.children.size();
                    return n;
                }
                int n = 0;
                return n;
            }
            finally {
                SimpleTreeModel.this.lock.releaseReadLock();
            }
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getChildCount(node) == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            if (SimpleTreeModel.this.editorListener != null) {
                TreeNode lastNode = (TreeNode)path.getLastPathComponent();
                SimpleTreeModel.this.startEdit(lastNode.value);
                try {
                    SimpleTreeModel.this.editorListener.valueForPathChanged(path, newValue);
                }
                finally {
                    SimpleTreeModel.this.endEdit(lastNode);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getIndexOfChild(Object parent, Object child) {
            SimpleTreeModel.this.lock.getReadLock();
            try {
                TreeNode treeNode = (TreeNode)parent;
                if (parent == null) {
                    treeNode = SimpleTreeModel.this.root;
                }
                if (treeNode != null) {
                    int n = treeNode.children.indexOf(child);
                    return n;
                }
                int n = -1;
                return n;
            }
            finally {
                SimpleTreeModel.this.lock.releaseReadLock();
            }
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            SimpleTreeModel.this.listeners.add(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            SimpleTreeModel.this.listeners.remove(l);
        }
    }

    public static interface TreeModelEditorListener {
        public void valueForPathChanged(TreePath var1, Object var2);
    }
}

