/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.simplelist.jtable;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class TableStructure {
    private String[] propertyNames = null;
    private Class[] cellClass = null;
    private String[] columnLabels = null;
    private Class rowClass;
    private Field[] cachedFields = null;
    private Method[] cachedMethods = null;
    private int[] columnWidths = null;
    private boolean[] editable = null;
    private int[] alignment = null;
    private int[] minWidths = null;
    private int[] maxWidths = null;

    public static TableStructure createTableStructure(Class rowClass, String[] propertyNames, String[] columnLabels) {
        TableStructure structure = new TableStructure();
        structure.propertyNames = propertyNames;
        structure.columnLabels = columnLabels;
        structure.rowClass = rowClass;
        structure.createClasses();
        return structure;
    }

    public static TableStructure createTableStructure(Class rowClass, String[] propertyNames, String[] columnLabels, int[] columnWidths, boolean[] editable) {
        TableStructure structure = new TableStructure();
        structure.propertyNames = propertyNames;
        structure.columnLabels = columnLabels;
        structure.rowClass = rowClass;
        structure.columnWidths = columnWidths;
        structure.editable = editable;
        structure.createClasses();
        return structure;
    }

    public void setWidths(int[] widths) {
        this.columnWidths = widths;
    }

    public void setMinWidths(int[] minWidths) {
        this.minWidths = minWidths;
    }

    public void setMaxWidths(int[] maxWidths) {
        this.maxWidths = maxWidths;
    }

    public void setAlignment(int[] alignment) {
        this.alignment = alignment;
    }

    public void initTableDimensions(JTable table) {
        TableColumn column = null;
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            int width;
            column = table.getColumnModel().getColumn(i);
            if (this.columnWidths != null && this.columnWidths.length > i && (width = this.columnWidths[i]) >= 0) {
                column.setPreferredWidth(width);
            }
            if (this.minWidths != null && this.minWidths.length > i && (width = this.minWidths[i]) >= 0) {
                column.setMinWidth(width);
            }
            if (this.maxWidths == null || this.maxWidths.length <= i || (width = this.maxWidths[i]) < 0) continue;
            column.setMaxWidth(width);
        }
        table.doLayout();
    }

    public int getColumnCount() {
        return this.columnLabels.length;
    }

    public Object getValue(int column, Object rowObject) {
        if (rowObject == null) {
            return null;
        }
        Field field = this.cachedFields[column];
        Method method = this.cachedMethods[column];
        if (field != null) {
            try {
                Object result = field.get(rowObject);
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (method != null) {
            try {
                Object result = method.invoke(rowObject, new Object[0]);
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return rowObject;
        }
        return null;
    }

    public void setValue(Object newValue, Object row, int columnIndex) {
        Field field = this.cachedFields[columnIndex];
        if (field != null) {
            try {
                field.set(row, newValue);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public Class getColumnClass(int column) {
        return this.cellClass[column];
    }

    public String getColumnName(int columnIndex) {
        return this.columnLabels[columnIndex];
    }

    private void createClasses() {
        this.cellClass = new Class[this.propertyNames.length];
        this.cachedFields = new Field[this.propertyNames.length];
        this.cachedMethods = new Method[this.propertyNames.length];
        for (int i = 0; i < this.propertyNames.length; ++i) {
            Method method;
            Field field;
            String property = this.propertyNames[i];
            if (property == null) continue;
            this.cachedFields[i] = field = TableStructure.getField(property, this.rowClass);
            this.cachedMethods[i] = method = TableStructure.getMethod(property, this.rowClass);
            if (field == null && method == null) {
                this.cellClass[i] = Object.class;
                continue;
            }
            if (field != null) {
                this.cellClass[i] = this.getNonPrimitiveClassFor(field.getType());
                field.setAccessible(true);
                continue;
            }
            this.cellClass[i] = this.getNonPrimitiveClassFor(method.getReturnType());
            method.setAccessible(true);
        }
    }

    private Class getNonPrimitiveClassFor(Class clazz) {
        if (clazz.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (clazz.equals(Short.TYPE)) {
            return Short.class;
        }
        if (clazz.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (clazz.equals(Double.TYPE)) {
            return Double.class;
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.class;
        }
        if (clazz.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (clazz.equals(Long.TYPE)) {
            return Long.class;
        }
        return clazz;
    }

    private static Field getField(String property, Class rowClass) {
        Field field = null;
        try {
            field = rowClass.getField(property);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (field == null) {
            try {
                field = rowClass.getDeclaredField(property);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return field;
    }

    private static Method getMethod(String methodName, Class rowClass) {
        Method method = null;
        try {
            method = rowClass.getMethod(methodName, new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = rowClass.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method;
    }

    public static void main(String[] args) {
        TableStructure s = TableStructure.createTableStructure(Field.class, new String[]{"signature", "slot", "name"}, new String[]{"1", "2", "3"});
        System.out.println(s);
    }

    public boolean isColumnEditable(int columnIndex) {
        if (this.editable == null) {
            return false;
        }
        return this.editable[columnIndex];
    }

    public int getAlignmentForColumn(int column) {
        if (this.alignment == null) {
            return -1;
        }
        return this.alignment[column];
    }
}

