/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.simplelist.jtable;

import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.TableStructure;
import utils.swing.simplelist.listener.ListEvent;
import utils.swing.simplelist.listener.ListListener;

public class SimpleTableModel
implements TableModel {
    protected SimpleList list;
    private final ArrayList listeners = new ArrayList();
    private TableStructure tableStructure;

    public SimpleTableModel(SimpleList list, TableStructure tableStructure) {
        this.list = list;
        this.tableStructure = tableStructure;
        list.addListListener(new SimpleTableListener());
    }

    public SimpleList getBackingList() {
        return this.list;
    }

    public void assignToTable(JTable table) {
        table.setModel(this);
        table.setDefaultRenderer(Object.class, new AlignmentCellRenderer());
        this.tableStructure.initTableDimensions(table);
    }

    public Class getColumnClass(int columnIndex) {
        return this.tableStructure.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.tableStructure.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.tableStructure.getColumnName(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.tableStructure.getValue(columnIndex, this.list.get(rowIndex));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.tableStructure.isColumnEditable(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.tableStructure.setValue(aValue, this.list.get(rowIndex), columnIndex);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    private void fireTableEvent(TableModelEvent tme) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TableModelListener)this.listeners.get(i)).tableChanged(tme);
        }
    }

    public void fireAllRowDataChanged() {
        TableModelEvent tme = new TableModelEvent(this);
        if (EventQueue.isDispatchThread()) {
            this.fireTableEvent(tme);
        } else {
            EventQueue.invokeLater(new EventFirer(tme));
        }
    }

    public void fireStructureChanged() {
        TableModelEvent tme = new TableModelEvent(this, -1);
        if (EventQueue.isDispatchThread()) {
            this.fireTableEvent(tme);
        } else {
            EventQueue.invokeLater(new EventFirer(tme));
        }
    }

    public void fireCellChanged(int row, int column) {
        TableModelEvent tme = new TableModelEvent(this, row, row, column);
        if (EventQueue.isDispatchThread()) {
            this.fireTableEvent(tme);
        } else {
            EventQueue.invokeLater(new EventFirer(tme));
        }
    }

    class AlignmentCellRenderer
    extends DefaultTableCellRenderer {
        AlignmentCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int alignment = SimpleTableModel.this.tableStructure.getAlignmentForColumn(column);
            if (alignment == -1) {
                return component;
            }
            if (component instanceof JLabel) {
                JLabel label = (JLabel)component;
                label.setHorizontalAlignment(alignment);
            }
            return component;
        }
    }

    class SimpleTableListener
    implements ListListener {
        SimpleTableListener() {
        }

        public void listAltered(ListEvent event) {
            int startIndex = event.getBlockStart();
            int endIndex = event.getBlockEnd();
            int type = 1;
            switch (event.getBlockType()) {
                case 0: {
                    type = 1;
                    break;
                }
                case 1: {
                    type = -1;
                    break;
                }
                case 2: {
                    type = 0;
                    break;
                }
                default: {
                    System.out.println("UNKNOWN TYPE!");
                }
            }
            TableModelEvent tde = new TableModelEvent(SimpleTableModel.this, startIndex, endIndex, -1, type);
            if (EventQueue.isDispatchThread()) {
                SimpleTableModel.this.fireTableEvent(tde);
            } else {
                EventQueue.invokeLater(new EventFirer(tde));
            }
        }
    }

    class EventFirer
    implements Runnable {
        private TableModelEvent lde;

        public EventFirer(TableModelEvent lde) {
            this.lde = lde;
        }

        @Override
        public void run() {
            SimpleTableModel.this.fireTableEvent(this.lde);
        }
    }
}

