/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.sectionproperties;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.FadePanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;
import utils.swing.sectionproperties.Section;

public abstract class AllSectionsPanel
extends FadePanel
implements MouseListener {
    protected GbPanel allSectionsPanel = new GbPanel();
    protected JScrollPane allSectionsScroller;
    protected JPanel specificSectionPanel = new JPanel(new BorderLayout());
    private GbPanel topPanel = new GbPanel();
    private JLabel specificSectionTitle = new JLabel();
    protected JButton back = new JButton("<<<");
    private JPanel rightContentPanel = new JPanel(new GridLayout(1, 1));
    private ArrayList<SectionCell> allCells = new ArrayList();

    public AllSectionsPanel() {
        super(350);
        this.initUI();
    }

    private void addCellToList(SectionCell cell) {
        this.allCells.add(cell);
    }

    protected void initBackButton() {
    }

    public void switchToAllSectionsPanel() {
        this.setContentComponent(this.allSectionsScroller);
    }

    public void switchToSpecificSectionPanel() {
        this.setContentComponent(this.specificSectionPanel);
    }

    public JComponent getRootComponent() {
        return this;
    }

    protected void initUI() {
        this.allSectionsScroller = new JScrollPane(this.allSectionsPanel);
        this.allSectionsScroller.setBorder(SHBorderFactory.createEmptyBorder());
        this.allSectionsScroller.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.allSectionsScroller.getHorizontalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.allSectionsScroller.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        this.allSectionsScroller.getHorizontalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        this.topPanel.add(this.back, 0, 0, 1, 1, 0, 0, 17, 0);
        this.topPanel.add(this.specificSectionTitle, 1, 0, 1, 1, 1, 1, 10, 1);
        this.topPanel.add(this.rightContentPanel, 2, 0, 1, 1, 0, 1, 10, 1);
        this.topPanel.setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY), SHBorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.topPanel.setBackground(Color.WHITE);
        this.rightContentPanel.setBackground(Color.WHITE);
        this.back.addMouseListener(this);
        this.specificSectionTitle.setHorizontalAlignment(0);
        this.specificSectionTitle.setFont(SHStyle.largeFont);
        this.initBackButton();
        this.switchToAllSectionsPanel();
    }

    public void addSectionRow(SectionRow row) {
        ColorPropagatingPanel rowWrapper = new ColorPropagatingPanel();
        GbPanelWrapper wrapper = new GbPanelWrapper(rowWrapper);
        wrapper.add(row, 0, 0, 1, 1, 1, 0, 17, 0);
        this.allSectionsPanel.add(rowWrapper, 0, this.allSectionsPanel.getComponentCount(), 1, 1, 1, 0, 17, 2);
        if (this.allSectionsPanel.getComponentCount() % 2 == 0) {
            rowWrapper.setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY), SHBorderFactory.createEmptyBorder(4, 5, 0, 5)));
        } else {
            rowWrapper.setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY), SHBorderFactory.createEmptyBorder(4, 5, 0, 5)));
            ((JComponent)rowWrapper).setBackground(Color.white);
        }
    }

    public void finish() {
        int width = 0;
        for (SectionCell cell : this.allCells) {
            width = Math.max(cell.getRequiredWidth(), width);
        }
        for (SectionCell cell : this.allCells) {
            cell.setMinimumWidth(width);
        }
        this.allSectionsPanel.add(new JPanel(), 0, this.allSectionsPanel.getComponentCount(), 1, 1, 1, 1, 10, 1);
    }

    public void setRightContents(JComponent childPanel) {
        this.rightContentPanel.removeAll();
        this.rightContentPanel.add(childPanel);
        this.rightContentPanel.revalidate();
        this.rightContentPanel.repaint();
    }

    protected void selectSection(Section section) {
        this.specificSectionTitle.setText(section.getSectionName());
        this.specificSectionTitle.setIcon(section.getLargeIcon());
        this.specificSectionPanel.removeAll();
        this.specificSectionPanel.add((Component)this.topPanel, "North");
        if (section.getRootComponent().getComponentCount() > 1) {
            JScrollPane pane = new JScrollPane(section.getRootComponent());
            pane.setBorder(SHBorderFactory.createEmptyBorder());
            this.specificSectionPanel.add((Component)pane, "Center");
        } else {
            this.specificSectionPanel.add((Component)section.getRootComponent(), "Center");
        }
        this.specificSectionPanel.revalidate();
        this.switchToSpecificSectionPanel();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.switchToAllSectionsPanel();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public static class SectionCell
    extends ColorPropagatingPanel
    implements MouseListener {
        private Section section;
        private AllSectionsPanel asPanel;
        private JPanel cellContents = new ColorPropagatingPanel(new BorderLayout());
        private JLabel text = new JLabel();
        private JLabel icon = new JLabel();
        private Color backgroundColor;
        private boolean showError = false;
        Dimension size = new Dimension(SimpleHelpLookAndFeel.scale(110), SimpleHelpLookAndFeel.scale(90));
        private String incompleteText;

        public SectionCell(Section section) {
            this.section = section;
            this.setLayout(new BorderLayout());
            this.updateCell();
            this.icon.setHorizontalAlignment(0);
            this.text.setHorizontalTextPosition(0);
            this.text.setHorizontalAlignment(0);
            this.cellContents.add((Component)this.icon, "North");
            this.cellContents.add((Component)this.text, "Center");
            this.add((Component)this.cellContents, "Center");
            this.addMouseListener(this);
            this.icon.addMouseListener(this);
            this.text.addMouseListener(this);
            this.setBorder(SHBorderFactory.createEmptyBorder(2, 10, 0, 10));
        }

        @Override
        public Dimension getPreferredSize() {
            return this.size;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.size;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.size;
        }

        public void updateCell() {
            String[] words;
            this.icon.setIcon(this.section.getLargeIcon());
            String sectionName = this.section.getSectionName();
            if (sectionName.length() > 18 && (words = sectionName.split(" ")).length > 1) {
                int middle = sectionName.length() / 2;
                int space = 0;
                int nearestSpace = 0;
                for (int i = 0; i < words.length - 1; ++i) {
                    if (i > 0) {
                        ++space;
                    }
                    space += words[i].length();
                    if (i == 0) {
                        nearestSpace = space;
                        continue;
                    }
                    if (Math.abs(nearestSpace - middle) <= Math.abs(space - middle)) continue;
                    nearestSpace = space;
                }
                sectionName = sectionName.substring(0, nearestSpace) + "<BR>" + sectionName.substring(nearestSpace + 1);
            }
            if (!this.showError) {
                this.text.setText("<html><center>" + sectionName);
            } else {
                this.text.setText("<html><center>" + sectionName + "<BR><font color=red>" + this.incompleteText + "</font>");
            }
            this.text.repaint();
        }

        public void setAllSectionsPanel(AllSectionsPanel asPanel) {
            this.asPanel = asPanel;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.asPanel.selectSection(this.section);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        public void showError(boolean isValid, String errorText) {
            this.incompleteText = errorText;
            this.showError = !isValid;
        }

        public void setMinimumWidth(int minimumWidth) {
            this.size.width = minimumWidth;
        }

        public int getRequiredWidth() {
            return super.getPreferredSize().width;
        }
    }

    public static class SectionRow
    extends ColorPropagatingPanel {
        private AllSectionsPanel asPanel;

        public SectionRow(AllSectionsPanel asPanel) {
            this.setLayout(new GridLayout(1, 0));
            this.asPanel = asPanel;
        }

        public void setAllSectionsPanel(AllSectionsPanel asPanel) {
            this.asPanel = asPanel;
        }

        public void addSection(Section section) {
            SectionCell cell = new SectionCell(section);
            cell.setAllSectionsPanel(this.asPanel);
            section.setSectionCell(cell);
            this.add(cell);
            this.asPanel.addCellToList(cell);
        }
    }
}

