/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.logview.shelp;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import utils.progtools.Counter;
import utils.string.CharStack;
import utils.swing.logview.LogIcons;
import utils.swing.logview.mining.EmptyLogEntity;
import utils.swing.logview.mining.EntityMiner;
import utils.swing.logview.mining.LogEntity;
import utils.swing.logview.mining.LogSummary;
import utils.swing.logview.mining.MultiLogEntity;
import utils.swing.logview.mining.SummaryMiner;

public class SHSummaryMiner
implements SummaryMiner,
EntityMiner {
    LogEntity readability = new EmptyLogEntity("Readability");
    LogEntity nlconvs = new EmptyLogEntity("NodeLink Conversations");
    LogEntity nldebug = new EmptyLogEntity("NodeLink Debugging");
    LogEntity alerts = new EmptyLogEntity("Alerts and Thresholds");
    LogEntity monitoring = new EmptyLogEntity("Monitoring");
    LogEntity messaging = new EmptyLogEntity("Messaging");
    LogEntity misc = new EmptyLogEntity("Misc");
    ArrayList<LogEntity> ents = new ArrayList();
    ArrayList<LogSummary> list = new ArrayList();

    private String stripEndBracket(String s) {
        if (s.endsWith("]")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    private String grabEndOfLine(String match, String log) {
        CharStack cs = new CharStack(log);
        cs.popUntil(match);
        cs.popWhitespace();
        String vapp = cs.popLine(true).trim();
        return vapp;
    }

    private String grabSquareBracketProp(String name, String log) {
        String find = name + "=[";
        CharStack cs = new CharStack(log);
        cs.popUntil(find);
        if (cs.isEmpty()) {
            return null;
        }
        String ret = cs.popLine(true).trim();
        ret = this.stripEndBracket(ret);
        return ret;
    }

    private int countInstancesOf(String text, String log) {
        CharStack cs = new CharStack(log);
        int N = -1;
        do {
            cs.popUntil(text);
            ++N;
        } while (!cs.isEmpty());
        return N;
    }

    private void addCategoryEntities() {
        this.readability.icon = LogIcons.readability;
        this.nlconvs.icon = LogIcons.nlconv;
        this.nldebug.icon = LogIcons.nldebug;
        this.alerts.icon = LogIcons.alerts;
        this.monitoring.icon = LogIcons.monitoring;
        this.messaging.icon = LogIcons.messaging;
        this.misc.icon = LogIcons.misc;
        this.add(this.readability);
        this.add(this.nlconvs);
        this.add(this.nldebug);
        this.add(this.alerts);
        this.add(this.monitoring);
        this.add(this.messaging);
        this.add(this.misc);
    }

    @Override
    public void feedLog(String log) {
        String nativepath;
        int issuecount;
        int numformat;
        int issue;
        String screenTimes;
        int unknownhost;
        int linkerror;
        int hiccups;
        int breaches;
        int threaderrors;
        int poolerrors;
        int comoderrors;
        int toosimple;
        int memerrors;
        int fileerrors;
        String vapp;
        CharStack cs;
        this.addCategoryEntities();
        if (log.indexOf("[GenericUpdater] Starting") != -1) {
            String override;
            cs = new CharStack(log);
            cs.popUntil("_app_name=[", false);
            vapp = cs.popUntil("]", true).trim();
            cs = new CharStack(log);
            cs.popUntil("Virtual app specified in launch properties:", false);
            if (!cs.isEmpty()) {
                override = cs.popLine(true).trim();
                vapp = override + " (overridden by LP from " + vapp + ")";
            }
            cs = new CharStack(log);
            cs.popUntil("Virtual app specified in args:", false);
            if (!cs.isEmpty()) {
                override = cs.popLine(true).trim();
                vapp = override + " (overridden by ARGS from " + vapp + ")";
            }
            if (log.indexOf("[GenericUpdaterMain] doing SANITY CHECK only") != -1) {
                this.list.add(new LogSummary("GU Sanity Check", vapp, false));
            } else if (log.indexOf("[GenericUpdaterMain] we are UNINSTALLER") != -1) {
                this.list.add(new LogSummary("GU Uninstaller", vapp, false));
            } else {
                this.list.add(new LogSummary("GU Launch", vapp, false));
            }
        } else if (log.indexOf("Server Version v") != -1) {
            int machinesValid;
            int machinesInDb;
            String ver = this.grabEndOfLine("Server Version v", log);
            String build = this.grabEndOfLine("Server Build ", log);
            String sessions = this.grabEndOfLine("Sessions: ", log);
            this.list.add(new LogSummary("SH Server", "v" + ver + " " + build + " (" + sessions + " sessions)", false));
            int binderrors = this.countInstancesOf("BindException", log);
            if (binderrors > 0) {
                this.list.add(new LogSummary("BindException", "x" + binderrors, true, false, true));
            }
            if ((machinesInDb = this.countInstancesOf("[MachineDB] Loading", log)) > 0) {
                this.list.add(new LogSummary("Machines in DB", "x" + machinesInDb + " (includes offline / old machines)", true, false, false));
            }
            if ((machinesValid = this.countInstancesOf("[MachineDB] Loaded machine", log)) > 0) {
                this.list.add(new LogSummary("Valid machines in DB", "x" + machinesValid + " (includes offline / old machines)", true, false, false));
            }
            int machineCount = Math.max(machinesInDb, machinesValid);
            int secmsgConfigs = this.countInstancesOf("[SecureMessengerDB] Loading", log);
            if (secmsgConfigs > 0) {
                if (secmsgConfigs > machineCount * 2) {
                    this.list.add(new LogSummary("SecMsg Saved Configs", "x" + secmsgConfigs + " (may be old, should rotate, but this is a large amount for this number of machines)", true, true, false));
                } else {
                    this.list.add(new LogSummary("SecMsg Saved Configs", "x" + secmsgConfigs + " (may be old, should rotate over time)"));
                }
            }
        } else {
            cs = new CharStack(log);
            cs.popUntil("Virtual App:");
            if (cs.isEmpty()) {
                if (log.contains("Preparatory virtual app")) {
                    this.list.add(new LogSummary("Preloaded App", "Unlaunched", false));
                }
            } else {
                cs.popWhitespace();
                vapp = cs.popLine(true).trim();
                if (vapp.endsWith("Access Service")) {
                    cs = new CharStack(log);
                    cs.popUntil("[SimpleGatewayConfig] Name:");
                    String sgname = cs.popLine(true).trim();
                    String sgid = this.grabSquareBracketProp("AutomaticCustomerID", log);
                    int conns = this.countInstancesOf("Connection required with ID:", log);
                    this.list.add(new LogSummary("RA Service", sgname + " (x" + conns + " sessions) (SG_" + sgid + ")", false));
                } else if (vapp.endsWith("Access Configure")) {
                    String sgname = this.grabEndOfLine("[SimpleGatewayConfig] Name:", log);
                    String sgid = this.grabSquareBracketProp("AutomaticCustomerID", log);
                    this.list.add(new LogSummary("RA Configure", sgname + " (SG_" + sgid + ")", false));
                } else if (vapp.endsWith("Access Session")) {
                    String sgname = this.grabEndOfLine("[SimpleGatewayConfig] Name:", log);
                    String sgid = this.grabSquareBracketProp("AutomaticCustomerID", log);
                    this.list.add(new LogSummary("RA Session", sgname + " (SG_" + sgid + ")", false));
                } else if (vapp.endsWith(" Technician")) {
                    int sessions = this.countInstancesOf("Asked to launch virtual app SessionUI", log);
                    cs = new CharStack(log);
                    Counter<String> counter = new Counter<String>();
                    ArrayList<String> launches = new ArrayList<String>();
                    while (!cs.isEmpty()) {
                        cs.popUntil("Adding custom overridden launch prop TechHelpUiId =");
                        if (cs.isEmpty()) break;
                        String sgid = cs.popLine(true).trim();
                        counter.add(sgid, 1.0);
                        if (counter.getInt(sgid) != 1) continue;
                        launches.add(sgid);
                    }
                    String targets = "";
                    for (String sgid : launches) {
                        System.out.println("SGID launch: " + sgid);
                        if (targets.length() == 0) {
                            targets = sgid + " x" + counter.getInt(sgid);
                            continue;
                        }
                        targets = targets + ", " + sgid + " x" + counter.getInt(sgid);
                    }
                    this.list.add(new LogSummary("Tech Client", sessions + " sessions (" + targets + ")", false));
                } else if (vapp.endsWith("SessionUI")) {
                    String sgid = this.grabSquareBracketProp("TechHelpUiId", log);
                    boolean isSG = false;
                    try {
                        isSG = this.grabSquareBracketProp("TechHelpUiIsMachine", log).trim().equalsIgnoreCase("true");
                    }
                    catch (Exception launches) {
                        // empty catch block
                    }
                    if (isSG) {
                        this.list.add(new LogSummary("Tech RA Session", sgid, false));
                    } else {
                        this.list.add(new LogSummary("Tech Support Session", sgid, false));
                    }
                } else if (vapp.endsWith("Access Monitoring")) {
                    this.list.add(new LogSummary("RA Monitoring", "", false));
                }
            }
        }
        String updateURL = this.grabSquareBracketProp("jwdyna_update_url", log);
        this.list.add(new LogSummary("Update URL", updateURL));
        String version = this.grabEndOfLine("App Bundle Version:", log);
        if (version.length() > 0) {
            long ver = Long.parseLong(version);
            ver = 4000L * (322000000L + ver);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
            this.list.add(new LogSummary("App Version", sdf.format(new Date(ver)) + " (" + version + ")"));
        }
        String data = this.grabEndOfLine("OS:     ", log);
        this.list.add(new LogSummary("OS", data));
        data = this.grabEndOfLine("Java Version:    ", log);
        if (data.startsWith("1.5.")) {
            this.list.add(new LogSummary("Java", data, true, true, false));
        } else {
            this.list.add(new LogSummary("Java", data));
        }
        data = this.grabEndOfLine("User:     ", log);
        this.list.add(new LogSummary("OS User", data));
        data = this.grabEndOfLine("Language:     ", log);
        this.list.add(new LogSummary("Language / Timezone", data));
        data = this.grabEndOfLine("Applying upper bandwidth limit of", log).trim();
        if (data.length() > 0) {
            this.list.add(new LogSummary("Bandwidth Limit", data + " KB/s"));
        }
        if ((data = this.grabEndOfLine("Applying upper FPS limit of", log).trim()).length() > 0) {
            this.list.add(new LogSummary("FPS Limit", data + " frames/s"));
        }
        cs = new CharStack(log);
        String urls = null;
        boolean duplicateHosts = false;
        ArrayList<String> hosts = new ArrayList<String>();
        do {
            cs.popUntil("[PollThread] Polling");
            if (cs.isEmpty()) continue;
            String line = cs.popLine(true).trim();
            int INDEX = line.indexOf("com.aem.sgateway");
            if (INDEX != -1) {
                line = line.substring(0, INDEX).trim();
            }
            try {
                CharStack css = new CharStack(line);
                css.popUntil("://");
                String host = css.popUntil(new char[]{':', '/'}, true);
                System.out.println("SG HOST: " + host);
                if (!hosts.contains(host)) {
                    hosts.add(host);
                } else {
                    duplicateHosts = true;
                }
            }
            catch (Exception css) {
                // empty catch block
            }
            urls = urls == null ? line : urls + ", " + line;
        } while (!cs.isEmpty());
        if (urls != null) {
            if (duplicateHosts) {
                this.list.add(new LogSummary("SG Service Polling URLs", urls + " (duplicate servers!)", true, true, false));
            } else {
                this.list.add(new LogSummary("SG Service Polling URLs", urls));
            }
        }
        cs = new CharStack(log);
        String sgServerHost = this.grabSquareBracketProp("AutomaticCustomerHost", log);
        String sgServerPort = this.grabSquareBracketProp("AutomaticCustomerPort", log);
        if (sgServerHost != null) {
            this.list.add(new LogSummary("Session Server URL", sgServerHost + ":" + sgServerPort));
        }
        if ((fileerrors = this.countInstancesOf("Too many open files", log)) > 0) {
            this.list.add(new LogSummary("Too many open files", "x" + fileerrors, true, false, true));
        }
        if ((memerrors = this.countInstancesOf("OutOfMemoryError", log)) > 0) {
            this.list.add(new LogSummary("Out of memory error", "x" + memerrors, true, false, true));
        }
        if ((toosimple = this.countInstancesOf("Bad: new password is too simple", log)) > 0) {
            this.list.add(new LogSummary("Linux password is too simple", "x" + toosimple, true, false, true));
        }
        if ((comoderrors = this.countInstancesOf("ConcurrentModificationErrors", log)) > 0) {
            this.list.add(new LogSummary("Concurrent modification error", "x" + comoderrors, true, false, true));
        }
        if ((poolerrors = this.countInstancesOf("pool alert", log)) > 0) {
            this.list.add(new LogSummary("Pool Alerts", "x" + poolerrors, true, false, true));
        }
        if ((threaderrors = this.countInstancesOf("unable to create native thread", log)) > 0) {
            this.list.add(new LogSummary("Unable to create thread", "x" + memerrors, true, false, true));
        }
        if ((breaches = this.countInstancesOf("***IMPORTANT*** Breached production thread", log)) > 0) {
            this.list.add(new LogSummary("Thread dumps", "x" + breaches, true, false, true));
        }
        if ((hiccups = this.countInstancesOf("***HICCUP Overslept", log)) > 0) {
            this.list.add(new LogSummary("Overslept", "x" + hiccups, true, hiccups > 50, false));
        }
        if ((linkerror = this.countInstancesOf("UnsatisfiedLinkError", log)) > 0) {
            this.list.add(new LogSummary("UnsatisfiedLinkError", "x" + linkerror, true, false, true));
        }
        if ((unknownhost = this.countInstancesOf("UnknownHostException", log)) > 0) {
            this.list.add(new LogSummary("UnknownHostException", "x" + unknownhost, true, true, false));
        }
        if ((screenTimes = this.grabEndOfLine("Initial screen grab times:", log)).trim().length() > 0) {
            this.list.add(new LogSummary("Initial screen grab times", screenTimes, true, false, false));
        }
        if ((issue = this.countInstancesOf("TechUI login failed", log)) > 0) {
            this.list.add(new LogSummary("[TechUI] Login failed", "x" + issue, true, true, false));
        }
        if ((issue = this.countInstancesOf("appears to be stuck", log)) > 0) {
            this.list.add(new LogSummary("appears to be stuck", "x" + issue, true, true, false));
        }
        if ((issue = this.countInstancesOf("Renegotiation failed", log)) > 0) {
            this.list.add(new LogSummary("Renegotiation failed", "x" + issue, true, issue > 0, issue > 10));
        }
        if ((issue = this.countInstancesOf("[ServerKeys] Reloading keys", log)) > 0) {
            this.list.add(new LogSummary("ServerKeys.dat reloaded", "x" + issue, true, issue > 0, issue > 10));
        }
        if ((numformat = this.countInstancesOf("NumberFormatException", log)) > 0) {
            this.list.add(new LogSummary("NumberFormatException", "x" + numformat, true, true, false));
        }
        if ((numformat = this.countInstancesOf("ArrayIndexOutOfBoundsException", log)) > 0) {
            this.list.add(new LogSummary("NumberFormatException", "x" + numformat, true, true, false));
        }
        if ((numformat = this.countInstancesOf("StringIndexOutOfBoundsException", log)) > 0) {
            this.list.add(new LogSummary("StringIndexOutOfBoundsException", "x" + numformat, true, true, false));
        }
        if ((numformat = this.countInstancesOf("ClassCastException", log)) > 0) {
            this.list.add(new LogSummary("ClassCastException", "x" + numformat, true, false, true));
        }
        if (log.indexOf("java.lang.ClassCastException: com.aem.shelp.tech.access.model.subgroups.FilterResultsGroup") != -1) {
            this.list.add(new LogSummary("FilterResultsGroup", "ClassCastException, migrated from 4.3+ props back to 4.2? Clear prefs?", true, false, true));
        }
        if ((numformat = this.countInstancesOf("read only alert modification", log)) > 0) {
            this.list.add(new LogSummary("Read-only alert modification", "x" + numformat, true, false, true));
        }
        if ((issuecount = this.countInstancesOf("NativeUtils was not initialised", log)) > 0) {
            this.list.add(new LogSummary("NativeUtils broken", "NativeUtils seemed to load but did not initialise properly", true, false, false));
            nativepath = this.grabEndOfLine("Trying to load native library", log);
            this.list.add(new LogSummary("NativeUtils libpath", nativepath, true, false, false));
        }
        if ((issuecount = this.countInstancesOf("[NativeUtils] unable to load", log)) > 0) {
            this.list.add(new LogSummary("NativeUtils broken", "NativeUtils was unable to load", true, false, false));
            nativepath = this.grabEndOfLine("Trying to load native library", log);
            this.list.add(new LogSummary("NativeUtils libpath", nativepath, true, false, false));
        }
        Object counter = new Counter();
        CharStack cs2 = new CharStack(log);
        int N = -1;
        do {
            cs2.popUntil("NL renamed");
            String line = cs2.popLine(true);
            CharStack linecs = new CharStack(line);
            linecs.popUntil("UnknownMagic");
            if (linecs.isEmpty()) continue;
            try {
                linecs.popUntil(" / ");
                linecs.popWhitespace();
                String ip = linecs.popText(true);
                ((Counter)counter).add(ip, 1.0);
                ++N;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        } while (!cs2.isEmpty());
        if (N > 0) {
            ((Counter)counter).sortByValue(false);
            ArrayList keys = ((Counter)counter).getSortedKeys();
            StringBuffer sb = new StringBuffer();
            sb.append("from " + N + " IPs; ");
            for (int k = 0; k < Math.min(10, keys.size()); ++k) {
                Object ip = keys.get(k);
                sb.append(ip + " ");
            }
            System.out.println("Bad connect from " + N + " ips");
            this.list.add(new LogSummary("NL Bad version connections", N + " bad connects from " + keys.size() + " IPs; " + sb.toString(), true, N > 10, N > 80));
        }
        counter = new CharStack(log);
        this.add(new MultiLogEntity("Alert States on ProxyServer", new String[]{"[AlertState]"}, false, this.alerts));
        this.add(new MultiLogEntity("Monitoring state fed to Alerts", new String[]{"[StatsDump]"}, false, this.alerts));
        this.add(new MultiLogEntity("SecurityProduct state fed to Alerts", new String[]{"[SecurityDump]"}, false, this.alerts));
        this.add(new MultiLogEntity("Monitoring Messages", new String[]{"monitoring", "monitored"}, false, this.monitoring));
        this.add(new MultiLogEntity("GenStore Upload", new String[]{"genstore", "collator"}, false, this.monitoring));
        this.add(new MultiLogEntity("Popup RA Notifications", new String[]{"PopupNotify"}, false, this.messaging));
        this.add(new MultiLogEntity("Messages", new String[]{"message", "msg", "submsg"}, false, this.messaging));
        this.add(new MultiLogEntity("NL Termination Traces", new String[]{"NL Connection Trace"}, false, this.nldebug));
        this.add(new MultiLogEntity("NL Link Down", new String[]{"link went down"}, false, this.nldebug));
        this.add(new MultiLogEntity("SH NL Connect Types", new String[]{"[MultiStatus] Connection started:", "connection made by", "Pulling transport from"}, false, this.nldebug));
        MultiLogEntity me = new MultiLogEntity("Silent Reconnect", new String[0], false, this.misc);
        me.add("COMMAND_");
        me.add("SilentReconnect");
        me.add("Connection required for");
        me.add("Customer/sg/sd connection");
        me.add("Preparing to join customer");
        me.add("Joined customer");
        me.add("RaConsoleCheck");
        this.add(me);
        this.add(new MultiLogEntity("NL BEF Flow Rates", new String[]{"NL BEF"}, false, this.nldebug));
        CharStack cs3 = new CharStack(log);
        while (true) {
            cs3.popUntil("NL BEF");
            if (cs3.isEmpty()) break;
            cs3.popUntilNumber();
            try {
                int packetsPerSec = (int)cs3.popNumber();
                if (packetsPerSec > 1) continue;
                this.add(new LogSummary("NL BEF", "reached 1 packet per second (min granularity)", true, true, false));
            }
            catch (Exception x) {
                x.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void pickAlertNameAndID(CharStack cs, Counter alcount) {
        if (!cs.isEmpty()) {
            String alertName = cs.popUntil("(", true).trim();
            String alertID = cs.popText(true).trim();
            if (alertID.endsWith(")")) {
                alertID = alertID.substring(0, alertID.length() - 1);
            }
            alcount.add(alertID, 1.0);
            if (alcount.getInt(alertID) == 1) {
                MultiLogEntity me = new MultiLogEntity(alertName + "/" + alertID, false);
                me.addAnnotation(alertName);
                me.addAnnotation(alertID);
                me.parent = this.alerts;
                me.minCount = 1;
                me.add(alertName);
                me.add(alertID);
                this.add(me);
            }
        }
    }

    private void add(LogSummary summary) {
        if (summary != null) {
            this.list.add(summary);
        }
    }

    private LogEntity add(LogEntity entity) {
        if (entity != null) {
            this.ents.add(entity);
        }
        return entity;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void feedLines(ArrayList<String> lines) {
        void var6_17;
        CharStack cs;
        CharStack cs2;
        int N = 0;
        LogSummary spawned = null;
        for (String string : lines) {
            N = string.indexOf("[LaunchFile] Asked to launch virtual app");
            if (N == -1) continue;
            String string2 = string.substring(N + "[LaunchFile] Asked to launch virtual app".length());
            if (spawned == null) {
                spawned = new LogSummary("Launched", string2);
                continue;
            }
            spawned.summary = spawned.summary + ", " + string2;
        }
        this.add(spawned);
        Counter<String> nlcount = new Counter<String>();
        for (String string : lines) {
            CharStack cs3 = new CharStack(string);
            cs3.popUntil("NodeLink NL");
            if (cs3.isEmpty()) continue;
            cs3.popUntil("-@");
            cs3.popUntil("/");
            cs3.popWhitespace();
            String nlconv = cs3.popText(true);
            if (nlconv.startsWith("conv")) {
                nlconv = nlconv.substring(4);
            }
            nlcount.add(nlconv, 1.0);
            if (nlcount.getInt(nlconv) != 1) continue;
            MultiLogEntity me = new MultiLogEntity("NL#-" + nlconv, false);
            me.addAnnotation(nlconv);
            me.parent = this.nlconvs;
            me.minCount = 2;
            me.add(nlconv);
            this.add(me);
        }
        Counter counter = new Counter();
        for (String line : lines) {
            CharStack cs22 = new CharStack(line);
            cs22.popUntil("[Alerts] Alert:");
            this.pickAlertNameAndID(cs22, counter);
        }
        for (String line : lines) {
            cs2 = new CharStack(line);
            cs2.popUntil("[StateDump] Alert:");
            this.pickAlertNameAndID(cs2, counter);
        }
        for (String line : lines) {
            if (line.indexOf("reporting state to server as") == -1) continue;
            cs2 = new CharStack(line);
            cs2.popUntil("[BasicAlert] ");
            this.pickAlertNameAndID(cs2, counter);
        }
        for (String line : lines) {
            if (line.indexOf("targets") == -1 || line.indexOf("[AlertsDB]") == -1 && line.indexOf("[StateDump]") == -1) continue;
            cs2 = new CharStack(line);
            cs2.popUntil("[AlertsDB] ");
            this.pickAlertNameAndID(cs2, counter);
        }
        for (String line : lines) {
            cs2 = new CharStack(line);
            cs2.popUntil("[Alerts] --");
            this.pickAlertNameAndID(cs2, counter);
        }
        Object var6_16 = null;
        LogSummary usedmem = null;
        double maxUsedMem = 0.0;
        double maxUsedThreads = 0.0;
        for (String line : lines) {
            N = line.indexOf("MemoryTracking2");
            if (N == -1) continue;
            cs = new CharStack(line);
            cs.popUntil("Threads =", false);
            cs.popUntilNumber();
            if (cs.isEmpty()) continue;
            double threads = (int)cs.popNumber();
            if (threads > maxUsedThreads) {
                maxUsedThreads = threads;
                if (var6_17 == null) {
                    LogSummary logSummary = new LogSummary("Max Used Threads", "" + (int)threads);
                } else {
                    var6_17.summary = "" + (int)threads;
                }
            }
            cs.popUntil("Used Memory");
            cs.popUntil("(", false);
            cs.mark();
            double usedPc = cs.popNumber();
            if (!(usedPc > maxUsedMem)) continue;
            maxUsedMem = usedPc;
            cs.resetToMark();
            String text = cs.popUntil(")", true);
            if (usedmem == null) {
                usedmem = new LogSummary("Max Used Memory", text);
                continue;
            }
            usedmem.summary = text;
        }
        this.add((LogSummary)var6_17);
        this.add(usedmem);
        for (String line : lines) {
            cs = new CharStack(line);
            cs.popUntil("[MachineDB] Loaded machine ");
            if (cs.isEmpty()) continue;
            cs.popWhitespace();
            String SGID = cs.popText(true);
            cs.popWhitespace();
            cs.pop();
            String string = cs.popUntil(')', true);
        }
        MultiLogEntity filter = new MultiLogEntity("SG Repetitive", true);
        filter.parent = this.readability;
        filter.add("[SimpleGatewayService] Claiming ID");
        filter.add("[SimpleGatewayService] Claimed our ID");
        filter.add("*[SimpleGatewayService] ID claim has * additional*");
        filter.add("[SimpleGatewayService] Pinging with pkhashPortion");
        filter.add("*[SimpleGatewayService] Prop * / *");
        filter.add("*[SecureMessengerDB] secmsg * is ready now*");
        this.add(filter);
        filter = new MultiLogEntity("Central Time", true);
        filter.parent = this.readability;
        filter.add("Centralised time");
        this.add(filter);
        filter = new MultiLogEntity("Small hiccups", true);
        filter.parent = this.readability;
        filter.add("*HICCUP Overslept ??? >*");
        filter.add("*HICCUP Overslept ?? >*");
        this.add(filter);
        filter = new MultiLogEntity("Memory Tracking", true);
        filter.parent = this.readability;
        filter.add("memorytracking2");
        this.add(filter);
        filter = new MultiLogEntity("JW Launch Props", true);
        filter.parent = this.readability;
        filter.add("JWrapperLaunchProperty");
        this.add(filter);
        filter = new MultiLogEntity("Netsh firewall", true);
        filter.parent = this.readability;
        filter.add("However, \"netsh firewall\" is deprecated;");
        filter.add("use \"netsh advfirewall firewall\" instead.");
        filter.add("For more information on using \"netsh advfirewall firewall\" commands");
        filter.add("use \"netsh advfirewall firewall\" instead.");
        filter.add("instead of \"netsh firewall\", see KB article 947709");
        filter.add("at http://go.microsoft.com/fwlink/?linkid=121488");
        this.add(filter);
    }

    @Override
    public boolean amHiddenByDefault() {
        return false;
    }

    @Override
    public boolean amWarning() {
        return false;
    }

    @Override
    public boolean amError() {
        return false;
    }

    @Override
    public ArrayList<LogSummary> getSummaryLines() {
        return this.list;
    }

    @Override
    public void reset() {
        this.ents.clear();
        this.list.clear();
    }

    @Override
    public ArrayList<LogEntity> getDetectedEntities() {
        return this.ents;
    }
}

