/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.layout;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import utils.swing.SwingUtil;
import utils.swing.layout.GbPanel;
import utils.swing.listeners.SystemExitWindowListener;

public class FadeOnHoverPanel
extends GbPanel
implements MouseListener {
    boolean amOut = false;
    JComponent main;
    JComponent hidden;

    public FadeOnHoverPanel() {
        this.addMouseListener(this);
    }

    private void fadeIn() {
        this.amOut = false;
        this.fadeIn(0);
    }

    private void fadeIn(int N) {
        if (this.amOut) {
            this.fadeOut();
            return;
        }
        if (N > 255) {
            N = 255;
        }
        Color fg = this.main.getForeground();
        Color bg = this.main.getBackground();
        this.hidden.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), N));
        this.hidden.setForeground(new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), N));
        this.main.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 255 - N));
        this.main.setForeground(new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 255 - N));
        this.repaint();
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (N == 255) {
            return;
        }
        final int NN = N;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FadeOnHoverPanel.this.fadeIn(NN + 70);
            }
        });
    }

    private void fadeOut() {
        this.amOut = true;
        Color fg = this.main.getForeground();
        Color bg = this.main.getBackground();
        this.hidden.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 0));
        this.hidden.setForeground(new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 0));
        this.main.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 255));
        this.main.setForeground(new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 255));
        this.repaint();
    }

    public void addBoth(JComponent main, JComponent hidden) {
        this.main = main;
        this.hidden = hidden;
        this.add(main, 0, 0, 1, 1, 100, 100, 10, 1);
        this.add(hidden, 0, 0, 1, 1, 100, 100, 10, 1);
        this.fadeOut();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setBounds(0, 0, 500, 500);
        SwingUtil.centreFrame(frame);
        frame.addWindowListener(new SystemExitWindowListener());
        FadeOnHoverPanel fp = new FadeOnHoverPanel();
        fp.addBoth(new JLabel("MAIN"), new JLabel("explanation..."));
        frame.getContentPane().add(fp);
        frame.setVisible(true);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.fadeIn();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.fadeOut();
    }
}

