/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.images;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class NotificationOverlayPainter {
    public static final Color NOTIFICATION_RED = new Color(188, 36, 16);

    public static void paint(Graphics2D g2d, int x, int y, int circleDiameter, String text, Color bgColor, Color textColor) {
        g2d.setColor(bgColor);
        g2d.fillArc(x, y, circleDiameter, circleDiameter, 0, 360);
        g2d.fillRoundRect(x, y, circleDiameter, circleDiameter, 5, 5);
        g2d.setColor(textColor);
        float fontSize = SimpleHelpLookAndFeel.scale(12.0f);
        if (text.length() > 1) {
            fontSize = SimpleHelpLookAndFeel.scale(10.0f);
        }
        if (text.length() > 2) {
            fontSize = SimpleHelpLookAndFeel.scale(8.0f);
        }
        g2d.setFont(g2d.getFont().deriveFont(fontSize).deriveFont(1));
        FontMetrics fm = g2d.getFontMetrics(g2d.getFont());
        Rectangle2D rect = fm.getStringBounds(text, g2d);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        int xx = x + (circleDiameter - textWidth) / 2;
        int yy = y + (circleDiameter - textHeight) / 2 + fm.getAscent();
        g2d.drawString(text, xx, yy);
    }
}

