/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.icons;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;
import utils.ostools.OS;
import utils.swing.SafeJFileChooser;

public class SystemIconUtil {
    private static final FileSystemView view = FileSystemView.getFileSystemView();
    private static Icon defaultFolderIcon = null;
    private static Icon defaultFileIcon = null;
    private static Icon defaultDriveIcon = null;
    private static FileView aquaFileView;
    private static final Object LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileView getAquaFileView() {
        Object object = LOCK;
        synchronized (object) {
            if (aquaFileView != null) {
                return aquaFileView;
            }
            SafeJFileChooser chooser = SafeJFileChooser.getSafeJFileChooser();
            try {
                Class<?> clazz = Class.forName("com.apple.laf.AquaFileChooserUI");
                Constructor<?> constructor = clazz.getConstructor(JFileChooser.class);
                FileChooserUI UI = (FileChooserUI)constructor.newInstance(chooser);
                aquaFileView = UI.getFileView(chooser);
            }
            catch (Throwable t) {
                t.printStackTrace();
                aquaFileView = chooser.getFileView();
            }
        }
        return aquaFileView;
    }

    public static Icon getDefaultFolderIcon() {
        if (defaultFolderIcon != null) {
            return defaultFolderIcon;
        }
        try {
            File f = File.createTempFile("systemicontmp", "dat");
            f.delete();
            f.mkdirs();
            try {
                defaultFolderIcon = SystemIconUtil.getSystemIconFor(f);
            }
            finally {
                f.delete();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return defaultFolderIcon;
    }

    public static Icon getDefaultDriveIcon() {
        if (defaultDriveIcon != null) {
            return defaultDriveIcon;
        }
        defaultDriveIcon = OS.isMacOS() ? SystemIconUtil.getSystemIconFor(new File("/")) : (OS.isWindows() ? SystemIconUtil.getSystemIconFor(new File("C:")) : SystemIconUtil.getSystemIconFor(new File("/")));
        return defaultDriveIcon;
    }

    public static Icon getDefaultFileIcon() {
        if (defaultFileIcon != null) {
            return defaultFileIcon;
        }
        try {
            File f = File.createTempFile("systemicontmp", "dat");
            try {
                defaultFileIcon = SystemIconUtil.getSystemIconFor(f);
            }
            finally {
                f.delete();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return defaultFileIcon;
    }

    public static Icon getSystemIconFor(File file) {
        if (OS.isMacOS()) {
            return SystemIconUtil.getAquaFileView().getIcon(file);
        }
        return view.getSystemIcon(file);
    }

    static {
        LOCK = new Object();
    }
}

