/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.icons;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import utils.swing.components.animated.AbstractAnimatedIcon;

public class RotatingIcon
extends AbstractAnimatedIcon {
    private final Icon parentIcon;
    private double angle = 0.0;
    private int width;
    private int xOffset;
    private int yOffset;

    public RotatingIcon(Icon parentIcon) {
        this.parentIcon = parentIcon;
        this.width = (int)Math.sqrt(Math.pow(parentIcon.getIconWidth(), 2.0) + Math.pow(parentIcon.getIconHeight(), 2.0));
        this.xOffset = (this.width - parentIcon.getIconWidth()) / 2;
        this.yOffset = (this.width - parentIcon.getIconHeight()) / 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintFrame(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        int paintX = x + this.xOffset;
        int paintY = y + this.yOffset;
        int centreX = paintX + this.parentIcon.getIconWidth() / 2;
        int centreY = paintY + this.parentIcon.getIconWidth() / 2;
        this.angle += 0.031415926535897934;
        AffineTransform t = g2d.getTransform();
        g2d.rotate(this.angle, centreX, centreY);
        try {
            this.parentIcon.paintIcon(c, g2d, paintX, paintY);
        }
        finally {
            g2d.setTransform(t);
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.width;
    }
}

