/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.formatters;

import java.text.DecimalFormat;

public class DataSizeFormatter {
    public static final DataSizeFormatter INSTANCE = new DataSizeFormatter();
    private static final long SIZE_KB = 1024L;
    private static final long SIZE_MB = 0x100000L;
    private static final long SIZE_GB = 0x40000000L;
    private static final long SIZE_TB = 0x10000000000L;
    private static final long SIZE_PB = 0x4000000000000L;
    private static final DecimalFormat df = new DecimalFormat("###,###,###,###,###,###,###,##0.#");

    private DataSizeFormatter() {
    }

    public String getFormattedSize(long bytes) {
        if (bytes > 0x4000000000000L) {
            return df.format(bytes / 0x4000000000000L) + " PB";
        }
        if (bytes > 0x10000000000L) {
            return df.format(bytes / 0x10000000000L) + " TB";
        }
        if (bytes > 0x40000000L) {
            return df.format(bytes / 0x40000000L) + " GB";
        }
        if (bytes > 0x100000L) {
            return df.format(bytes / 0x100000L) + " MB";
        }
        if (bytes > 1024L) {
            return df.format(bytes / 1024L) + " KB";
        }
        return bytes + " B";
    }
}

