/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.dialog.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import utils.swing.dialog.panels.AbstractDialogPanel;

public class OKCancelDialogPanel
extends AbstractDialogPanel
implements ActionListener {
    private JButton okButton;
    private JButton cancelButton;
    private boolean isOK = false;

    public OKCancelDialogPanel(String okText) {
        if (okText != null) {
            this.okButton = this.addRightButton(okText, true, this);
        }
        this.addListeners();
    }

    public OKCancelDialogPanel(String okText, String cancelText) {
        if (okText != null) {
            this.okButton = this.addRightButton(okText, true, this);
        }
        if (cancelText != null) {
            this.cancelButton = this.addRightButton(cancelText, false, this);
        }
        this.addListeners();
    }

    private void addListeners() {
        if (this.okButton != null) {
            this.okButton.addActionListener(this);
        }
        if (this.cancelButton != null) {
            this.cancelButton.addActionListener(this);
        }
    }

    public void setOkButtonText(String text) {
        this.okButton.setText(text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            this.buttonPressed((JButton)e.getSource());
        }
    }

    public JComponent getInitialFocusComponent() {
        return this.okButton;
    }

    private void buttonPressed(JButton e) {
        if (e == this.okButton) {
            this.okPressed();
        } else if (e == this.cancelButton) {
            this.cancelPressed();
        }
    }

    public boolean isOK() {
        return this.isOK;
    }

    public void cancelPressed() {
        this.finish(false, this.cancelButton);
    }

    private void finish(boolean isOK, JComponent source) {
        this.isOK = isOK;
        if (this.dialogHandler != null) {
            this.dialogHandler.closeDialog(source);
        }
    }

    public void okPressed() {
        this.finish(true, this.okButton);
    }

    public void setOkEnabled(boolean okEnabled) {
        this.okButton.setEnabled(okEnabled);
        this.okButton.repaint();
    }
}

