/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.dialog.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.contents.FixedWidthLabel;
import utils.swing.dialog.panels.DelegateHandler;
import utils.swing.dialog.panels.DialogHandler;
import utils.swing.layout.GbPanel;

public class AbstractDialogPanel
implements DelegateHandler {
    private static final int BUFFER = 10;
    private int panelWidth = 0;
    private JPanel buttonsPanel;
    protected JPanel rootComponent = new JPanel(new BorderLayout());
    protected DialogHandler dialogHandler;
    protected MinimumHeightIcon icon = null;
    protected FixedWidthLabel title = null;
    protected FixedWidthComponent content = null;
    protected ArrayList<JComponent> rightButtons = new ArrayList();
    protected ArrayList<JComponent> leftButtons = new ArrayList();
    private Color backgroundColour = null;
    protected ActionListener genericCloseDialogListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AbstractDialogPanel.this.dialogHandler != null) {
                AbstractDialogPanel.this.dialogHandler.closeDialog((JComponent)e.getSource());
            }
        }
    };
    private static final JLabel resizer = new JLabel();

    public void setPreferredWidth(int width) {
        this.panelWidth = width;
    }

    public void setIcon(Icon icon) {
        if (icon != null) {
            this.icon = new MinimumHeightIcon(icon);
        }
    }

    public void setTitle(String title, boolean bold) {
        if (title != null) {
            this.title = bold ? new FixedWidthLabel("<html><B>" + title + "</B></html>") : new FixedWidthLabel("<html>" + title + "</html>");
        }
    }

    public void setBackground(Color backgroundColour) {
        this.backgroundColour = backgroundColour;
    }

    public void setContent(FixedWidthComponent content) {
        this.content = content;
        if (content != null && this.dialogHandler != null) {
            content.setDialogHandler(this.dialogHandler);
        }
    }

    public JButton addRightButton(String text, boolean isDefaultAction, ActionListener listener) {
        JButton button = this.createButton(text, isDefaultAction, listener);
        if (this.rightButtons.size() == 0) {
            this.rightButtons.add(button);
        } else {
            this.rightButtons.add(0, button);
        }
        return button;
    }

    public void addLeftComponent(JComponent component) {
        this.leftButtons.add(component);
    }

    public JButton addLeftButton(String text, boolean isDefaultAction, ActionListener listener) {
        JButton button = this.createButton(text, isDefaultAction, listener);
        this.leftButtons.add(button);
        return button;
    }

    protected JButton createButton(String text, boolean isDefaultAction, ActionListener listener) {
        JButton button = new JButton(text);
        if (listener != null) {
            button.addActionListener(listener);
        } else {
            button.addActionListener(this.genericCloseDialogListener);
        }
        if (isDefaultAction) {
            SHButtonUI.makeButtonBlue(button);
        }
        return button;
    }

    public void prepareToShow(int width) {
        this.panelWidth = width;
        this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder(20, 20, 20, 20));
        width -= this.rootComponent.getInsets().left + this.rootComponent.getInsets().right;
        if (this.icon != null) {
            this.icon.setVerticalAlignment(1);
            this.icon.setBorder(SHBorderFactory.createEmptyBorder(0, 0, 0, 20));
            width -= this.icon.getPreferredSize().width;
            this.rootComponent.add((Component)this.icon, "West");
        }
        JPanel rightPanel = new JPanel(new BorderLayout());
        if (this.title != null) {
            this.title.setVerticalAlignment(1);
            this.title.setBorder(SHBorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.title.setPreferredWidth(width);
            rightPanel.add((Component)this.title, "North");
        }
        if (this.content != null && this.content instanceof JComponent) {
            rightPanel.add((Component)((JComponent)((Object)this.content)), "Center");
            this.content.setPreferredWidth(width);
        }
        if (this.leftButtons.size() > 0 || this.rightButtons.size() > 0) {
            this.buttonsPanel = new ColorPropagatingPanel(new BorderLayout());
            if (this.leftButtons.size() > 0) {
                GbPanel leftButtonPanel = new GbPanel();
                for (JComponent leftButton : this.leftButtons) {
                    leftButtonPanel.add(leftButton, leftButtonPanel.getComponentCount(), 0, 1, 1, 0, 1, 10, 1, new ScaledInsets(0, 0, 0, 10));
                }
                this.buttonsPanel.add((Component)leftButtonPanel, "West");
            }
            if (this.rightButtons.size() > 0) {
                GbPanel rightButtonPanel = new GbPanel();
                for (JComponent rightButton : this.rightButtons) {
                    rightButtonPanel.add(rightButton, rightButtonPanel.getComponentCount(), 0, 1, 1, 0, 1, 10, 1, new ScaledInsets(0, 10, 0, 0));
                }
                this.buttonsPanel.add((Component)rightButtonPanel, "East");
            }
            this.buttonsPanel.setBorder(SHBorderFactory.createEmptyBorder(10, 0, 0, 0));
            rightPanel.add((Component)this.buttonsPanel, "South");
            if (this.icon != null) {
                this.icon.setMinimumSize(new Dimension(width, this.icon.getPreferredSize().height + this.buttonsPanel.getPreferredSize().height));
            }
        }
        this.rootComponent.add((Component)rightPanel, "Center");
        if (this.backgroundColour != null) {
            this.rootComponent.setBackground(this.backgroundColour);
            if (this.buttonsPanel != null) {
                this.buttonsPanel.setBackground(this.backgroundColour);
            }
        }
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    @Override
    public void setDialogHandler(DialogHandler handler) {
        this.dialogHandler = handler;
        if (this.content != null) {
            this.content.setDialogHandler(this.dialogHandler);
        }
    }

    class MinimumHeightIcon
    extends JLabel {
        public MinimumHeightIcon(Icon icon) {
            super(icon);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension minSize = this.getMinimumSize();
            Dimension size = super.getPreferredSize();
            size.height = Math.max(size.height, minSize.height);
            return size;
        }
    }
}

