/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.dialog.contents;

import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.text.View;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.panels.DialogHandler;

public class FixedWidthLabel
extends JLabel
implements FixedWidthComponent {
    private int panelWidth;

    public FixedWidthLabel(String text) {
        super(text);
        this.setVerticalAlignment(1);
    }

    @Override
    public void setPreferredWidth(int panelWidth) {
        this.panelWidth = panelWidth;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = FixedWidthLabel.getPreferredSize(this, true, this.panelWidth);
        if (dim == null) {
            return super.getPreferredSize();
        }
        return dim;
    }

    public static Dimension getPreferredSize(JLabel html, boolean width, int prefSize) {
        View view = (View)html.getClientProperty("html");
        if (view == null) {
            return null;
        }
        view.setSize(width ? (float)prefSize : 0.0f, width ? 0.0f : (float)prefSize);
        float w = view.getPreferredSpan(0);
        float h = view.getPreferredSpan(1);
        Insets insets = html.getInsets();
        return new Dimension((int)Math.ceil(w), (int)Math.ceil(h + (float)insets.top + (float)insets.bottom));
    }

    @Override
    public void setDialogHandler(DialogHandler handler) {
    }
}

