/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import utils.ostools.OS;
import utils.swing.SafeLookAndFeel;
import utils.swing.aa.AntiAliasingEnforcer;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScalingUtil;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class SimpleHelpFrame
extends JFrame {
    static boolean hasBeenSet = false;
    public static boolean failedToLoad = false;
    private static boolean checkedWindowHeight = false;
    public static int EMPTY_WINDOW_DECORATIONS_HEIGHT = -1;

    @Override
    public void setIconImage(Image image) {
        if (OS.isMacOS()) {
            return;
        }
        super.setIconImage(image);
    }

    public static SimpleHelpFrame getTestFrame() {
        return SimpleHelpFrame.getTestFrame(false);
    }

    public void setSizeUnscaled(int width, int height) {
        super.setSize(width, height);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(SimpleHelpLookAndFeel.scale(width), SimpleHelpLookAndFeel.scale(height));
    }

    public static SimpleHelpFrame getTestFrame(boolean debug) {
        final TestBorder border = new TestBorder();
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setSize(800, 600);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        if (debug) {
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){
                Border lastBorder = null;
                JComponent lastComponent = null;

                @Override
                public void eventDispatched(AWTEvent event) {
                    if (event instanceof MouseEvent && event.getID() == 503) {
                        Object source = event.getSource();
                        if (this.lastComponent != null && this.lastComponent.equals(source)) {
                            return;
                        }
                        if (source instanceof JComponent) {
                            JComponent c = (JComponent)source;
                            if (this.lastComponent != null) {
                                this.lastComponent.setBorder(this.lastBorder);
                                this.lastComponent.repaint();
                            }
                            this.lastComponent = c;
                            this.lastBorder = c.getBorder();
                            border.setBorder(this.lastBorder);
                            c.setBorder(border);
                            c.repaint();
                        } else {
                            System.out.println("Unknown source " + source);
                        }
                    }
                }
            }, 48L);
        }
        return frame;
    }

    public SimpleHelpFrame() {
        this.initFrame();
    }

    public SimpleHelpFrame(String title) {
        super(title);
        this.initFrame();
    }

    private void initFrame() {
        AntiAliasingEnforcer.tryToSetAllFontsAntialiased();
        System.out.println("[SimpleHelpFrame] Active layout support is " + Toolkit.getDefaultToolkit().getDesktopProperty("awt.dynamicLayoutSupported"));
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        SimpleHelpFrame.checkTitleBarHeight(this);
    }

    public static void setLnf() {
        SimpleHelpFrame.setLnf(-1);
    }

    public static void setLnf(int scalingPercentage) {
        try {
            if (!hasBeenSet) {
                System.out.println("[SimpleHelpFrame] Setting LNF as it has not been set before.");
                hasBeenSet = true;
                System.out.println("[SimpleHelpFrame] Setting LNF");
                try {
                    Class<?> shClass = Class.forName("utils.swing.customlaf.SimpleHelpLookAndFeel");
                    int scaling = ScalingUtil.detectScalingPercetange();
                    if (scalingPercentage > 0) {
                        scaling = scalingPercentage;
                    }
                    SimpleHelpLookAndFeel.setScaling(scaling);
                    SimpleHelpLookAndFeel instance = (SimpleHelpLookAndFeel)shClass.newInstance();
                    SafeLookAndFeel.setLookAndFeel(instance);
                    SimpleHelpLookAndFeel.setScaling(scaling);
                    System.out.println("[SimpleHelpFrame] Set LnF succesfully.");
                    UIManager.getLookAndFeelDefaults().put("ClassLoader", SimpleHelpFrame.class.getClassLoader());
                    UIManager.getDefaults().put("ClassLoader", SimpleHelpFrame.class.getClassLoader());
                    instance.postSetupPickIcons();
                    System.out.println("[SimpleHelpFrame] Setting the LnF UI ClassLoader done");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    failedToLoad = true;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            failedToLoad = true;
        }
    }

    public static boolean failedToLoad() {
        return failedToLoad && hasBeenSet;
    }

    public static void checkTitleBarHeight(JFrame frame) {
        if (!checkedWindowHeight) {
            checkedWindowHeight = true;
            frame.pack();
            EMPTY_WINDOW_DECORATIONS_HEIGHT = Math.max(25, frame.getSize().height);
            System.out.println("[SimpleHelpFrame] Toolbar height is " + EMPTY_WINDOW_DECORATIONS_HEIGHT);
        }
    }

    static {
        SimpleHelpFrame.setLnf();
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                Object source;
                if (event instanceof MouseWheelEvent && (source = event.getSource()) != null && source instanceof JScrollPane) {
                    JScrollPane scroll = (JScrollPane)source;
                    for (Container c = scroll.getParent(); c != null; c = c.getParent()) {
                        if (!c.getClass().getName().contains("Popup$HeavyWeightWindow")) continue;
                        MouseWheelEvent sourceEvent = (MouseWheelEvent)event;
                        for (MouseWheelListener listener : (MouseWheelListener[])scroll.getListeners(MouseWheelListener.class)) {
                            listener.mouseWheelMoved(sourceEvent);
                        }
                        sourceEvent.consume();
                        return;
                    }
                }
            }
        }, 131072L);
    }

    static class TestBorder
    implements Border {
        private Border original;
        private Color transparentBlue = new Color(0, 0, 255, 150);
        private Stroke basicStroke = new BasicStroke(10.0f);

        TestBorder() {
        }

        public void setBorder(Border original) {
            this.original = original;
            if (original == null) {
                this.original = SHBorderFactory.createEmptyBorder();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.original.paintBorder(c, g, x, y, width, height);
            Graphics2D g2d = (Graphics2D)g;
            Stroke originalStroke = g2d.getStroke();
            try {
                g2d.setStroke(this.basicStroke);
                g2d.setColor(this.transparentBlue);
                g2d.drawRect(x, y, width, height);
            }
            finally {
                g2d.setStroke(originalStroke);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.original.getBorderInsets(c);
        }

        @Override
        public boolean isBorderOpaque() {
            return this.original.isBorderOpaque();
        }
    }
}

