/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.HSLColor;

public class SHUI {
    public static int TEXT_FIELD_HEIGHT = 28;
    public static final ButtonColor BUTTON_NORMAL = new ButtonColor(SimpleHelpLookAndFeel.isHDPI() ? new Color(90, 140, 232) : new Color(128, 168, 232), new Color(247, 252, 255), new Color(233, 242, 255));
    public static final ButtonColor BUTTON_GREEN = new ButtonColor(new Color(114, 196, 114), new Color(233, 255, 233), new Color(213, 255, 213));
    public static final ButtonColor BUTTON_RED = new ButtonColor(new Color(232, 108, 96), new Color(255, 237, 237), new Color(255, 230, 230));
    public static final ButtonColor BUTTON_BLUE = new ButtonColor(SimpleHelpLookAndFeel.isHDPI() ? new Color(90, 140, 232) : new Color(128, 168, 232), new Color(233, 242, 255), new HSLColor(new Color(233, 242, 255)).adjustTone(-5.0f));
    public static final Color SLIDER_TRACK = new Color(164, 164, 164);
    public static final Color SLIDER_TICKS = new Color(164, 164, 164);
    public static final Color TRACK_FILL = new Color(244, 244, 244);
    public static final Color TRACK_LINE = new Color(200, 200, 200);
    public static final Color SCROLL_BUTTON_ARROW = Color.DARK_GRAY;
    public static final Color CHECKBOX_TICK = Color.DARK_GRAY;
    public static final Color CHECKBOX_TICK_DISABLED = Color.GRAY;
    public static final Color RADIO_BLOB = new Color(144, 170, 210);
    public static final Color RADIO_BLOB_DISABLED = Color.LIGHT_GRAY;
    public static final Color TEXT_BORDER = SimpleHelpLookAndFeel.isHDPI() ? new Color(123, 140, 200) : RADIO_BLOB;
    public static final Color TEXT_BORDER_DISABLED = BUTTON_NORMAL.getDisabledBorder();
    public static final Color DIVIDER_COLOR;
    public static final Color TABLE_HEADER_BORDER;
    public static final Color POPUP_BACKGROUND;
    public static final Color POPUP_BORDER;

    private static final Color disabled(Color c) {
        return new HSLColor(c).adjustSaturation(0.0f);
    }

    static {
        TABLE_HEADER_BORDER = DIVIDER_COLOR = new Color(200, 200, 200);
        POPUP_BACKGROUND = new Color(250, 250, 250);
        POPUP_BORDER = new Color(210, 210, 210);
    }

    public static class ButtonColor {
        public Color border;
        public Color top;
        public Color bottom;
        private Color disabledTop;
        private Color disabledBottom;
        private Color disabledBorder;
        private Color selectedTopAndBottom;

        public ButtonColor(Color border, Color top, Color bottom) {
            this.border = border;
            this.top = top;
            this.bottom = bottom;
        }

        public Color getSelectedBackground() {
            if (this.selectedTopAndBottom == null) {
                this.selectedTopAndBottom = new HSLColor(this.bottom).adjustTone(-5.0f);
            }
            return this.selectedTopAndBottom;
        }

        public Color getDisabledTop() {
            if (this.disabledTop == null) {
                this.disabledTop = new HSLColor(this.top).adjustSaturation(0.0f);
            }
            return this.disabledTop;
        }

        public Color getDisabledBottom() {
            if (this.disabledBottom == null) {
                this.disabledBottom = new HSLColor(this.bottom).adjustSaturation(0.0f);
            }
            return this.disabledBottom;
        }

        public Color getDisabledBorder() {
            if (this.disabledBorder == null) {
                this.disabledBorder = new HSLColor(this.border).adjustSaturation(0.0f);
            }
            return this.disabledBorder;
        }

        public Paint getGradient(boolean enabled, int height, boolean selected) {
            if (enabled) {
                if (selected) {
                    return new GradientPaint(0.0f, 0.0f, this.getSelectedBackground(), 0.0f, height, this.getSelectedBackground());
                }
                return new GradientPaint(0.0f, 0.0f, this.top, 0.0f, height, this.bottom);
            }
            return new GradientPaint(0.0f, 0.0f, this.getDisabledTop(), 0.0f, height, this.getDisabledBottom());
        }
    }
}

