/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JTextArea;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainView;
import javax.swing.text.View;
import utils.swing.components.truncatedarea.TruncatedPlainView;

public class SHTruncatedTextAreaUI
extends BasicTextAreaUI {
    private int lineLimit;
    private ArrayList<WeakReference<TruncatedPlainView>> viewList = new ArrayList();

    public SHTruncatedTextAreaUI(int lineLimit) {
        this.lineLimit = lineLimit;
    }

    @Override
    public View create(Element elem) {
        Document doc = elem.getDocument();
        Object i18nFlag = doc.getProperty("i18n");
        if (i18nFlag != null && i18nFlag.equals(Boolean.TRUE)) {
            return super.create(elem);
        }
        JTextComponent c = this.getComponent();
        if (c instanceof JTextArea) {
            View v;
            JTextArea area = (JTextArea)c;
            if (area.getLineWrap()) {
                v = new TruncatedPlainView(elem, area.getWrapStyleWord(), this.lineLimit);
                this.viewList.add(new WeakReference<TruncatedPlainView>((TruncatedPlainView)v));
            } else {
                v = new PlainView(elem);
            }
            return v;
        }
        return null;
    }

    public void setLineLimit(int lineLimit) {
        this.lineLimit = lineLimit;
        for (WeakReference<TruncatedPlainView> view : this.viewList) {
            if (view.get() == null) continue;
            ((TruncatedPlainView)view.get()).setLineLimit(lineLimit);
        }
    }
}

