/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.plaf.basic.BasicArrowButton;
import utils.swing.customlaf.SHUI;

public class SHScrollButton
extends BasicArrowButton {
    private int buttonWidth;
    private GeneralPath arrowPath;

    public SHScrollButton(int orientation, int width) {
        super(orientation);
        this.buttonWidth = width;
        this.setBorder(null);
        this.setOpaque(false);
        this.setRolloverEnabled(true);
        this.setMargin(new Insets(0, 0, 0, 0));
        int arrowWidth = 6;
        this.arrowPath = new GeneralPath();
        this.arrowPath.moveTo(-arrowWidth / 2, arrowWidth / 4);
        this.arrowPath.lineTo(0.0f, -arrowWidth / 4);
        this.arrowPath.lineTo(arrowWidth / 2, arrowWidth / 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setColor(SHUI.SCROLL_BUTTON_ARROW);
        double theta = 0.0;
        if (this.getDirection() == 5) {
            theta = Math.PI;
        } else if (this.getDirection() == 3) {
            theta = 1.5707963267948966;
        } else if (this.getDirection() == 7) {
            theta = 4.71238898038469;
        }
        AffineTransform oldTransform = g2d.getTransform();
        try {
            g2d.translate(this.getWidth() / 2, this.getHeight() / 2);
            g2d.rotate(theta, 0.0, 0.0);
            g2d.draw(this.arrowPath);
        }
        finally {
            g2d.setTransform(oldTransform);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.buttonWidth, this.buttonWidth);
    }
}

