/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHScrollButton;
import utils.swing.customlaf.SHUI;

public class SHScrollBarUI
extends BasicScrollBarUI {
    public static final int WIDTH = 16;
    private int orientation = -1;
    private boolean isRollover = false;
    private boolean wasRollover = false;

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.scrollbar.setBorder(null);
    }

    public static ComponentUI createUI(JComponent c) {
        return new SHScrollBarUI();
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new SHScrollButton(orientation, 16);
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new SHScrollButton(orientation, 16);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.orientation == -1) {
            this.orientation = this.scrollbar.getOrientation();
        }
        Rectangle trackBounds = this.getTrackBounds();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, 8.0, 8.0);
        g2d.setColor(SHUI.TRACK_FILL);
        g2d.fillRect(0, 0, c.getWidth(), c.getHeight());
        g2d.setColor(SHUI.TRACK_LINE);
        if (this.scrollbar.getOrientation() == 1) {
            g2d.drawLine(0, 0, 0, c.getHeight());
        } else {
            g2d.drawLine(0, 0, c.getWidth(), 0);
        }
        float width = SHButtonUI.getBorderStrokeWidth();
        Rectangle thumbBounds = this.getThumbBounds();
        shape = this.scrollbar.getOrientation() == 1 ? new RoundRectangle2D.Double(thumbBounds.x, thumbBounds.y, (float)thumbBounds.width - width, (float)thumbBounds.height - width, 2.0, 2.0) : new RoundRectangle2D.Double(thumbBounds.x, thumbBounds.y, (float)thumbBounds.width - width, (float)thumbBounds.height - width, 2.0, 2.0);
        g2d.setPaint(SHButtonUI.getFill(SHUI.BUTTON_NORMAL, c.isEnabled(), thumbBounds.height, this.isDragging));
        g2d.fill(shape);
        g2d.setStroke(SHButtonUI.getBorderStroke());
        g2d.setColor(SHButtonUI.getBorderColor(SHUI.BUTTON_NORMAL, c.isEnabled()));
        g2d.draw(shape);
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new MyTrackListener();
    }

    protected class MyTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected MyTrackListener() {
            super(SHScrollBarUI.this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            SHScrollBarUI.this.scrollbar.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            SHScrollBarUI.this.scrollbar.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SHScrollBarUI.this.isRollover = false;
            SHScrollBarUI.this.wasRollover = false;
            if (SHScrollBarUI.this.getThumbBounds().contains(e.getX(), e.getY())) {
                SHScrollBarUI.this.isRollover = true;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SHScrollBarUI.this.isRollover = false;
            if (SHScrollBarUI.this.isRollover != SHScrollBarUI.this.wasRollover) {
                SHScrollBarUI.this.scrollbar.repaint();
                SHScrollBarUI.this.wasRollover = SHScrollBarUI.this.isRollover;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SHScrollBarUI.this.getThumbBounds().contains(e.getX(), e.getY())) {
                SHScrollBarUI.this.isRollover = true;
            }
            super.mouseDragged(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (SHScrollBarUI.this.getThumbBounds().contains(e.getX(), e.getY())) {
                SHScrollBarUI.this.isRollover = true;
                if (!SHScrollBarUI.this.wasRollover) {
                    SHScrollBarUI.this.scrollbar.repaint();
                    SHScrollBarUI.this.wasRollover = SHScrollBarUI.this.isRollover;
                }
            } else {
                SHScrollBarUI.this.isRollover = false;
                if (SHScrollBarUI.this.wasRollover) {
                    SHScrollBarUI.this.scrollbar.repaint();
                    SHScrollBarUI.this.wasRollover = SHScrollBarUI.this.isRollover;
                }
            }
        }
    }
}

