/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import sun.swing.SwingUtilities2;
import utils.ostools.OS;
import utils.swing.customlaf.SHUI;

public class SHButtonUI
extends BasicButtonUI {
    private static final Object KEY_COLOR = "color";
    private static final Object VALUE_COLOR_RED = 1;
    private static final Object VALUE_COLOR_GREEN = 2;
    private static final Object VALUE_COLOR_BLUE = 3;
    private static final Object VALUE_COLOR_NAKED = 4;
    private static final Object KEY_SEGMENTED = "segmented";
    private static final Object VALUE_SEGMENTED_LEFT = 1;
    private static final Object VALUE_SEGMENTED_CENTER = 2;
    private static final Object VALUE_SEGMENTED_RIGHT = 3;
    private static final Object VALUE_SEGMENTED_TOP = 4;
    private static final Object VALUE_SEGMENTED_MIDDLE = 5;
    private static final Object VALUE_SEGMENTED_BOTTOM = 6;
    private static final SHButtonUI buttonUI = new SHButtonUI();
    private static final Stroke borderStrokeHiDPI = new BasicStroke(0.5f);
    private static final Stroke borderStroke = new BasicStroke(1.0f);

    public static ComponentUI createUI(final JComponent c) {
        JButton b = (JButton)c;
        b.setRolloverEnabled(true);
        c.setOpaque(false);
        c.addPropertyChangeListener("opaque", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                c.setOpaque(false);
            }
        });
        return buttonUI;
    }

    public static Stroke getBorderStroke() {
        if (OS.isOSXRetina()) {
            return borderStrokeHiDPI;
        }
        return borderStroke;
    }

    public static float getBorderStrokeWidth() {
        if (OS.isOSXRetina()) {
            return 0.5f;
        }
        return 1.0f;
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }

    public static Color getBorderColor(SHUI.ButtonColor button, boolean enabled) {
        if (enabled) {
            return button.border;
        }
        return button.getDisabledBorder();
    }

    public static Paint getFill(SHUI.ButtonColor color, boolean enabled, int height, boolean isSelected) {
        return color.getGradient(enabled, height, isSelected);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        if (button.isContentAreaFilled()) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            float stroke = SHButtonUI.getBorderStrokeWidth();
            float height = (float)button.getHeight() - stroke;
            Object segmentedProperty = button.getClientProperty(KEY_SEGMENTED);
            RoundRectangle2D.Double shape = segmentedProperty == null ? new RoundRectangle2D.Double(0.0, 0.0, (float)button.getWidth() - stroke, height, 2.0, 2.0) : (segmentedProperty == VALUE_SEGMENTED_LEFT ? new RoundRectangle2D.Double(0.0, 0.0, button.getWidth() + 10, height, 2.0, 2.0) : (segmentedProperty == VALUE_SEGMENTED_CENTER ? new RoundRectangle2D.Double(-5.0, 0.0, button.getWidth() + 10, height, 2.0, 2.0) : (segmentedProperty == VALUE_SEGMENTED_RIGHT ? new RoundRectangle2D.Double(-5.0, 0.0, button.getWidth() + 4, height, 2.0, 2.0) : (segmentedProperty == VALUE_SEGMENTED_TOP ? new RoundRectangle2D.Double(0.0, 0.0, (float)button.getWidth() - stroke, height + 10.0f, 2.0, 2.0) : (segmentedProperty == VALUE_SEGMENTED_MIDDLE ? new RoundRectangle2D.Double(0.0, -5.0, (float)button.getWidth() - stroke, height + 10.0f, 2.0, 2.0) : new RoundRectangle2D.Double(0.0, -5.0, (float)button.getWidth() - stroke, height + 4.0f, 2.0, 2.0))))));
            Paint fill = this.getFill(button);
            if (fill != null) {
                g2d.setPaint(fill);
                g2d.fill(shape);
            }
            g2d.setStroke(SHButtonUI.getBorderStroke());
            g2d.setColor(this.getBorderColor(button));
            g2d.draw(shape);
            if (segmentedProperty != null) {
                if (segmentedProperty == VALUE_SEGMENTED_LEFT || segmentedProperty == VALUE_SEGMENTED_CENTER) {
                    g2d.draw(new Line2D.Float(button.getWidth() - 1, 0.0f, (float)button.getWidth() - stroke, height));
                } else if (segmentedProperty == VALUE_SEGMENTED_TOP || segmentedProperty == VALUE_SEGMENTED_MIDDLE) {
                    g2d.draw(new Line2D.Float(0.0f, (float)button.getHeight() - stroke, button.getWidth(), (float)button.getHeight() - stroke));
                }
            }
        }
        super.paint(g, c);
    }

    private Paint getFill(AbstractButton button) {
        boolean darker = button.getModel().isSelected() || button.getModel().isArmed();
        Object colorProperty = button.getClientProperty(KEY_COLOR);
        if (button.isEnabled() && colorProperty != null) {
            if (colorProperty == VALUE_COLOR_BLUE) {
                return SHButtonUI.getFill(SHUI.BUTTON_BLUE, button.getModel().isEnabled(), button.getHeight(), darker);
            }
            if (colorProperty == VALUE_COLOR_GREEN) {
                return SHButtonUI.getFill(SHUI.BUTTON_GREEN, button.getModel().isEnabled(), button.getHeight(), darker);
            }
            if (colorProperty == VALUE_COLOR_RED) {
                return SHButtonUI.getFill(SHUI.BUTTON_RED, button.getModel().isEnabled(), button.getHeight(), darker);
            }
            if (colorProperty == VALUE_COLOR_NAKED) {
                return Color.WHITE;
            }
        }
        return SHButtonUI.getFill(SHUI.BUTTON_NORMAL, button.getModel().isEnabled(), button.getHeight(), darker);
    }

    private Color getBorderColor(AbstractButton button) {
        Object colorProperty = button.getClientProperty(KEY_COLOR);
        if (colorProperty != null) {
            if (colorProperty == VALUE_COLOR_BLUE) {
                return SHButtonUI.getBorderColor(SHUI.BUTTON_BLUE, button.getModel().isEnabled());
            }
            if (colorProperty == VALUE_COLOR_GREEN) {
                return SHButtonUI.getBorderColor(SHUI.BUTTON_GREEN, button.getModel().isEnabled());
            }
            if (colorProperty == VALUE_COLOR_RED) {
                return SHButtonUI.getBorderColor(SHUI.BUTTON_RED, button.getModel().isEnabled());
            }
        }
        return SHButtonUI.getBorderColor(SHUI.BUTTON_NORMAL, button.getModel().isEnabled());
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    public static void makeButtonNormal(JButton button) {
        button.putClientProperty(KEY_COLOR, null);
    }

    public static void makeButtonRed(JButton button) {
        button.putClientProperty(KEY_COLOR, VALUE_COLOR_RED);
    }

    public static void makeButtonGreen(JButton button) {
        button.putClientProperty(KEY_COLOR, VALUE_COLOR_GREEN);
    }

    public static void makeButtonBlue(JButton button) {
        button.putClientProperty(KEY_COLOR, VALUE_COLOR_BLUE);
    }

    public static void makeButtonSegmentedRight(AbstractButton button) {
        button.putClientProperty(KEY_SEGMENTED, VALUE_SEGMENTED_RIGHT);
    }

    public static void makeButtonSegmentedLeft(AbstractButton button) {
        button.putClientProperty(KEY_SEGMENTED, VALUE_SEGMENTED_LEFT);
    }

    public static void makeButtonSegmentedCenter(AbstractButton button) {
        button.putClientProperty(KEY_SEGMENTED, VALUE_SEGMENTED_CENTER);
    }

    public static void makeButtonNaked(JButton button) {
        button.putClientProperty(KEY_COLOR, VALUE_COLOR_NAKED);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g);
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        } else {
            g.setColor(b.getBackground().brighter());
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset() + 1);
            g.setColor(b.getBackground().darker());
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        }
    }

    public static class SegmentedButtonGroup {
        private AbstractButton previousButton = null;
        private byte buttonCount = 0;
        private boolean vertical;

        public SegmentedButtonGroup() {
            this(false);
        }

        public SegmentedButtonGroup(boolean vertical) {
            this.vertical = vertical;
        }

        public static void createSegmentedButtonGroup(boolean vertical, AbstractButton[] buttons) {
            SegmentedButtonGroup group = new SegmentedButtonGroup(vertical);
            for (AbstractButton button : buttons) {
                group.addButton(button);
            }
        }

        public static void createSegmentedButtonGroup(AbstractButton b1, AbstractButton b2) {
            SegmentedButtonGroup.createSegmentedButtonGroup(false, b1, b2);
        }

        public static void createSegmentedButtonGroup(boolean vertical, AbstractButton b1, AbstractButton b2) {
            SegmentedButtonGroup group = new SegmentedButtonGroup(vertical);
            group.addButton(b1);
            group.addButton(b2);
        }

        public static void createSegmentedButtonGroup(AbstractButton[] buttons) {
            SegmentedButtonGroup.createSegmentedButtonGroup(false, buttons);
        }

        public void addButton(AbstractButton button) {
            if (!this.vertical) {
                if (this.buttonCount == 0) {
                    button.putClientProperty(KEY_SEGMENTED, VALUE_SEGMENTED_LEFT);
                } else if (this.buttonCount == 1) {
                    button.putClientProperty(KEY_SEGMENTED, VALUE_SEGMENTED_RIGHT);
                } else {
                    button.putClientProperty(KEY_SEGMENTED, VALUE_SEGMENTED_RIGHT);
                    this.previousButton.putClientProperty(KEY_SEGMENTED, VALUE_SEGMENTED_CENTER);
                }
            } else if (this.buttonCount == 0) {
                button.putClientProperty(KEY_SEGMENTED, VALUE_SEGMENTED_TOP);
            } else if (this.buttonCount == 1) {
                button.putClientProperty(KEY_SEGMENTED, VALUE_SEGMENTED_BOTTOM);
            } else {
                button.putClientProperty(KEY_SEGMENTED, VALUE_SEGMENTED_BOTTOM);
                this.previousButton.putClientProperty(KEY_SEGMENTED, VALUE_SEGMENTED_MIDDLE);
            }
            this.previousButton = button;
            this.buttonCount = (byte)(this.buttonCount + 1);
        }
    }
}

